/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.openai;

import com.dbeaver.model.ai.AICompletionJoinRule;
import java.util.Collection;
import java.util.List;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.ai.gpt3.GPTCompletionEngine;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.format.SQLFormatUtils;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class GPTCompletionEngineAdvanced
extends GPTCompletionEngine {
    private static final Log log = Log.getLog(GPTCompletionEngineAdvanced.class);

    protected void addPromptExtra(DBRProgressMonitor monitor, DBSEntity object, StringBuilder description, boolean firstAttr) throws DBException {
        Collection associations;
        if (DBWorkbench.getPlatform().getPreferenceStore().getBoolean("ai.useConstraints") && (associations = object.getConstraints(monitor)) != null) {
            for (DBSEntityConstraint association : associations) {
                List refAttrs;
                if (association.getConstraintType() != DBSEntityConstraintType.PRIMARY_KEY || CommonUtils.isEmpty((Collection)(refAttrs = ((DBSEntityReferrer)association).getAttributeReferences(monitor)))) continue;
                if (!firstAttr) {
                    description.append(",");
                }
                firstAttr = false;
                description.append("PRIMARY KEY(");
                boolean firstRA = true;
                for (DBSEntityAttributeRef ar : refAttrs) {
                    if (ar.getAttribute() == null) continue;
                    if (!firstRA) {
                        description.append(",");
                    }
                    firstRA = false;
                    description.append(ar.getAttribute().getName());
                }
                description.append(")");
                break;
            }
        }
        if (DBWorkbench.getPlatform().getPreferenceStore().getBoolean("ai.useForeignKeys") && (associations = object.getAssociations(monitor)) != null) {
            for (DBSEntityConstraint association : associations) {
                if (!(association instanceof DBSEntityReferrer)) continue;
                DBSEntity refEntity = association.getAssociatedEntity();
                List refAttrs = ((DBSEntityReferrer)association).getAttributeReferences(monitor);
                if (refEntity == null || CommonUtils.isEmpty((Collection)refAttrs)) continue;
                if (!firstAttr) {
                    description.append(",");
                }
                firstAttr = false;
                description.append("FOREIGN KEY(");
                boolean firstRA = true;
                for (DBSEntityAttributeRef ar : refAttrs) {
                    if (ar.getAttribute() == null) continue;
                    if (!firstRA) {
                        description.append(",");
                    }
                    firstRA = false;
                    description.append(ar.getAttribute().getName());
                }
                description.append(") REFERENCES ").append(refEntity.getName());
            }
        }
    }

    protected String postProcessPrompt(DBRProgressMonitor monitor, DBSObjectContainer mainObject, DBCExecutionContext executionContext, String promptText) {
        AICompletionJoinRule joinRule = (AICompletionJoinRule)CommonUtils.valueOf(AICompletionJoinRule.class, (String)DBWorkbench.getPlatform().getPreferenceStore().getString("ai.joinRule"), (Enum)AICompletionJoinRule.DEFAULT);
        switch (joinRule) {
            case JOIN: {
                return String.valueOf(promptText) + ",use joins";
            }
            case SUB_QUERY: {
                return String.valueOf(promptText) + ",use sub queries";
            }
        }
        return promptText;
    }

    protected String postProcessGeneratedQuery(DBRProgressMonitor monitor, DBSObjectContainer mainObject, DBCExecutionContext executionContext, String completionText) {
        if (DBWorkbench.getPlatform().getPreferenceStore().getBoolean("ai.formatSqlQuery")) {
            completionText = SQLFormatUtils.formatSQL((DBPDataSource)executionContext.getDataSource(), (String)completionText);
        }
        return completionText;
    }
}

