/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.fluentcore.policy;

import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.management.AzureEnvironment;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import java.util.Arrays;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class AuxiliaryAuthenticationPolicy
implements HttpPipelinePolicy {
    private static final String AUTHORIZATION_AUXILIARY_HEADER = "x-ms-authorization-auxiliary";
    private static final String SCHEMA_FORMAT = "Bearer %s";
    private final TokenCredential[] tokenCredentials;
    private final AzureEnvironment environment;

    public AuxiliaryAuthenticationPolicy(AzureEnvironment environment, TokenCredential ... credentials) {
        this.environment = environment;
        this.tokenCredentials = credentials;
    }

    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        if (this.tokenCredentials == null || this.tokenCredentials.length == 0) {
            return next.process();
        }
        return Flux.fromIterable(Arrays.asList(this.tokenCredentials)).flatMap(credential -> {
            String defaultScope = ResourceManagerUtils.getDefaultScopeFromRequest(context.getHttpRequest(), this.environment);
            return credential.getToken(new TokenRequestContext().addScopes(new String[]{defaultScope})).map(token -> String.format(SCHEMA_FORMAT, token.getToken()));
        }).collectList().flatMap(tokenList -> {
            context.getHttpRequest().setHeader(AUTHORIZATION_AUXILIARY_HEADER, String.join((CharSequence)",", tokenList));
            return next.process();
        });
    }
}

