/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.hana.sqlgenerator;

import java.util.ArrayList;
import java.util.Objects;
import liquibase.database.Database;
import liquibase.datatype.DataTypeFactory;
import liquibase.datatype.DatabaseDataType;
import liquibase.datatype.LiquibaseDataType;
import liquibase.ext.hana.HanaDatabase;
import liquibase.ext.hana.util.LiquibaseHanaUtil;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.ModifyDataTypeGenerator;
import liquibase.statement.core.ModifyDataTypeStatement;
import liquibase.structure.DatabaseObject;

public class ModifyDataTypeGeneratorHana
extends ModifyDataTypeGenerator {
    public int getPriority() {
        return 5;
    }

    public boolean supports(ModifyDataTypeStatement statement, Database database) {
        return database instanceof HanaDatabase;
    }

    public Sql[] generateSql(ModifyDataTypeStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ArrayList<UnparsedSql> sqls = new ArrayList<UnparsedSql>();
        String alterTableBase = "ALTER TABLE " + database.escapeTableName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName());
        alterTableBase = alterTableBase + " ALTER (";
        alterTableBase = alterTableBase + database.escapeColumnName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName(), statement.getColumnName());
        DatabaseDataType newDataType = DataTypeFactory.getInstance().fromDescription(statement.getNewDataType(), database).toDatabaseDataType(database);
        DatabaseDataType oldDataType = LiquibaseHanaUtil.getColumnDataType(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName(), statement.getColumnName(), database);
        if (oldDataType != null && !this.isConvertible(oldDataType.toString(), newDataType.toString(), database)) {
            if (this.isNumberType(oldDataType.toString())) {
                sqls.add(new UnparsedSql(alterTableBase + " decimal)", new DatabaseObject[]{this.getAffectedTable(statement)}));
            } else if (this.isStringType(oldDataType.toString())) {
                sqls.add(new UnparsedSql(alterTableBase + " nclob)", new DatabaseObject[]{this.getAffectedTable(statement)}));
            }
        }
        sqls.add(new UnparsedSql(alterTableBase + " " + newDataType + ")", new DatabaseObject[]{this.getAffectedTable(statement)}));
        return sqls.toArray(new Sql[sqls.size()]);
    }

    private boolean isConvertible(String sourceType, String targetType, Database database) {
        LiquibaseDataType liquibaseTargetType;
        if (Objects.equals(sourceType, targetType)) {
            return true;
        }
        if (sourceType == null || targetType == null) {
            return true;
        }
        if ("bigint".equals(sourceType) ? "integer".equals(targetType) || "smallint".equals(targetType) || "tinyint".equals(targetType) : ("integer".equals(sourceType) ? "smallint".equals(targetType) || "tinyint".equals(targetType) : ("smallint".equals(sourceType) ? "tinyint".equals(targetType) : "double".equals(sourceType) && "real".equals(targetType)))) {
            return false;
        }
        LiquibaseDataType liquibaseSourceType = DataTypeFactory.getInstance().fromDescription(sourceType, database);
        return !("float".equals(liquibaseSourceType.getName()) ? "real".equals(targetType) : ("varchar".equals(liquibaseSourceType.getName()) || "nvarchar".equals(liquibaseSourceType.getName()) ? ("varchar".equals((liquibaseTargetType = DataTypeFactory.getInstance().fromDescription(targetType, database)).getName()) || "nvarchar".equals(liquibaseTargetType.getName())) && this.getCharTypeLength(liquibaseSourceType) > this.getCharTypeLength(liquibaseTargetType) : "decimal".equals(liquibaseSourceType.getName()) && "decimal".equals((liquibaseTargetType = DataTypeFactory.getInstance().fromDescription(targetType, database)).getName()) && (this.getDecimalTypePrecision(liquibaseSourceType) > this.getDecimalTypePrecision(liquibaseTargetType) || this.getDecimalTypeScale(liquibaseSourceType) > this.getDecimalTypeScale(liquibaseTargetType))));
    }

    private boolean isNumberType(String type) {
        return type != null && ("bigint".equals(type) || "integer".equals(type) || "smallint".equals(type) || "tinyint".equals(type) || type.startsWith("float") || "real".equals(type) || "double".equals(type) || type.startsWith("decimal"));
    }

    private boolean isStringType(String type) {
        return type != null && (type.startsWith("varchar") || type.startsWith("nvarchar") || "clob".equals(type) || "nclob".equals(type));
    }

    private int getCharTypeLength(LiquibaseDataType type) {
        if (type.getParameters().length < 1) {
            return 1;
        }
        Object parameter = type.getParameters()[0];
        if (parameter == null) {
            return 1;
        }
        return Integer.parseInt(parameter.toString());
    }

    private int getDecimalTypePrecision(LiquibaseDataType type) {
        if (type.getParameters().length < 1) {
            return 34;
        }
        Object parameter = type.getParameters()[0];
        if (parameter == null) {
            return 34;
        }
        return Integer.parseInt(parameter.toString());
    }

    private int getDecimalTypeScale(LiquibaseDataType type) {
        if (type.getParameters().length < 2) {
            return 0;
        }
        Object parameter = type.getParameters()[1];
        if (parameter == null) {
            return 0;
        }
        return Integer.parseInt(parameter.toString());
    }
}

