/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jgssp2tdnego;

import com.teradata.tdgss.asn1.der.DER;
import com.teradata.tdgss.asn1.der.ListArray;
import com.teradata.tdgss.jgssp2tdnego.NegMechHashTable;
import org.ietf.jgss.Oid;

public class NegTokenResp {
    public static final int NEG_STATE_INVALID = 0;
    public static final int NEG_STATE_COMPLETED = 1;
    public static final int NEG_STATE_INCOMPLETE = 2;
    public static final int NEG_STATE_REJECT = 3;
    public static final int NEG_STATE_REQUEST_MIC = 4;
    public static final int NEG_STATE_INVALID_LAST = 5;
    private NegMechHashTable negMechHashTable;
    private int negState;
    private Oid negMechSelected;
    private boolean isNegMechSelected = false;
    private int negPolicyApplied;
    private boolean isNegPolicyApplied = false;
    static /* synthetic */ Class class$com$teradata$tdgss$asn1$der$DER;

    public NegMechHashTable getNegMechHashTable() {
        return this.negMechHashTable;
    }

    public void setNegMechHashTable(NegMechHashTable negMechHashTable) {
        this.negMechHashTable = negMechHashTable;
    }

    public int getNegState() {
        return this.negState;
    }

    public void setNegState(int n) {
        if (0 >= n || n >= 5) {
            throw new IllegalArgumentException("Invalid Negotiation State.");
        }
        this.negState = n;
    }

    public Oid getNegMechSelected() {
        if (this.isNegMechSelected()) {
            return this.negMechSelected;
        }
        return null;
    }

    public void setNegMechSelected(Oid oid) {
        this.negMechSelected = oid;
        this.isNegMechSelected = true;
    }

    public boolean getNegPolicyApplied() {
        return this.negPolicyApplied == 1;
    }

    public void setNegPolicyApplied(boolean bl) {
        this.negPolicyApplied = bl ? 1 : 0;
        this.isNegPolicyApplied = true;
    }

    public boolean isNegMechSelected() {
        return this.isNegMechSelected;
    }

    public boolean isNegPolicyApplied() {
        return this.isNegPolicyApplied;
    }

    public DER getDERObject() {
        DER dER = new DER(1, new ListArray(class$com$teradata$tdgss$asn1$der$DER == null ? (class$com$teradata$tdgss$asn1$der$DER = NegTokenResp.class$("com.teradata.tdgss.asn1.der.DER")) : class$com$teradata$tdgss$asn1$der$DER));
        DER dER2 = this.negMechHashTable.getDERObject();
        dER.add(dER2);
        dER.add(new DER(1, (long)this.negState));
        if (this.isNegMechSelected()) {
            dER.add(new DER(2, this.negMechSelected));
        }
        if (this.isNegPolicyApplied()) {
            dER.add(new DER(3, (long)this.negPolicyApplied));
        }
        return dER;
    }

    public void parseDERObject(DER dER) {
        DER dER2;
        if (dER.getTagNumber() != 1) {
            throw new IllegalArgumentException("Negotiation Response token's tag is not valid");
        }
        DER dER3 = dER.getChildrenWithTag(0);
        if (dER3 == null) {
            throw new IllegalArgumentException("Tag NEGTOKENRESP_TAG_NEGMECHLIST is not found.");
        }
        this.negMechHashTable = new NegMechHashTable();
        this.negMechHashTable.parseDERObject(dER3);
        DER dER4 = dER.getChildrenWithTag(1);
        if (dER4 == null) {
            throw new IllegalArgumentException("Tag NEGTOKENRESP_TAG_NEGSTATE is not found.");
        }
        this.negState = (int)dER4.getValueAsInt();
        DER dER5 = dER.getChildrenWithTag(2);
        if (dER5 != null) {
            this.setNegMechSelected(dER5.getValueAsOid());
        }
        if ((dER2 = dER.getChildrenWithTag(3)) != null) {
            if (dER2.getValueAsInt() == 0L) {
                this.setNegPolicyApplied(false);
            } else {
                this.setNegPolicyApplied(true);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

