/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.net.auth.google;

import com.google.api.client.http.HttpRequestInitializer;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.sql.CredentialFactory;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;

public class ServiceAccountCredentialsFactory
implements CredentialFactory {
    private static volatile String staticCredentialsPath;
    private static volatile String staticToken;

    public static synchronized String getStaticCredentialsPath() {
        return staticCredentialsPath;
    }

    public static synchronized void setStaticCredentialsPath(String staticCredentialsPath) {
        ServiceAccountCredentialsFactory.staticCredentialsPath = staticCredentialsPath;
    }

    public static synchronized String getStaticToken() {
        return staticToken;
    }

    public static synchronized void setStaticToken(String staticToken) {
        ServiceAccountCredentialsFactory.staticToken = staticToken;
    }

    public HttpRequestInitializer create() {
        GoogleCredentials credentials;
        block11: {
            credentials = null;
            try {
                if (staticToken != null) {
                    credentials = GoogleCredentials.create((AccessToken)new AccessToken(staticToken, null));
                }
                if (credentials != null) break block11;
                if (staticCredentialsPath == null) {
                    credentials = GoogleCredentials.getApplicationDefault();
                    break block11;
                }
                try (InputStream is = Files.newInputStream(Path.of(staticCredentialsPath, new String[0]), new OpenOption[0]);){
                    credentials = GoogleCredentials.fromStream((InputStream)is);
                }
            }
            catch (IOException err) {
                throw new RuntimeException("Unable to obtain credentials to communicate with the Cloud SQL API", err);
            }
        }
        if (credentials.createScopedRequired()) {
            credentials = credentials.createScoped(Arrays.asList("https://www.googleapis.com/auth/sqlservice.admin", "https://www.googleapis.com/auth/cloud-platform"));
        }
        return new HttpCredentialsAdapter((Credentials)credentials);
    }
}

