/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.util;

import com.couchbase.client.core.annotation.Stability;
import java.time.Duration;
import java.util.Objects;

@Stability.Internal
public class NanoTimestamp
implements Comparable<NanoTimestamp> {
    private static final NanoTimestamp NEVER = new NanoTimestamp(System.nanoTime() - 0x3FFFFFFFFFFFFFFFL);
    private final long nanoTime;

    private NanoTimestamp(long nanoTime) {
        this.nanoTime = nanoTime;
    }

    public static NanoTimestamp now() {
        return new NanoTimestamp(System.nanoTime());
    }

    public static NanoTimestamp never() {
        return NEVER;
    }

    public boolean isNever() {
        return this == NEVER;
    }

    @Override
    public int compareTo(NanoTimestamp o) {
        long difference = this.nanoTime - o.nanoTime;
        if (difference < 0L) {
            return -1;
        }
        if (difference > 0L) {
            return 1;
        }
        return 0;
    }

    public Duration elapsed() {
        return Duration.ofNanos(System.nanoTime() - this.nanoTime);
    }

    public boolean hasElapsed(Duration d) {
        return this.elapsed().compareTo(d) >= 0;
    }

    public Duration minus(NanoTimestamp rhs) {
        return Duration.ofNanos(this.nanoTime - rhs.nanoTime);
    }

    public String toString() {
        return "NanoTimestamp{elapsed=" + this.elapsed() + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NanoTimestamp that = (NanoTimestamp)o;
        return this.nanoTime == that.nanoTime;
    }

    public int hashCode() {
        return Objects.hash(this.nanoTime);
    }
}

