/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.transaction.forwards;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.transaction.forwards.ForwardCompatBehaviour;
import com.couchbase.client.core.transaction.forwards.ForwardCompatBehaviourFull;
import com.couchbase.client.core.transaction.forwards.ForwardCompatExtensionRequirement;
import com.couchbase.client.core.transaction.forwards.ForwardCompatProtocolRequirement;
import com.couchbase.client.core.transaction.forwards.ForwardCompatRequirement;
import com.couchbase.client.core.transaction.forwards.Supported;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Stability.Internal
class ForwardCompatibilityForStage {
    private final List<ForwardCompatRequirement> bases = new ArrayList<ForwardCompatRequirement>();

    ForwardCompatibilityForStage(JsonNode array) {
        Objects.requireNonNull(array);
        for (JsonNode o : array) {
            if (o.has("e") && o.has("b")) {
                this.bases.add(new ForwardCompatExtensionRequirement(o));
                continue;
            }
            if (!o.has("p") || !o.has("b")) continue;
            this.bases.add(new ForwardCompatProtocolRequirement(o));
        }
    }

    public ForwardCompatBehaviourFull behaviour(Supported supported) {
        for (ForwardCompatRequirement b : this.bases) {
            ForwardCompatBehaviourFull be = b.behaviour(supported);
            if (be.behaviour == ForwardCompatBehaviour.CONTINUE) continue;
            return be;
        }
        return ForwardCompatBehaviourFull.CONTINUE;
    }
}

