/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.kv;

import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.DefaultErrorUtil;
import com.couchbase.client.core.error.DocumentExistsException;
import com.couchbase.client.core.error.context.KeyValueErrorContext;
import com.couchbase.client.core.msg.BaseResponse;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.kv.MutationToken;
import com.couchbase.client.core.msg.kv.SubDocumentField;
import com.couchbase.client.core.msg.kv.SubdocMutateRequest;
import java.util.Arrays;
import java.util.Optional;

public class SubdocMutateResponse
extends BaseResponse {
    private final SubDocumentField[] values;
    private final long cas;
    private final Optional<MutationToken> mutationToken;
    private final Optional<CouchbaseException> error;

    public SubdocMutateResponse(ResponseStatus status, Optional<CouchbaseException> error, SubDocumentField[] values, long cas, Optional<MutationToken> mutationToken) {
        super(status);
        this.error = error;
        this.values = values;
        this.cas = cas;
        this.mutationToken = mutationToken;
    }

    public SubDocumentField[] values() {
        return this.values;
    }

    public long cas() {
        return this.cas;
    }

    public Optional<MutationToken> mutationToken() {
        return this.mutationToken;
    }

    public Optional<CouchbaseException> error() {
        return this.error;
    }

    public CouchbaseException throwError(SubdocMutateRequest request, boolean insertDocument) {
        KeyValueErrorContext ctx = KeyValueErrorContext.completedRequest(request, this.status());
        if (insertDocument && (this.status() == ResponseStatus.EXISTS || this.status() == ResponseStatus.NOT_STORED)) {
            return new DocumentExistsException(ctx);
        }
        if (this.status() == ResponseStatus.SUBDOC_FAILURE && this.error().isPresent()) {
            return this.error().get();
        }
        return DefaultErrorUtil.keyValueStatusToException(request, this);
    }

    @Override
    public String toString() {
        return "SubdocMutateResponse{values=" + Arrays.asList(this.values) + ", cas=" + this.cas + '}';
    }
}

