/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.manager;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.config.CollectionsManifest;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.endpoint.http.CoreHttpClient;
import com.couchbase.client.core.endpoint.http.CoreHttpPath;
import com.couchbase.client.core.endpoint.http.CoreHttpRequest;
import com.couchbase.client.core.endpoint.http.CoreHttpResponse;
import com.couchbase.client.core.error.CollectionExistsException;
import com.couchbase.client.core.error.CollectionNotFoundException;
import com.couchbase.client.core.error.FeatureNotAvailableException;
import com.couchbase.client.core.error.HttpStatusCodeException;
import com.couchbase.client.core.error.ScopeExistsException;
import com.couchbase.client.core.error.ScopeNotFoundException;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.msg.RequestTarget;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.util.CbCollections;
import com.couchbase.client.core.util.CbThrowables;
import com.couchbase.client.core.util.UrlQueryStringBuilder;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

@Stability.Internal
public class CoreCollectionManager {
    private final String bucketName;
    private final Core core;
    private final CoreHttpClient httpClient;

    public CoreCollectionManager(Core core, String bucketName) {
        this.bucketName = Objects.requireNonNull(bucketName);
        this.core = core;
        this.httpClient = core.httpClient(RequestTarget.manager());
    }

    private static CoreHttpPath pathForScopes(String bucketName) {
        return CoreHttpPath.path("/pools/default/buckets/{bucketName}/scopes", CbCollections.mapOf("bucketName", bucketName));
    }

    private static CoreHttpPath pathForScope(String bucketName, String scopeName) {
        return CoreHttpPath.path("/pools/default/buckets/{bucketName}/scopes/{scopeName}", CbCollections.mapOf("bucketName", bucketName, "scopeName", scopeName));
    }

    private static CoreHttpPath pathForCollections(String bucketName, String scopeName) {
        return CoreHttpPath.path("/pools/default/buckets/{bucketName}/scopes/{scopeName}/collections", CbCollections.mapOf("bucketName", bucketName, "scopeName", scopeName));
    }

    private static CoreHttpPath pathForCollection(String bucketName, String scopeName, String collectionName) {
        return CoreHttpPath.path("/pools/default/buckets/{bucketName}/scopes/{scopeName}/collections/{collectionName}", CbCollections.mapOf("bucketName", bucketName, "scopeName", scopeName, "collectionName", collectionName));
    }

    public CompletableFuture<Void> createCollection(String scopeName, String collectionName, Duration maxTTL, CoreCommonOptions options) {
        UrlQueryStringBuilder form = CoreHttpRequest.Builder.newForm().set("name", collectionName);
        if (maxTTL != null && !maxTTL.isZero()) {
            form.set("maxTTL", maxTTL.getSeconds());
        }
        return ((CompletableFuture)this.httpClient.post(CoreCollectionManager.pathForCollections(this.bucketName, scopeName), options).trace("manager_collections_create_collection").traceBucket(this.bucketName).traceScope(scopeName).traceCollection(collectionName).form(form).exec(this.core).exceptionally((Function)CoreCollectionManager.translateErrors(scopeName, collectionName))).thenApply(response -> null);
    }

    public CompletableFuture<Void> createScope(String scopeName, CoreCommonOptions options) {
        return ((CompletableFuture)this.httpClient.post(CoreCollectionManager.pathForScopes(this.bucketName), options).trace("manager_collections_create_scope").traceBucket(this.bucketName).traceScope(scopeName).form(CoreHttpRequest.Builder.newForm().add("name", scopeName)).exec(this.core).exceptionally((Function)CoreCollectionManager.translateErrors(scopeName, null))).thenApply(response -> null);
    }

    public CompletableFuture<Void> dropCollection(String scopeName, String collectionName, CoreCommonOptions options) {
        return ((CompletableFuture)this.httpClient.delete(CoreCollectionManager.pathForCollection(this.bucketName, scopeName, collectionName), options).trace("manager_collections_drop_collection").traceBucket(this.bucketName).traceScope(scopeName).traceCollection(collectionName).exec(this.core).exceptionally((Function)CoreCollectionManager.translateErrors(scopeName, collectionName))).thenApply(response -> null);
    }

    public CompletableFuture<Void> dropScope(String scopeName, CoreCommonOptions options) {
        return ((CompletableFuture)this.httpClient.delete(CoreCollectionManager.pathForScope(this.bucketName, scopeName), options).trace("manager_collections_drop_scope").traceBucket(this.bucketName).traceScope(scopeName).exec(this.core).exceptionally((Function)CoreCollectionManager.translateErrors(scopeName, null))).thenApply(response -> null);
    }

    public CompletableFuture<CollectionsManifest> getAllScopes(CoreCommonOptions options) {
        return ((CompletableFuture)this.httpClient.get(CoreCollectionManager.pathForScopes(this.bucketName), options).trace("manager_collections_get_all_scopes").traceBucket(this.bucketName).exec(this.core).exceptionally((Function)CoreCollectionManager.translateErrors(null, null))).thenApply(response -> Mapper.decodeInto(response.content(), CollectionsManifest.class));
    }

    private static Function<Throwable, CoreHttpResponse> translateErrors(String scopeName, String collectionName) {
        return t -> {
            String error = HttpStatusCodeException.httpResponseBody(t);
            ResponseStatus responseStatus = HttpStatusCodeException.couchbaseResponseStatus(t);
            if (responseStatus == ResponseStatus.NOT_FOUND) {
                if (error.contains("Not found.") || error.contains("Requested resource not found.")) {
                    throw FeatureNotAvailableException.collections();
                }
                if (error.matches(".*Scope.+not found.*") || error.contains("scope_not_found")) {
                    throw ScopeNotFoundException.forScope(scopeName);
                }
                if (error.matches(".*Collection.+not found.*")) {
                    throw CollectionNotFoundException.forCollection(collectionName);
                }
            }
            if (responseStatus == ResponseStatus.INVALID_ARGS) {
                if (error.matches(".*Scope.+already exists.*")) {
                    throw ScopeExistsException.forScope(scopeName);
                }
                if (error.contains("scope_not_found")) {
                    throw ScopeNotFoundException.forScope(scopeName);
                }
                if (error.matches(".*Collection.+already exists.*")) {
                    throw CollectionExistsException.forCollection(collectionName);
                }
                if (error.contains("Not allowed on this version of cluster")) {
                    throw FeatureNotAvailableException.collections();
                }
                if (error.contains("Not allowed on this type of bucket")) {
                    throw FeatureNotAvailableException.collectionsForMemcached();
                }
                if (error.matches(".*Collection.+not found.*") || error.contains("collection_not_found")) {
                    throw CollectionNotFoundException.forCollection(collectionName);
                }
            }
            if (error.contains("Method Not Allowed")) {
                throw FeatureNotAvailableException.collections();
            }
            throw CbThrowables.propagate(t);
        };
    }
}

