/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.json.stream;

import com.couchbase.client.core.deps.com.fasterxml.jackson.core.JsonFactory;
import com.couchbase.client.core.deps.com.fasterxml.jackson.core.JsonParser;
import com.couchbase.client.core.deps.com.fasterxml.jackson.core.JsonToken;
import com.couchbase.client.core.deps.com.fasterxml.jackson.core.async.ByteArrayFeeder;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.core.deps.io.netty.buffer.UnpooledByteBufAllocator;
import com.couchbase.client.core.error.DecodingFailureException;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.json.stream.CopyingStreamWindow;
import com.couchbase.client.core.json.stream.MatchedValue;
import com.couchbase.client.core.json.stream.PathTree;
import com.couchbase.client.core.json.stream.StreamWindow;
import com.couchbase.client.core.json.stream.StructureNavigator;
import com.couchbase.client.core.util.CbObjects;
import java.io.Closeable;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Consumer;

public class JsonStreamParser
implements Closeable {
    private static final JsonFactory jsonFactory = new JsonFactory();
    private final JsonParser parser;
    private final ByteArrayFeeder feeder;
    private final ByteBuf scratchBuffer;
    private final StreamWindow window;
    private long captureStartOffset = -1L;
    private final StructureNavigator navigator;
    private boolean closed;

    public static Builder builder() {
        return new Builder();
    }

    private JsonStreamParser(PathTree pathTree, ByteBuf scratchBuffer, StreamWindow window) {
        this.scratchBuffer = JsonStreamParser.checkScratchBuffer(scratchBuffer);
        this.window = Objects.requireNonNull(window);
        this.navigator = new StructureNavigator(this, pathTree);
        try {
            this.parser = jsonFactory.createNonBlockingByteArrayParser();
            this.feeder = (ByteArrayFeeder)this.parser.getNonBlockingInputFeeder();
        }
        catch (IOException impossible) {
            throw new AssertionError((Object)impossible);
        }
    }

    private static ByteBuf checkScratchBuffer(ByteBuf buf) {
        if (buf.hasArray() && buf.arrayOffset() == 0 && buf.maxCapacity() == Integer.MAX_VALUE) {
            return buf;
        }
        throw InvalidArgumentException.fromMessage("Expected uncapped unpooled heap buffer but got " + buf);
    }

    public void feed(ByteBuf input) throws DecodingFailureException {
        try {
            this.feedJackson(input);
            this.processTokens();
            this.collectGarbage();
        }
        catch (Throwable t) {
            throw new DecodingFailureException(t);
        }
    }

    public void endOfInput() {
        try {
            this.feeder.endOfInput();
            this.processTokens();
        }
        catch (Throwable t) {
            throw new DecodingFailureException(t);
        }
    }

    private void feedJackson(ByteBuf input) throws IOException {
        input.markReaderIndex();
        this.scratchBuffer.clear();
        this.scratchBuffer.writeBytes(input);
        input.resetReaderIndex();
        this.window.add(input);
        this.feeder.feedInput(this.scratchBuffer.array(), this.scratchBuffer.arrayOffset(), this.scratchBuffer.writerIndex());
    }

    private void processTokens() throws IOException {
        JsonToken token;
        while ((token = this.parser.nextToken()) != JsonToken.NOT_AVAILABLE && token != null) {
            this.navigator.accept(token);
        }
        return;
    }

    private void dumpToken(JsonToken token) throws IOException {
        String location = "[" + this.tokenStartOffset() + "," + this.tokenEndOffset() + "]";
        System.out.println((Object)((Object)token) + " (" + this.parser.getText() + ")  location=" + location);
    }

    private void collectGarbage() {
        if (this.navigator.isCapturing()) {
            this.window.releaseBefore(this.captureStartOffset);
        } else {
            this.window.releaseBefore(this.tokenStartOffset());
        }
    }

    String getCurrentName() throws IOException {
        return this.parser.getCurrentName();
    }

    void beginCapture() {
        this.captureStartOffset = this.tokenStartOffset();
    }

    private long tokenStartOffset() {
        return this.parser.getTokenLocation().getByteOffset() - 1L;
    }

    private long tokenEndOffset() {
        return this.parser.getCurrentLocation().getByteOffset();
    }

    void emitCapturedValue(String jsonPointer, Consumer<MatchedValue> consumer) {
        byte[] capturedValue = this.window.getBytes(this.captureStartOffset, this.tokenEndOffset());
        consumer.accept(new MatchedValue(jsonPointer, capturedValue));
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.scratchBuffer.release();
        this.window.close();
        try {
            this.parser.close();
        }
        catch (IOException inconceivable) {
            throw new AssertionError("non-blocking parser should not have thrown exception on close", inconceivable);
        }
    }

    public static class Builder {
        private final PathTree tree = PathTree.createRoot();
        private boolean frozen;

        public Builder doOnValue(String jsonPointer, Consumer<MatchedValue> callback) {
            this.checkNotFrozen();
            this.tree.add(jsonPointer, callback);
            return this;
        }

        public JsonStreamParser build() {
            return this.build(null, null);
        }

        public JsonStreamParser build(ByteBuf scratchBuffer, StreamWindow window) {
            this.frozen = true;
            return new JsonStreamParser(this.tree, CbObjects.defaultIfNull(scratchBuffer, Unpooled::buffer), CbObjects.defaultIfNull(window, () -> new CopyingStreamWindow(UnpooledByteBufAllocator.DEFAULT)));
        }

        private void checkNotFrozen() {
            if (this.frozen) {
                throw new IllegalStateException("Can't reconfigure builder after first parser is built.");
            }
        }
    }
}

