/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.cnc.events.endpoint;

import com.couchbase.client.core.cnc.AbstractEvent;
import com.couchbase.client.core.cnc.Context;
import com.couchbase.client.core.cnc.Event;
import com.couchbase.client.core.endpoint.EndpointContext;
import java.time.Duration;
import java.util.SortedMap;

public class EndpointConnectionAbortedEvent
extends AbstractEvent {
    private final SortedMap<String, Duration> timings;

    public EndpointConnectionAbortedEvent(Duration duration, EndpointContext context, SortedMap<String, Duration> timings) {
        super(Event.Severity.DEBUG, Event.Category.ENDPOINT, duration, (Context)context);
        this.timings = timings;
    }

    @Override
    public String description() {
        String tm = this.timings == null || this.timings.isEmpty() ? "no timings" : "Timings: " + this.timings;
        return "Endpoint connect failed, but disconnected already so ignoring. (" + tm + ")";
    }

    public SortedMap<String, Duration> timings() {
        return this.timings;
    }
}

