/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dashboard.view;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ListContentProvider;
import org.jkiss.dbeaver.ui.dashboard.internal.UIDashboardActivator;
import org.jkiss.dbeaver.ui.dashboard.internal.UIDashboardMessages;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardViewConfiguration;
import org.jkiss.dbeaver.ui.dashboard.registry.DashboardDescriptor;
import org.jkiss.dbeaver.ui.dashboard.registry.DashboardRegistry;
import org.jkiss.dbeaver.ui.dashboard.view.DashboardManagerDialog;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.utils.CommonUtils;

public class DashboardAddDialog
extends BaseDialog {
    private static final String DIALOG_ID = "DBeaver.DashboardAddDialog";
    private final DashboardViewConfiguration viewConfiguration;
    private DashboardDescriptor selectedDashboard;

    public DashboardAddDialog(Shell parentShell, DashboardViewConfiguration viewConfiguration) {
        super(parentShell, UIDashboardMessages.dialog_add_dashboard_dialog_title, null);
        this.viewConfiguration = viewConfiguration;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getSettingsSection((IDialogSettings)UIDashboardActivator.getDefault().getDialogSettings(), (String)DIALOG_ID);
    }

    protected Composite createDialogArea(Composite parent) {
        Composite dialogArea = super.createDialogArea(parent);
        TableViewer dashboardTable = new TableViewer(dialogArea, 67584);
        dashboardTable.getControl().setLayoutData((Object)new GridData(1808));
        Table table = dashboardTable.getTable();
        GridData gd = new GridData(1808);
        gd.widthHint = 400;
        gd.heightHint = 200;
        table.setLayoutData((Object)gd);
        table.setHeaderVisible(true);
        UIUtils.createTableColumn((Table)table, (int)16384, (String)UIDashboardMessages.dialog_add_dashboard_column_name);
        UIUtils.createTableColumn((Table)table, (int)16384, (String)UIDashboardMessages.dialog_add_dashboard_column_description);
        dashboardTable.setLabelProvider((IBaseLabelProvider)new CellLabelProvider(){

            public void update(ViewerCell cell) {
                DashboardDescriptor dashboardDescriptor = (DashboardDescriptor)((Object)cell.getElement());
                if (cell.getColumnIndex() == 0) {
                    cell.setText(dashboardDescriptor.getName());
                } else {
                    cell.setText(CommonUtils.notEmpty((String)dashboardDescriptor.getDescription()));
                }
            }
        });
        dashboardTable.addDoubleClickListener(event -> {
            if (!dashboardTable.getSelection().isEmpty()) {
                this.okPressed();
            }
        });
        dashboardTable.addSelectionChangedListener(event -> {
            ISelection selection = dashboardTable.getSelection();
            this.getButton(0).setEnabled(!selection.isEmpty());
            if (selection instanceof IStructuredSelection) {
                this.selectedDashboard = (DashboardDescriptor)((Object)((Object)((IStructuredSelection)selection).getFirstElement()));
            }
            this.getButton(0).setEnabled(this.selectedDashboard != null);
        });
        table.addPaintListener(e -> {
            if (table.getItemCount() == 0) {
                String dbmsName = this.viewConfiguration.getDataSourceContainer().getDriver().getName();
                String msg = NLS.bind((String)UIDashboardMessages.dialog_add_dashboard_message_no_more_dashboards_for, (Object)dbmsName);
                UIUtils.drawMessageOverControl((Control)table, (PaintEvent)e, (String)msg, (int)0);
            }
        });
        dashboardTable.setContentProvider((IContentProvider)new ListContentProvider());
        ArrayList<DashboardDescriptor> dashboards = new ArrayList<DashboardDescriptor>(DashboardRegistry.getInstance().getDashboards((DBPNamedObject)this.viewConfiguration.getDataSourceContainer(), false));
        dashboards.removeIf(descriptor -> this.viewConfiguration.getDashboardConfig(descriptor.getId()) != null);
        dashboardTable.setInput(dashboards);
        UIUtils.asyncExec(() -> UIUtils.packColumns((Table)table, (boolean)true));
        return dialogArea;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        ((GridData)parent.getLayoutData()).grabExcessHorizontalSpace = true;
        Button managerButton = this.createButton(parent, 1, UIDashboardMessages.dialog_add_dashboard_button_manage, false);
        ((GridData)managerButton.getLayoutData()).horizontalAlignment = 1;
        ((GridData)managerButton.getLayoutData()).grabExcessHorizontalSpace = true;
        managerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new DashboardManagerDialog(UIUtils.getActiveWorkbenchShell()).open();
            }
        });
        this.createButton(parent, 0, UIDashboardMessages.dialog_add_dashboard_button_add, true).setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public DashboardDescriptor getSelectedDashboard() {
        return this.selectedDashboard;
    }
}

