/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dashboard.control;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchSite;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceContainerProvider;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.UIServiceConnections;
import org.jkiss.dbeaver.ui.dashboard.control.DashboardItem;
import org.jkiss.dbeaver.ui.dashboard.control.DashboardList;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardGroupContainer;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardViewConfiguration;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardViewContainer;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class DashboardListViewer
extends StructuredViewer
implements DBPDataSourceContainerProvider,
DashboardViewContainer {
    private final IWorkbenchSite site;
    private final DBPDataSourceContainer dataSourceContainer;
    private final DashboardViewConfiguration viewConfiguration;
    private volatile boolean useSeparateConnection;
    private volatile DBCExecutionContext isolatedContext;
    private DashboardList dashContainer;
    private boolean singleChartMode;

    public DashboardListViewer(IWorkbenchSite site, DBPDataSourceContainer dataSourceContainer, DashboardViewConfiguration viewConfiguration) {
        this.site = site;
        this.dataSourceContainer = dataSourceContainer;
        this.dataSourceContainer.isConnected();
        this.viewConfiguration = viewConfiguration;
        this.initConnection();
    }

    public void dispose() {
        if (this.isolatedContext != null) {
            if (this.isolatedContext.isConnected()) {
                this.isolatedContext.close();
            }
            this.isolatedContext = null;
        }
    }

    @Override
    public boolean isSingleChartMode() {
        return this.singleChartMode;
    }

    public void setSingleChartMode(boolean singleChartMode) {
        this.singleChartMode = singleChartMode;
    }

    public void createControl(Composite parent) {
        this.dashContainer = new DashboardList(this.site, parent, this);
        this.updateStatus();
    }

    public void createDashboardsFromConfiguration() {
        if (this.viewConfiguration.getDashboardItemConfigs().isEmpty()) {
            this.dashContainer.createDefaultDashboards();
        } else {
            this.dashContainer.createDashboardsFromConfiguration();
        }
    }

    private void updateStatus() {
    }

    public DBPDataSourceContainer getDataSourceContainer() {
        return this.dataSourceContainer;
    }

    @Override
    public List<? extends DashboardGroupContainer> getGroups() {
        return this.dashContainer == null ? Collections.emptyList() : Collections.singletonList(this.dashContainer);
    }

    @Override
    public DBCExecutionContext getExecutionContext() {
        if (this.useSeparateConnection && this.isolatedContext != null) {
            return this.isolatedContext;
        }
        return DBUtils.getDefaultContext((DBSObject)this.dataSourceContainer.getDataSource().getDefaultInstance(), (boolean)true);
    }

    @Override
    public DashboardViewConfiguration getViewConfiguration() {
        return this.viewConfiguration;
    }

    @Override
    public IWorkbenchSite getSite() {
        return this.site;
    }

    protected DashboardItem doFindInputItem(Object element) {
        return null;
    }

    protected DashboardItem doFindItem(Object element) {
        return null;
    }

    protected void doUpdateItem(Widget item, Object element, boolean fullMap) {
    }

    protected List getSelectionFromWidget() {
        DashboardItem selectedItem = this.dashContainer.getSelectedItem();
        return selectedItem == null ? Collections.emptyList() : Collections.singletonList(selectedItem);
    }

    protected void internalRefresh(Object element) {
    }

    public void reveal(Object element) {
        DashboardItem item = this.doFindItem(element);
        if (item != null) {
            this.dashContainer.showItem(item);
        }
    }

    protected void setSelectionToWidget(List l, boolean reveal) {
        if (l.isEmpty()) {
            this.dashContainer.setSelection(null);
        } else {
            DashboardItem item = this.doFindItem(l.get(0));
            if (item != null) {
                this.dashContainer.setSelection(item);
            }
        }
    }

    public Control getControl() {
        return this.dashContainer;
    }

    public DashboardGroupContainer getDefaultGroup() {
        return this.dashContainer;
    }

    private void initConnection() {
        this.useSeparateConnection = this.viewConfiguration.isUseSeparateConnection();
        if (this.viewConfiguration.isOpenConnectionOnActivate()) {
            if (!this.dataSourceContainer.isConnected()) {
                UIServiceConnections serviceConnections = (UIServiceConnections)DBWorkbench.getService(UIServiceConnections.class);
                if (serviceConnections != null) {
                    serviceConnections.connectDataSource(this.dataSourceContainer, status -> {
                        if (this.useSeparateConnection) {
                            this.openSeparateContext();
                        }
                    });
                }
            } else if (this.useSeparateConnection) {
                this.openSeparateContext();
            }
        } else if (this.useSeparateConnection) {
            this.openSeparateContext();
        }
    }

    private void openSeparateContext() {
        final DBPDataSource dataSource = this.dataSourceContainer.getDataSource();
        if (dataSource == null) {
            return;
        }
        new AbstractJob("Open connection for dashboard"){

            protected IStatus run(DBRProgressMonitor monitor) {
                DBSInstance instance = DBUtils.getObjectOwnerInstance((DBSObject)dataSource);
                if (instance != null) {
                    try {
                        DashboardListViewer.this.isolatedContext = instance.openIsolatedContext(monitor, "Dashboard connection", null);
                    }
                    catch (DBException e) {
                        return GeneralUtils.makeExceptionStatus((Throwable)e);
                    }
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }
}

