/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mockdata.engine.generator.advanced;

import com.dbeaver.ee.mockdata.engine.generator.advanced.AdvancedStringValueGenerator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;

public class StringNameGenerator
extends AdvancedStringValueGenerator {
    private static final Log log = Log.getLog(StringNameGenerator.class);
    protected static List<String> MALE_NAMES;
    protected static List<String> FEMALE_NAMES;
    protected static List<String> SURNAMES;
    protected static int maleNames;
    protected static int femaleNames;
    protected static int allNames;
    protected static int surnames;
    private GENDER gender = GENDER.ALL;
    protected boolean withSurnames = false;

    @Override
    public void init(DBSDataManipulator container, DBSAttributeBase attribute, Map<String, Object> properties) throws DBException {
        Boolean b;
        super.init(container, attribute, properties);
        String g = (String)properties.get("gender");
        if (g != null) {
            this.gender = GENDER.valueOf(g);
        }
        if ((b = this.getBooleanProperty(properties, "withSurnames")) != null) {
            this.withSurnames = b;
        }
    }

    @Override
    public Object generateOneValue(DBRProgressMonitor monitor) throws DBException, IOException {
        String name;
        if (allNames == 0) {
            MALE_NAMES = this.readDict("names_male_en.txt");
            FEMALE_NAMES = this.readDict("names_female_en.txt");
            SURNAMES = this.readDict("surnames_en.txt");
            maleNames = MALE_NAMES.size();
            femaleNames = FEMALE_NAMES.size();
            surnames = SURNAMES.size();
            allNames = femaleNames + maleNames;
        }
        if (this.isGenerateNULL()) {
            return null;
        }
        switch (this.gender) {
            case MALE: {
                name = MALE_NAMES.get(this.random.nextInt(maleNames));
                break;
            }
            case FEMALE: {
                name = FEMALE_NAMES.get(this.random.nextInt(femaleNames));
                break;
            }
            default: {
                int number = this.random.nextInt(allNames);
                name = number < maleNames ? MALE_NAMES.get(number) : FEMALE_NAMES.get(number - maleNames);
            }
        }
        if (this.withSurnames) {
            name = String.valueOf(name) + " " + SURNAMES.get(this.random.nextInt(surnames));
        }
        return this.tune(name);
    }

    private static enum GENDER {
        ALL,
        FEMALE,
        MALE;

    }
}

