/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime;

import java.security.AccessController;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;

public class ServiceCaller<S> {
    private final Bundle bundle;
    private final Class<S> serviceType;
    private final String filter;
    private volatile ReferenceAndService service = null;

    public static <S> boolean callOnce(Class<?> caller, Class<S> serviceType, Consumer<S> consumer) {
        return ServiceCaller.callOnce(caller, serviceType, null, consumer);
    }

    public static <S> boolean callOnce(Class<?> caller, Class<S> serviceType, String filter, Consumer<S> consumer) {
        return new ServiceCaller<S>(caller, serviceType, filter).getCurrent().map(r -> {
            try {
                consumer.accept(r.instance);
                Boolean bl = Boolean.TRUE;
                return bl;
            }
            finally {
                r.unget();
            }
        }).orElse(Boolean.FALSE);
    }

    private static int getRank(ServiceReference<?> ref) {
        Object rank = ref.getProperty("service.ranking");
        if (rank instanceof Integer) {
            return (Integer)rank;
        }
        return 0;
    }

    public ServiceCaller(Class<?> caller, Class<S> serviceType) {
        this(caller, serviceType, null);
    }

    public ServiceCaller(Class<?> caller, Class<S> serviceType, String filter) {
        this.serviceType = Objects.requireNonNull(serviceType);
        this.bundle = Objects.requireNonNull(FrameworkUtil.getBundle(Objects.requireNonNull(caller)));
        this.filter = filter;
        if (filter != null) {
            try {
                FrameworkUtil.createFilter((String)filter);
            }
            catch (InvalidSyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    private BundleContext getContext() {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(() -> this.bundle.getBundleContext());
        }
        return this.bundle.getBundleContext();
    }

    public boolean call(Consumer<S> consumer) {
        return this.trackCurrent().map(r -> {
            consumer.accept(r.instance);
            return Boolean.TRUE;
        }).orElse(Boolean.FALSE);
    }

    public Optional<S> current() {
        return this.trackCurrent().map(r -> r.instance);
    }

    private Optional<ReferenceAndService> trackCurrent() {
        ReferenceAndService current = this.service;
        if (current != null) {
            return Optional.of(current);
        }
        return this.getCurrent().flatMap(r -> {
            ServiceCaller serviceCaller = this;
            synchronized (serviceCaller) {
                if (this.service != null) {
                    r.unget();
                    return Optional.of(this.service);
                }
                return r.track();
            }
        });
    }

    private Optional<ReferenceAndService> getCurrent() {
        BundleContext context = this.getContext();
        return this.getServiceReference(context).map(r -> {
            Object current = context.getService(r);
            return current == null ? null : new ReferenceAndService(context, r, current);
        });
    }

    private Optional<ServiceReference<S>> getServiceReference(BundleContext context) {
        if (context == null) {
            return Optional.empty();
        }
        if (this.filter == null) {
            return Optional.ofNullable(context.getServiceReference(this.serviceType));
        }
        try {
            return context.getServiceReferences(this.serviceType, this.filter).stream().findFirst();
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return Optional.empty();
        }
    }

    public void unget() {
        ReferenceAndService current = this.service;
        if (current != null) {
            current.unget();
        }
    }

    private class ReferenceAndService
    implements SynchronousBundleListener,
    ServiceListener {
        final BundleContext context;
        final ServiceReference<S> ref;
        final S instance;
        final int rank;

        public ReferenceAndService(BundleContext context, ServiceReference<S> ref, S instance) {
            this.context = context;
            this.ref = ref;
            this.instance = instance;
            this.rank = ServiceCaller.getRank(ref);
        }

        void unget() {
            this.untrack();
            try {
                this.context.ungetService(this.ref);
            }
            catch (IllegalStateException illegalStateException) {}
        }

        public void bundleChanged(BundleEvent e) {
            if (ServiceCaller.this.bundle.equals(e.getBundle()) && e.getType() == 256) {
                this.unget();
            }
        }

        public void serviceChanged(ServiceEvent e) {
            if (this.requiresUnget(e)) {
                this.unget();
            }
        }

        private boolean requiresUnget(ServiceEvent e) {
            if (e.getServiceReference().equals(this.ref)) {
                return e.getType() == 4 || ServiceCaller.this.filter != null && e.getType() == 8 || e.getType() == 2 && ServiceCaller.getRank(this.ref) != this.rank;
            }
            return e.getType() == 2 && ServiceCaller.getRank(e.getServiceReference()) > this.rank;
        }

        Optional<ReferenceAndService> track() {
            try {
                ServiceCaller.this.service = this;
                this.context.addServiceListener((ServiceListener)this, "(&(objectClass=" + ServiceCaller.this.serviceType.getName() + ")" + (ServiceCaller.this.filter == null ? "" : ServiceCaller.this.filter) + ")");
                this.context.addBundleListener((BundleListener)this);
                if ((this.ref.getBundle() == null || this.context.getBundle() == null) && ServiceCaller.this.service == this) {
                    this.unget();
                }
                if (ServiceCaller.getRank(this.ref) != this.rank) {
                    this.unget();
                }
            }
            catch (InvalidSyntaxException e) {
                ServiceCaller.this.service = null;
                throw new IllegalStateException(e);
            }
            catch (IllegalStateException illegalStateException) {
                ServiceCaller.this.service = null;
            }
            return Optional.of(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void untrack() {
            ServiceCaller serviceCaller = ServiceCaller.this;
            synchronized (serviceCaller) {
                if (ServiceCaller.this.service == this) {
                    ServiceCaller.this.service = null;
                }
                try {
                    this.context.removeServiceListener((ServiceListener)this);
                    this.context.removeBundleListener((BundleListener)this);
                }
                catch (IllegalStateException illegalStateException) {}
            }
        }
    }
}

