/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.google.bigtable.model;

import com.dbeaver.db.google.bigtable.exec.BigTableExecutionContext;
import com.dbeaver.db.google.bigtable.model.BigTableCluster;
import com.dbeaver.db.google.bigtable.model.BigTableDataSource;
import com.dbeaver.db.google.bigtable.model.BigTableTable;
import com.google.cloud.bigtable.admin.v2.BigtableTableAdminClient;
import com.google.cloud.bigtable.admin.v2.BigtableTableAdminSettings;
import com.google.cloud.bigtable.admin.v2.models.Cluster;
import com.google.cloud.bigtable.admin.v2.models.CreateTableRequest;
import com.google.cloud.bigtable.admin.v2.models.Instance;
import com.google.cloud.bigtable.data.v2.BigtableDataClient;
import com.google.cloud.bigtable.data.v2.BigtableDataSettings;
import com.google.cloud.bigtable.data.v2.models.RowMutation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPExclusiveResource;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.SimpleExclusiveLock;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.cache.BasicObjectCache;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;

public class BigTableInstance
implements DBSInstance,
DBSCatalog,
DBSObjectContainer {
    private static final Log log = Log.getLog(BigTableInstance.class);
    private final BigTableDataSource dataSource;
    private final Instance instance;
    private BigtableDataClient dataClient;
    private BigtableTableAdminClient tableAdminClient;
    private BigTableExecutionContext executionContext;
    private TableCache tableCache = new TableCache();
    private ClusterCache clusterCache = new ClusterCache();
    private final DBPExclusiveResource exclusiveLock = new SimpleExclusiveLock();

    BigTableInstance(DBRProgressMonitor monitor, BigTableDataSource dataSource, Instance instance) throws DBException {
        this.dataSource = dataSource;
        this.instance = instance;
        try {
            this.dataClient = BigtableDataClient.create((BigtableDataSettings)BigtableDataSettings.newBuilder().setProjectId(dataSource.getProjectID()).setInstanceId(instance.getId()).setCredentialsProvider(dataSource.getCredentialsProvider()).build());
        }
        catch (IOException iOException) {
            throw new DBException("Error instantiating data client");
        }
        try {
            this.tableAdminClient = BigtableTableAdminClient.create((BigtableTableAdminSettings)BigtableTableAdminSettings.newBuilder().setProjectId(dataSource.getProjectID()).setInstanceId(instance.getId()).setCredentialsProvider(dataSource.getCredentialsProvider()).build());
        }
        catch (IOException iOException) {
            throw new DBException("Error instantiating data client");
        }
        this.executionContext = new BigTableExecutionContext(this, "Main");
        this.executionContext.connect(monitor);
    }

    private void testTables() {
        String tableId = "test-table";
        String familyId = "cf1";
        this.tableAdminClient.createTable(CreateTableRequest.of((String)tableId).addFamily(familyId));
        int i = 0;
        while (i < 10000) {
            RowMutation rowMutation = RowMutation.create((String)tableId, (String)("rowKey" + i)).setCell(familyId, "name", "Cell Name " + i).setCell(familyId, "value", "Cell Value " + i);
            this.dataClient.mutateRow(rowMutation);
            log.info((Object)("Row added " + i));
            ++i;
        }
    }

    @NotNull
    public BigTableDataSource getDataSource() {
        return this.dataSource;
    }

    @Nullable
    public BigTableDataSource getParentObject() {
        return this.dataSource;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.instance.getDisplayName();
    }

    @Property(viewable=true, order=10)
    public String getId() {
        return this.instance.getId();
    }

    @Property(viewable=true, order=2)
    public String getType() {
        return this.instance.getType().name();
    }

    @Property(viewable=true, order=3)
    public String getState() {
        return this.instance.getState().name();
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    public boolean isPersisted() {
        return true;
    }

    @NotNull
    public DBCExecutionContext getDefaultContext(DBRProgressMonitor monitor, boolean meta) {
        return this.executionContext;
    }

    @NotNull
    public DBCExecutionContext[] getAllContexts() {
        return new DBCExecutionContext[]{this.executionContext};
    }

    @NotNull
    public DBCExecutionContext openIsolatedContext(@NotNull DBRProgressMonitor monitor, @NotNull String purpose, @Nullable DBCExecutionContext initFrom) throws DBException {
        return this.executionContext;
    }

    public void shutdown(DBRProgressMonitor monitor) {
        if (this.dataClient != null) {
            try {
                this.dataClient.close();
            }
            catch (Exception e) {
                log.debug((Object)e);
            }
            this.dataClient = null;
        }
        if (this.tableAdminClient != null) {
            try {
                this.tableAdminClient.close();
            }
            catch (Exception e) {
                log.debug((Object)e);
            }
            this.tableAdminClient = null;
        }
        if (this.executionContext != null) {
            this.executionContext.close();
            this.executionContext = null;
        }
    }

    @NotNull
    public DBPExclusiveResource getExclusiveLock() {
        return this.exclusiveLock;
    }

    public BigtableDataClient getDataClient() {
        return this.dataClient;
    }

    public BigtableTableAdminClient getTableAdminClient() {
        return this.tableAdminClient;
    }

    public Collection<? extends DBSObject> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.tableCache.getAllObjects(monitor, this);
    }

    public DBSObject getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        return this.tableCache.getObject(monitor, (DBSObject)this, childName);
    }

    @NotNull
    public Class<? extends DBSObject> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) throws DBException {
        return BigTableTable.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
        this.getChildren(monitor);
    }

    @Association
    public Collection<BigTableTable> getTables(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.tableCache.getAllObjects(monitor, this);
    }

    @Association
    public Collection<BigTableCluster> getClusters(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.clusterCache.getAllObjects(monitor, this);
    }

    class ClusterCache
    extends BasicObjectCache<BigTableInstance, BigTableCluster> {
        ClusterCache() {
        }

        @NotNull
        public Collection<BigTableCluster> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable BigTableInstance instance) {
            if (!this.isFullyCached()) {
                ArrayList<BigTableCluster> clusterList = new ArrayList<BigTableCluster>();
                for (Cluster clusterMeta : BigTableInstance.this.dataSource.getInstanceAdminClient().listClusters(BigTableInstance.this.getId())) {
                    BigTableCluster btInstance = new BigTableCluster(BigTableInstance.this, clusterMeta);
                    clusterList.add(btInstance);
                }
                this.setCache(clusterList);
            }
            return this.getCachedObjects();
        }
    }

    class TableCache
    extends BasicObjectCache<BigTableInstance, BigTableTable> {
        TableCache() {
        }

        @NotNull
        public Collection<BigTableTable> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable BigTableInstance instance) {
            if (!this.isFullyCached()) {
                ArrayList<BigTableTable> tableList = new ArrayList<BigTableTable>();
                for (String tableId : BigTableInstance.this.tableAdminClient.listTables()) {
                    BigTableTable btInstance = new BigTableTable(BigTableInstance.this, tableId);
                    tableList.add(btInstance);
                }
                this.setCache(tableList);
            }
            return this.getCachedObjects();
        }
    }
}

