/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.google.bigtable.model;

import com.dbeaver.db.google.bigtable.BigTableUtils;
import com.dbeaver.db.google.bigtable.data.BigTableDocument;
import com.dbeaver.db.google.bigtable.model.BigTableDataSourceInfo;
import com.dbeaver.db.google.bigtable.model.BigTableInstance;
import com.dbeaver.db.google.bigtable.model.BigTableSQLDialect;
import com.dbeaver.model.NoSQLDataType;
import com.dbeaver.model.document.DocumentDataManager;
import com.dbeaver.model.document.data.DBDocumentUtils;
import com.dbeaver.model.document.data.DBMapValue;
import com.dbeaver.net.auth.gcp.AuthModelGCPCredentials;
import com.dbeaver.net.auth.gcp.GCPAuthType;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.bigtable.admin.v2.BigtableInstanceAdminClient;
import com.google.cloud.bigtable.admin.v2.BigtableInstanceAdminSettings;
import com.google.cloud.bigtable.admin.v2.models.Instance;
import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.cloud.bigtable.data.v2.models.RowCell;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.protobuf.ByteString;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IAdaptable;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBPDataTypeProvider;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.access.DBAAuthCredentials;
import org.jkiss.dbeaver.model.access.DBAAuthModel;
import org.jkiss.dbeaver.model.connection.DBPAuthModelDescriptor;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.impl.AbstractDataSource;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.cache.BasicObjectCache;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IntKeyMap;

public class BigTableDataSource
extends AbstractDataSource
implements DocumentDataManager<BigTableDataSource, Row>,
DBSObjectContainer,
DBPRefreshableObject,
DBPDataTypeProvider,
IAdaptable {
    private static final Log log = Log.getLog(BigTableDataSource.class);
    private static final Gson JSON_BUILDER = new GsonBuilder().setPrettyPrinting().setDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").registerTypeAdapter(RowCell.class, (Object)new BigTableDocument.RowCellJsonConverter()).registerTypeAdapter(ByteString.class, (Object)new BigTableDocument.ByteStringJsonConverter()).serializeNulls().create();
    private BigTableDataSourceInfo info;
    private final String projectID;
    private final InstanceCache instances = new InstanceCache();
    private final IntKeyMap<NoSQLDataType> dataTypes;
    private final CredentialsProvider credentialsProvider;
    private BigtableInstanceAdminClient instanceAdminClient;
    private String activeInstanceID;
    private String token;

    public BigTableDataSource(DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBException {
        super(container);
        DBPConnectionConfiguration configuration = container.getActualConnectionConfiguration();
        DBPAuthModelDescriptor authModelDescriptor = container.getDriver().getDataSourceProvider().detectConnectionAuthModel(container.getDriver(), configuration);
        DBAAuthModel authModel = authModelDescriptor.getInstance();
        DBAAuthCredentials credentials = authModel.loadCredentials(container, configuration);
        Object authentication = authModel.initAuthentication(monitor, (DBPDataSource)this, credentials, configuration, new Properties());
        boolean useDefaultCreds = false;
        boolean usedSSO = false;
        if (credentials instanceof AuthModelGCPCredentials || authentication instanceof AuthModelGCPCredentials) {
            AuthModelGCPCredentials gcpCredentials;
            AuthModelGCPCredentials authModelGCPCredentials = gcpCredentials = credentials instanceof AuthModelGCPCredentials ? (AuthModelGCPCredentials)credentials : (AuthModelGCPCredentials)authentication;
            if (gcpCredentials.getAuthType() == GCPAuthType.SERVICE_ACCOUNT) {
                configuration.setProviderProperty("credentialsFile", gcpCredentials.getServiceAccountConfigPath());
            } else if (gcpCredentials.getAuthType() == GCPAuthType.SSO_OVER_CLI) {
                gcpCredentials.initializeConnection(monitor);
                this.token = gcpCredentials.getToken();
                usedSSO = true;
            } else if (gcpCredentials.getAuthType() == GCPAuthType.DEFAULT) {
                useDefaultCreds = true;
            }
        } else {
            useDefaultCreds = CommonUtils.toBoolean((Object)configuration.getProviderProperty("useDefaultCredentials"));
        }
        this.projectID = container.getActualConnectionConfiguration().getProviderProperty("projectId");
        if (CommonUtils.isEmpty((String)this.projectID)) {
            throw new DBException("Empty project ID");
        }
        this.activeInstanceID = container.getActualConnectionConfiguration().getServerName();
        this.credentialsProvider = this.setupCredentials(configuration, useDefaultCreds, usedSSO);
        try {
            this.instanceAdminClient = BigtableInstanceAdminClient.create((BigtableInstanceAdminSettings)BigtableInstanceAdminSettings.newBuilder().setCredentialsProvider(this.credentialsProvider).setProjectId(this.projectID).build());
        }
        catch (IOException e) {
            throw new DBException("Error instantiating instance admin client", (Throwable)e);
        }
        Collection<BigTableInstance> instanceList = this.instances.getAllObjects(monitor, this);
        if (CommonUtils.isEmpty(instanceList)) {
            throw new DBException("No Bigtable instances found");
        }
        this.dataTypes = DBDocumentUtils.makeDocumentDataTypes((DBPDataSource)this);
    }

    private CredentialsProvider setupCredentials(@NotNull DBPConnectionConfiguration cfg, boolean useDefaultCreds, boolean usedSSO) throws DBException {
        try {
            GoogleCredentials credentials;
            block16: {
                if (useDefaultCreds) {
                    credentials = GoogleCredentials.getApplicationDefault();
                } else if (usedSSO && CommonUtils.isNotEmpty((String)this.token)) {
                    credentials = GoogleCredentials.create((AccessToken)new AccessToken(this.token, null));
                } else {
                    String credFileName = CommonUtils.toString((Object)cfg.getProviderProperty("credentialsFile"));
                    if (CommonUtils.isNotEmpty((String)credFileName)) {
                        Throwable throwable = null;
                        Object var7_9 = null;
                        try (FileInputStream cfgFileStream = new FileInputStream(credFileName);){
                            credentials = GoogleCredentials.fromStream((InputStream)cfgFileStream);
                            break block16;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    throw new DBException("Error reading Google credentials file. Please provide path to credentials file or use another authentication type.");
                }
            }
            return FixedCredentialsProvider.create((Credentials)credentials);
        }
        catch (Exception e) {
            throw new DBException("Error reading Google credentials", (Throwable)e);
        }
    }

    public String getProjectID() {
        return this.projectID;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public BigtableInstanceAdminClient getInstanceAdminClient() {
        return this.instanceAdminClient;
    }

    public SQLDialect getSQLDialect() {
        return BigTableSQLDialect.INSTANCE;
    }

    @NotNull
    public DBPDataSourceInfo getInfo() {
        return this.info;
    }

    public Object getDataSourceFeature(String featureId) {
        switch (featureId) {
            case "datasource.document-data-source": {
                return Boolean.TRUE;
            }
        }
        return null;
    }

    public void initialize(@NotNull DBRProgressMonitor monitor) {
        this.info = new BigTableDataSourceInfo(this);
    }

    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }

    @NotNull
    public BigTableInstance getDefaultInstance() {
        List cachedObjects = this.instances.getCachedObjects();
        if (CommonUtils.isEmpty((String)this.activeInstanceID)) {
            if (!CommonUtils.isEmpty((Collection)cachedObjects)) {
                return (BigTableInstance)cachedObjects.get(0);
            }
            throw new IllegalStateException("No BigTable instances found");
        }
        BigTableInstance defInstance = (BigTableInstance)this.instances.getCachedObject(this.activeInstanceID);
        if (defInstance == null && !CommonUtils.isEmpty((Collection)cachedObjects)) {
            log.debug((Object)("Instance '" + this.activeInstanceID + "' was not found. Used another instance"));
            return (BigTableInstance)cachedObjects.get(0);
        }
        if (defInstance == null) {
            throw new IllegalStateException("Instance '" + this.activeInstanceID + "' was not found");
        }
        return defInstance;
    }

    public void setDefaultInstance(@NotNull DBRProgressMonitor monitor, @NotNull BigTableInstance object) {
        BigTableInstance oldDefaultObject = this.getDefaultInstance();
        this.activeInstanceID = object.getName();
        DBUtils.fireObjectSelect((DBSObject)oldDefaultObject, (boolean)false);
        if (this.activeInstanceID != null) {
            DBUtils.fireObjectSelect((DBSObject)object, (boolean)true);
        }
    }

    @NotNull
    public List<BigTableInstance> getAvailableInstances() {
        return this.instances.getCachedObjects();
    }

    public void shutdown(DBRProgressMonitor monitor) {
        if (this.instanceAdminClient != null) {
            this.instanceAdminClient.close();
            this.instanceAdminClient = null;
        }
    }

    public Collection<? extends DBSObject> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.instances.getAllObjects(monitor, this);
    }

    public BigTableInstance getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        return (BigTableInstance)this.instances.getObject(monitor, (DBSObject)this, childName);
    }

    @NotNull
    public Class<? extends DBSObject> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) {
        return BigTableInstance.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) {
    }

    @Association
    public List<BigTableInstance> getInstances() {
        return this.getAvailableInstances();
    }

    @NotNull
    public DBPDataKind resolveDataKind(@NotNull String typeName, int typeID) {
        for (NoSQLDataType dt : this.dataTypes.values()) {
            if (dt.getTypeID() != typeID && !dt.getTypeName().equals(typeName)) continue;
            return dt.getDataKind();
        }
        return DBPDataKind.OBJECT;
    }

    public DBSDataType resolveDataType(@NotNull DBRProgressMonitor monitor, @NotNull String typeFullName) {
        return this.getLocalDataType(typeFullName);
    }

    public List<DBSDataType> getLocalDataTypes() {
        return new ArrayList<DBSDataType>(this.dataTypes.values());
    }

    public DBSDataType getLocalDataType(String typeName) {
        for (NoSQLDataType dt : this.dataTypes.values()) {
            if (!dt.getTypeName().equals(typeName)) continue;
            return dt;
        }
        return null;
    }

    public DBSDataType getLocalDataType(int typeID) {
        return (DBSDataType)this.dataTypes.get(typeID);
    }

    public DBSDataType getDocumentDataType(int typeId) {
        return (DBSDataType)this.dataTypes.get(typeId);
    }

    public String getDefaultDataTypeName(@NotNull DBPDataKind dataKind) {
        return NoSQLDataType.TypeName.STRING.getTypeName();
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) {
        return this;
    }

    public void serializeDocument(Row document, Writer writer) {
        JSON_BUILDER.toJson((Object)document, (Appendable)writer);
    }

    public Map<String, Object> deserializeDocument(Reader reader) {
        return JSONUtils.parseMap((Gson)JSON_BUILDER, (Reader)reader);
    }

    public DBMapValue<BigTableDataSource> convertNativeDocumentToMap(Row row) {
        return BigTableUtils.makeRawMap(this, null, row);
    }

    public Row convertMapToNativeDocument(DBMapValue<BigTableDataSource> map) {
        ArrayList cells = new ArrayList();
        ByteString key = (ByteString)map.getAttributeValue("RowKey");
        return Row.create((ByteString)key, cells);
    }

    class InstanceCache
    extends BasicObjectCache<BigTableDataSource, BigTableInstance> {
        InstanceCache() {
        }

        @NotNull
        public Collection<BigTableInstance> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable BigTableDataSource bigTableDataSource) throws DBException {
            if (!this.isFullyCached()) {
                ArrayList<BigTableInstance> instanceList = new ArrayList<BigTableInstance>();
                for (Instance instance : BigTableDataSource.this.instanceAdminClient.listInstances()) {
                    BigTableInstance btInstance = new BigTableInstance(monitor, BigTableDataSource.this, instance);
                    instanceList.add(btInstance);
                }
                this.setCache(instanceList);
            }
            return this.getCachedObjects();
        }
    }
}

