/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.auth.profile;

import com.dbeaver.ui.auth.profile.AuthModelProfileMessages;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.access.DBAAuthProfile;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.connection.DBPAuthModelDescriptor;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDataSourceProviderRegistry;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.secret.DBSSecretController;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomSashForm;
import org.jkiss.dbeaver.ui.dialogs.EnterNameDialog;
import org.jkiss.dbeaver.ui.dialogs.connection.AuthModelSelector;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.SecurityUtils;

class AuthProfileManagerDialogPage
extends DialogPage {
    private final DBPProject projectMeta;
    private final DBPDriver driver;
    private final String selectedProfileId;
    private final Runnable changeListener;
    private Table profilesTable;
    private DBAAuthProfile selectedProfile;
    private Text profileNameText;
    private AuthModelSelector modelSelector;
    private DataSourceDescriptor fakeDataSource;
    private Composite profileConfigPanel;
    private ControlEnableState configEnableState;
    private List<DBAAuthProfile> authProfiles;
    private List<DBAAuthProfile> deletedProfiles = new ArrayList<DBAAuthProfile>();
    private ToolItem deleteToolItem;

    public AuthProfileManagerDialogPage(@NotNull DBPProject project, @Nullable DBPDriver driver, @Nullable DBAAuthProfile selectedProfile, @NotNull Runnable changeListener) {
        this.projectMeta = project;
        this.driver = driver;
        this.selectedProfileId = selectedProfile == null ? null : selectedProfile.getProfileId();
        this.changeListener = changeListener;
        if (driver == null) {
            driver = DriverDescriptor.NULL_DRIVER;
        }
        DBPConnectionConfiguration conConfig = new DBPConnectionConfiguration();
        this.fakeDataSource = new DataSourceDescriptor(this.projectMeta.getDataSourceRegistry(), DataSourceDescriptor.generateNewId((DBPDriver)driver), driver, conConfig);
    }

    public void createControl(Composite dialogArea) {
        Composite composite = UIUtils.createComposite((Composite)dialogArea, (int)1);
        composite.setLayoutData((Object)new GridData(1808));
        CustomSashForm divider = UIUtils.createPartDivider(null, (Composite)composite, (int)256);
        GridData gd = new GridData(1808);
        gd.widthHint = 700;
        divider.setLayoutData((Object)gd);
        Composite profilesGroup = new Composite((Composite)divider, 2048);
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        profilesGroup.setLayout((Layout)gl);
        gd = new GridData(1808);
        profilesGroup.setLayoutData((Object)gd);
        ToolBar toolbar = new ToolBar(profilesGroup, 131328);
        UIUtils.createToolItem((ToolBar)toolbar, (String)"Create", (String)"Create new profile", (DBPImage)UIIcon.ROW_ADD, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String profileName = "";
                while (true) {
                    if (CommonUtils.isEmptyTrimmed((String)(profileName = EnterNameDialog.chooseName((Shell)AuthProfileManagerDialogPage.this.getShell(), (String)"Profile name", (String)profileName)))) {
                        return;
                    }
                    if (AuthProfileManagerDialogPage.this.projectMeta.getDataSourceRegistry().getNetworkProfile(profileName) == null) break;
                    UIUtils.showMessageBox((Shell)AuthProfileManagerDialogPage.this.getShell(), (String)"Wrong profile name", (String)("Profile '" + profileName + "' already exist in project '" + AuthProfileManagerDialogPage.this.projectMeta.getName() + "'"), (int)1);
                }
                DBAAuthProfile newProfile = new DBAAuthProfile(AuthProfileManagerDialogPage.this.projectMeta);
                newProfile.setProfileId(SecurityUtils.generateUniqueId());
                newProfile.setProfileName(profileName);
                TableItem item = new TableItem(AuthProfileManagerDialogPage.this.profilesTable, 0);
                item.setText(newProfile.getProfileName());
                item.setData((Object)newProfile);
                AuthProfileManagerDialogPage.this.authProfiles.add(newProfile);
                AuthProfileManagerDialogPage.this.saveActiveProfileSettings();
                AuthProfileManagerDialogPage.this.selectedProfile = newProfile;
                AuthProfileManagerDialogPage.this.profilesTable.select(AuthProfileManagerDialogPage.this.profilesTable.getItemCount() - 1);
                AuthProfileManagerDialogPage.this.showProfileConfig();
                AuthProfileManagerDialogPage.this.deleteToolItem.setEnabled(AuthProfileManagerDialogPage.this.profilesTable.getSelectionIndex() >= 0);
            }
        });
        this.deleteToolItem = UIUtils.createToolItem((ToolBar)toolbar, (String)"Delete", (String)"Delete profile", (DBPImage)UIIcon.ROW_DELETE, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AuthProfileManagerDialogPage.this.selectedProfile != null) {
                    List<DBPDataSourceContainer> usedBy = AuthProfileManagerDialogPage.this.getDataSourcesByProfile(AuthProfileManagerDialogPage.this.selectedProfile);
                    if (!usedBy.isEmpty()) {
                        UIUtils.showMessageBox((Shell)AuthProfileManagerDialogPage.this.getShell(), (String)"Can't delete profile", (String)("Authentication profile '" + AuthProfileManagerDialogPage.this.selectedProfile.getProfileName() + "' used by " + usedBy.size() + " connections:\n\t" + usedBy.stream().map(DBPNamedObject::getName).collect(Collectors.joining("\n\t"))), (int)1);
                        return;
                    }
                    if (!UIUtils.confirmAction((Shell)AuthProfileManagerDialogPage.this.getShell(), (String)"Delete profile", (String)("Are you sure you want to delete authentication profile '" + AuthProfileManagerDialogPage.this.selectedProfile.getProfileName() + "'?"))) {
                        return;
                    }
                    AuthProfileManagerDialogPage.this.profilesTable.remove(AuthProfileManagerDialogPage.this.profilesTable.getSelectionIndex());
                    AuthProfileManagerDialogPage.this.authProfiles.remove(AuthProfileManagerDialogPage.this.selectedProfile);
                    AuthProfileManagerDialogPage.this.deletedProfiles.add(AuthProfileManagerDialogPage.this.selectedProfile);
                    AuthProfileManagerDialogPage.this.selectedProfile = null;
                    AuthProfileManagerDialogPage.this.showProfileConfig();
                } else {
                    UIUtils.showMessageBox((Shell)AuthProfileManagerDialogPage.this.getShell(), (String)"No profile", (String)"Select profile first", (int)1);
                }
            }
        });
        this.deleteToolItem.setEnabled(false);
        this.profilesTable = new Table(profilesGroup, 65540);
        this.profilesTable.setHeaderVisible(true);
        gd = new GridData(1808);
        gd.minimumWidth = 150;
        gd.heightHint = 200;
        this.profilesTable.setLayoutData((Object)gd);
        this.profilesTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AuthProfileManagerDialogPage.this.deleteToolItem.setEnabled(AuthProfileManagerDialogPage.this.profilesTable.getSelectionIndex() >= 0);
                AuthProfileManagerDialogPage.this.saveActiveProfileSettings();
                Object[] selection = AuthProfileManagerDialogPage.this.profilesTable.getSelection();
                AuthProfileManagerDialogPage.this.selectedProfile = ArrayUtils.isEmpty((Object[])selection) ? null : (DBAAuthProfile)selection[0].getData();
                AuthProfileManagerDialogPage.this.showProfileConfig();
            }
        });
        UIUtils.createTableColumn((Table)this.profilesTable, (int)16384, (String)"Profile");
        UIUtils.createTableColumn((Table)this.profilesTable, (int)131072, (String)"Model");
        UIUtils.executeOnResize((Control)this.profilesTable, () -> UIUtils.packColumns((Table)this.profilesTable, (boolean)true));
        this.profileConfigPanel = UIUtils.createComposite((Composite)divider, (int)2);
        gd = new GridData(1808);
        this.profileConfigPanel.setLayoutData((Object)gd);
        this.profileNameText = UIUtils.createLabelText((Composite)this.profileConfigPanel, (String)AuthModelProfileMessages.manager_profile_name_label, null, (int)2048);
        this.profileNameText.addModifyListener(e -> {
            if (this.selectedProfile != null) {
                String newName = this.profileNameText.getText();
                TableItem item = this.getProfileItem(this.selectedProfile);
                if (item != null) {
                    item.setText(newName);
                }
                this.selectedProfile.setProfileName(newName);
            }
            this.updateCompletion();
        });
        this.modelSelector = new AuthModelSelector(this.profileConfigPanel, null, () -> {
            this.refreshActiveProfileModel();
            this.updateCompletion();
        });
        this.modelSelector.setModelFiler(element -> !element.getId().equals("profile"));
        this.modelSelector.setModelChangeFilter(this::validateModelPossible);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.modelSelector.setLayoutData((Object)gd);
        divider.setWeights(new int[]{300, 700});
        this.loadProfiles();
        this.setControl((Control)composite);
    }

    private boolean validateModelPossible(DBPAuthModelDescriptor authModel) {
        ArrayList<DBPDriver> incompatibleList = new ArrayList<DBPDriver>();
        List<DBPDataSourceContainer> dsList = this.getDataSourcesByProfile(this.selectedProfile);
        LinkedHashMap<DBPDriver, List> driverMap = new LinkedHashMap<DBPDriver, List>();
        for (DBPDataSourceContainer ds : dsList) {
            driverMap.computeIfAbsent(ds.getDriver(), driver1 -> new ArrayList()).add(ds);
        }
        DBPDataSourceProviderRegistry dspRegistry = DBWorkbench.getPlatform().getDataSourceProviderRegistry();
        for (DBPDriver driver : driverMap.keySet()) {
            List applicableAuthModels = dspRegistry.getApplicableAuthModels(driver);
            if (applicableAuthModels.contains(authModel)) continue;
            incompatibleList.add(driver);
        }
        if (!CommonUtils.isEmpty(incompatibleList)) {
            UIUtils.showMessageBox((Shell)this.getShell(), (String)"Can't change profile auth model", (String)("Authentication profile '" + this.selectedProfile.getProfileName() + "' is used by connection drivers " + incompatibleList.stream().map(DBPNamedObject::getName).collect(Collectors.joining(",")) + ".\n" + "These drivers don't support authentication model '" + authModel.getName() + "'"), (int)1);
            return false;
        }
        return true;
    }

    private TableItem getProfileItem(DBAAuthProfile profile) {
        TableItem[] tableItemArray = this.profilesTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getData() == profile) {
                return item;
            }
            ++n2;
        }
        return null;
    }

    private void updateCompletion() {
        this.changeListener.run();
    }

    boolean isComplete() {
        return this.authProfiles.isEmpty() || !CommonUtils.isEmptyTrimmed((String)this.profileNameText.getText()) && this.modelSelector.isComplete();
    }

    private void loadProfiles() {
        this.authProfiles = new ArrayList<DBAAuthProfile>();
        List authProfiles = this.driver == null ? this.projectMeta.getDataSourceRegistry().getAllAuthProfiles() : this.projectMeta.getDataSourceRegistry().getApplicableAuthProfiles(this.driver);
        for (DBAAuthProfile profile : authProfiles) {
            if (profile.getProject().isUseSecretStorage()) {
                try {
                    DBSSecretController secretController = DBSSecretController.getProjectSecretController((DBPProject)this.projectMeta);
                    profile.resolveSecrets(secretController);
                }
                catch (DBException e) {
                    DBWorkbench.getPlatformUI().showError("Profile read error", "Error reading profile secrets", (Throwable)e);
                }
            }
            DBAAuthProfile profileCopy = new DBAAuthProfile(profile);
            this.authProfiles.add(profileCopy);
            if (!profile.getProfileId().equals(this.selectedProfileId)) continue;
            this.selectedProfile = profileCopy;
        }
        if (this.selectedProfile == null && !this.authProfiles.isEmpty()) {
            this.selectedProfile = this.authProfiles.get(0);
        }
        for (DBAAuthProfile profile : this.authProfiles) {
            TableItem profileItem = new TableItem(this.profilesTable, 0);
            profileItem.setText(0, profile.getProfileName());
            DBPAuthModelDescriptor authModel = profile.getAuthModel();
            if (authModel != null) {
                if (authModel.getIcon() != null) {
                    profileItem.setImage(0, DBeaverIcons.getImage((DBPImage)authModel.getIcon()));
                }
                profileItem.setText(1, authModel.getName());
            }
            profileItem.setData((Object)profile);
            if (this.selectedProfile != profile) continue;
            this.profilesTable.setSelection(profileItem);
        }
        this.deleteToolItem.setEnabled(this.selectedProfile != null);
        this.showProfileConfig();
    }

    private void saveActiveProfileSettings() {
        if (this.selectedProfile == null) {
            return;
        }
        this.modelSelector.saveSettings((DBPDataSourceContainer)this.fakeDataSource);
        DBPConnectionConfiguration cfg = this.fakeDataSource.getConnectionConfiguration();
        this.selectedProfile.setAuthModelId(this.modelSelector.getSelectedAuthModel().getId());
        this.selectedProfile.setProperties(cfg.getAuthProperties());
        this.selectedProfile.setUserName(cfg.getUserName());
        this.selectedProfile.setUserPassword(cfg.getUserPassword());
        this.selectedProfile.setSavePassword(this.fakeDataSource.isSavePassword());
        this.refreshActiveProfileModel();
    }

    private void refreshActiveProfileModel() {
        TableItem profileItem = this.getProfileItem(this.selectedProfile);
        if (profileItem != null) {
            DBPAuthModelDescriptor authModel = this.modelSelector.getSelectedAuthModel();
            if (authModel.getIcon() != null) {
                profileItem.setImage(0, DBeaverIcons.getImage((DBPImage)authModel.getIcon()));
            }
            profileItem.setText(1, authModel.getName());
        }
    }

    private void showProfileConfig() {
        if (this.selectedProfile != null) {
            this.profileNameText.setText(this.selectedProfile.getProfileName());
            DBPConnectionConfiguration cfg = this.fakeDataSource.getConnectionConfiguration();
            cfg.setAuthProperties(this.selectedProfile.getProperties());
            cfg.setUserName(this.selectedProfile.getUserName());
            cfg.setUserPassword(this.selectedProfile.getUserPassword());
            this.fakeDataSource.setSavePassword(this.selectedProfile.isSavePassword());
        } else {
            this.profileNameText.setText("");
        }
        if (this.selectedProfile != null) {
            if (this.configEnableState != null) {
                this.configEnableState.restore();
                this.configEnableState = null;
            }
        } else {
            this.configEnableState = ControlEnableState.disable((Control)this.profileConfigPanel);
        }
        this.showAuthModel();
    }

    private void showAuthModel() {
        if (this.selectedProfile == null) {
            this.modelSelector.clearSettings();
            return;
        }
        DBPAuthModelDescriptor authModel = this.selectedProfile.getAuthModel();
        this.modelSelector.loadSettings((DBPDataSourceContainer)this.fakeDataSource, authModel, "native");
    }

    private List<DBPDataSourceContainer> getDataSourcesByProfile(DBAAuthProfile profile) {
        ArrayList<DBPDataSourceContainer> result = new ArrayList<DBPDataSourceContainer>();
        for (DBPDataSourceContainer ds : this.projectMeta.getDataSourceRegistry().getDataSources()) {
            if (!"profile".equals(ds.getConnectionConfiguration().getAuthModelId()) || !profile.getProfileId().equals(ds.getConnectionConfiguration().getAuthProperty("profile-id"))) continue;
            result.add(ds);
        }
        return result;
    }

    private List<DBPDataSourceContainer> getDataSourcesByAuthModel(DBPAuthModelDescriptor model) {
        ArrayList<DBPDataSourceContainer> result = new ArrayList<DBPDataSourceContainer>();
        for (DBPDataSourceContainer ds : this.projectMeta.getDataSourceRegistry().getDataSources()) {
            if (!model.getId().equals(ds.getConnectionConfiguration().getAuthModelId())) continue;
            result.add(ds);
        }
        return result;
    }

    private void saveChanges() {
        for (DBAAuthProfile dp : this.deletedProfiles) {
            this.projectMeta.getDataSourceRegistry().removeAuthProfile(dp);
        }
        for (DBAAuthProfile ap : this.authProfiles) {
            this.projectMeta.getDataSourceRegistry().updateAuthProfile(ap);
            if (!ap.getProject().isUseSecretStorage()) continue;
            try {
                DBSSecretController secretController = DBSSecretController.getProjectSecretController((DBPProject)ap.getProject());
                ap.persistSecrets(secretController);
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showError("Secret save error", "Error saving credentials to secret storage", (Throwable)e);
                return;
            }
        }
        this.projectMeta.getDataSourceRegistry().flushConfig();
    }

    public void saveProfileChanges() {
        this.saveActiveProfileSettings();
        this.saveChanges();
    }
}

