/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.snowflake.model;

import com.dbeaver.db.snowflake.model.SnowflakeSchema;
import java.sql.ResultSet;
import java.util.Date;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class SnowflakeStage
implements DBSObject,
DBPQualifiedObject {
    private SnowflakeSchema schema;
    private String name;
    private String stageUrl;
    private String stageRegion;
    private String stageType;
    private String stageOwner;
    private String description;
    private Date created;
    private Date lastAltered;

    SnowflakeStage(@NotNull SnowflakeSchema schema, @NotNull String name, @NotNull JDBCResultSet resultSet) {
        this.schema = schema;
        this.name = name;
        this.stageUrl = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"STAGE_URL");
        this.stageRegion = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"STAGE_REGION");
        this.stageType = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"STAGE_TYPE");
        this.stageOwner = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"STAGE_OWNER");
        this.description = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"COMMENT");
        this.created = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"CREATED");
        this.lastAltered = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"LAST_ALTERED");
    }

    @Nullable
    public DBSObject getParentObject() {
        return this.schema;
    }

    @Nullable
    public DBPDataSource getDataSource() {
        return this.schema.getDataSource();
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, order=2)
    public String getStageUrl() {
        return this.stageUrl;
    }

    @Property(viewable=true, order=3)
    public String getStageRegion() {
        return this.stageRegion;
    }

    @Property(viewable=true, order=4)
    public String getStageType() {
        return this.stageType;
    }

    @Property(viewable=true, order=5)
    public String getStageOwner() {
        return this.stageOwner;
    }

    @Property(viewable=true, order=6)
    public Date getCreated() {
        return this.created;
    }

    @Property(viewable=true, order=7)
    public Date getLastAltered() {
        return this.lastAltered;
    }

    @Property(viewable=true, editable=true, updatable=true, length=PropertyLength.MULTILINE, order=30)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String comment) {
        this.description = comment;
    }

    public boolean isPersisted() {
        return true;
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return this.schema.getCatalog() != null ? DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.schema.getCatalog(), this.schema, this}) : DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.schema, this});
    }
}

