/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.scmp.ui.wizard.diagram;

import com.dbeaver.ee.scmp.model.CMPOptions;
import com.dbeaver.ee.scmp.model.CMPResult;
import com.dbeaver.ee.scmp.model.CMPResultChangeItem;
import com.dbeaver.ee.scmp.ui.wizard.DiffRendererBase;
import com.dbeaver.ee.scmp.ui.wizard.diagram.DiffDiagramDecorator;
import com.dbeaver.ee.scmp.ui.wizard.diagram.DiffEntityColumnPart;
import com.dbeaver.ee.scmp.ui.wizard.diagram.DiffEntityDetails;
import com.dbeaver.ee.scmp.ui.wizard.diagram.parts.DiffDiagramPart;
import com.dbeaver.ee.scmp.ui.wizard.diagram.parts.DiffEntityPart;
import java.util.ArrayList;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.StringEditorInput;
import org.jkiss.dbeaver.ui.editors.SubEditorSite;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class DiffRendererDiagram
extends DiffRendererBase {
    private static final Log log = Log.getLog(DiffRendererDiagram.class);
    private DiffDiagramPart diagramPart;

    @Override
    public void createControl(Composite parent) {
        IWorkbenchPart activePart = UIUtils.getActiveWorkbenchWindow().getActivePage().getActivePart();
        if (activePart == null) {
            return;
        }
        this.diagramPart = new DiffDiagramPart();
        try {
            this.diagramPart.init((IEditorSite)new SubEditorSite(activePart.getSite()), (IEditorInput)new StringEditorInput("", (CharSequence)"", true, GeneralUtils.getDefaultFileEncoding()));
            this.diagramPart.createPartControl(parent);
        }
        catch (PartInitException e) {
            log.error((Object)e);
        }
        this.diagramPart.getViewer().addSelectionChangedListener(event -> {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            ArrayList<CMPResultChangeItem> items = new ArrayList<CMPResultChangeItem>();
            Object[] objectArray = selection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                CMPResultChangeItem changeItem;
                Object element = objectArray[n2];
                if (element instanceof DiffEntityPart) {
                    DiffEntityDetails entityDetails = (DiffEntityDetails)((DiffEntityPart)((Object)((Object)element))).getEntity().getUserData();
                    if (entityDetails.getChangeItem() != null) {
                        items.add(entityDetails.getChangeItem());
                    } else if (entityDetails.getNestedItems() != null) {
                        items.addAll(entityDetails.getNestedItems());
                    }
                } else if (element instanceof DiffEntityColumnPart && (changeItem = DiffDiagramDecorator.getAttributeItem((DiffEntityDetails)((DiffEntityColumnPart)((Object)((Object)element))).getEntity().getUserData(), (DBSEntityAttribute)((DiffEntityColumnPart)((Object)((Object)element))).getAttribute().getObject())) != null) {
                    items.add(changeItem);
                }
                ++n2;
            }
            this.fireSelectionChangedEvent((IStructuredSelection)new StructuredSelection(items));
        });
    }

    @Override
    public void populateChanges(CMPOptions options, CMPResult result) {
        if (this.diagramPart != null) {
            this.diagramPart.setCompareResult(options, result);
            this.diagramPart.refreshDiagram(true, true);
        }
    }

    @Override
    public void selectAllItems(boolean check) {
    }
}

