/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.scmp.ui.wizard;

import com.datical.liquibase.ext.appdba.synonym.Synonym;
import com.datical.liquibase.ext.storedlogic.checkconstraint.CheckConstraint;
import com.datical.liquibase.ext.storedlogic.databasepackage.DatabasePackage;
import com.datical.liquibase.ext.storedlogic.function.Function;
import com.datical.liquibase.ext.storedlogic.trigger.Trigger;
import com.dbeaver.ee.scmp.impl.liquibase.LBUtils;
import com.dbeaver.ee.scmp.internal.ui.LBMessages;
import com.dbeaver.ee.scmp.model.CMPOptions;
import com.dbeaver.ee.scmp.registry.SCMPEngineRegistry;
import com.dbeaver.ee.scmp.registry.SCMPReportEngineDescriptor;
import com.dbeaver.ee.scmp.ui.wizard.SchemaCompareWizard;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.ForeignKey;
import liquibase.structure.core.Index;
import liquibase.structure.core.PrimaryKey;
import liquibase.structure.core.Sequence;
import liquibase.structure.core.StoredProcedure;
import liquibase.structure.core.Table;
import liquibase.structure.core.UniqueConstraint;
import liquibase.structure.core.View;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.contentassist.ContentAssistUtils;
import org.jkiss.dbeaver.ui.contentassist.SmartTextContentAdapter;
import org.jkiss.dbeaver.ui.contentassist.StringContentProposalProvider;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.HelpUtils;
import org.jkiss.utils.CommonUtils;

public class SchemaCompareWizardPageSettings
extends ActiveWizardPage<SchemaCompareWizard> {
    private final String HELP_WIKI_LINK = "Schema-compare";
    private Button saveOutputToFileCheckbox;
    private Text outputFolderText;
    private Text outputFileText;
    private CMPOptions cmpOptions;
    private Combo engineCombo;
    private Tree tree;
    private TreeItem tableItem;
    private TreeItem columnItem;
    private TreeItem pkItem;
    private TreeItem ukItem;
    private TreeItem fkItem;
    private TreeItem indexItem;
    private TreeItem viewItem;
    private TreeItem triggerItem;
    private TreeItem functionItem;
    private TreeItem procedureItem;
    private TreeItem packageItem;
    private TreeItem checkConstraintItem;
    private TreeItem synonymItem;
    private Set<Class<? extends DatabaseObject>> excludedObjectsSet = new HashSet<Class<? extends DatabaseObject>>();
    private final List<Class<? extends DatabaseObject>> tableChildClasses = new ArrayList<Class<? extends DatabaseObject>>();

    SchemaCompareWizardPageSettings() {
        super(LBMessages.wizard_schema_compare_window_title_schema_compare);
        this.setTitle(LBMessages.wizard_schema_compare_page_settings_title);
        this.setDescription(LBMessages.wizard_schema_compare_page_settings_description);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.cmpOptions = ((SchemaCompareWizard)this.getWizard()).getSettings();
        Composite composite = UIUtils.createComposite((Composite)parent, (int)2);
        Group group = UIUtils.createControlGroup((Composite)composite, (String)LBMessages.wizard_schema_compare_page_settings_group_general, (int)2, (int)768, (int)0);
        GridData gd = new GridData(770);
        gd.horizontalSpan = 2;
        group.setLayoutData((Object)gd);
        this.saveOutputToFileCheckbox = UIUtils.createCheckbox((Composite)group, (String)LBMessages.wizard_schema_compare_page_settings_checkbox_save, (String)LBMessages.wizard_schema_compare_page_settings_checkbox_save_tip, (boolean)this.cmpOptions.isExportFile(), (int)2);
        this.saveOutputToFileCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selection = SchemaCompareWizardPageSettings.this.saveOutputToFileCheckbox.getSelection();
                SchemaCompareWizardPageSettings.this.outputFolderText.setEnabled(selection);
                SchemaCompareWizardPageSettings.this.outputFileText.setEnabled(selection);
                SchemaCompareWizardPageSettings.this.cmpOptions.setExportFile(selection);
                SchemaCompareWizardPageSettings.this.updatePageCompletion();
            }
        });
        this.createOutputFolderInput((Composite)group);
        this.engineCombo = UIUtils.createLabelCombo((Composite)group, (String)LBMessages.wizard_schema_compare_page_settings_engines_label, (String)LBMessages.wizard_schema_compare_page_settings_engines_tip, (int)12);
        this.engineCombo.setLayoutData((Object)new GridData(32));
        SCMPEngineRegistry instance = SCMPEngineRegistry.getInstance();
        final List reportEngines = instance.getReportEngines();
        for (SCMPReportEngineDescriptor reportEngine : reportEngines) {
            this.engineCombo.add(reportEngine.getLabel());
        }
        if (!CommonUtils.isEmpty((String)this.cmpOptions.getReportEngineId())) {
            this.engineCombo.setText(this.cmpOptions.getReportEngineId());
            this.engineCombo.select(reportEngines.indexOf(instance.getReportEngine(this.cmpOptions.getReportEngineId())));
        } else if (this.engineCombo.getSelectionIndex() < 0) {
            this.engineCombo.select(0);
        }
        this.engineCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SchemaCompareWizardPageSettings.this.cmpOptions.setReportEngineId(((SCMPReportEngineDescriptor)reportEngines.get(SchemaCompareWizardPageSettings.this.engineCombo.getSelectionIndex())).getId());
                SchemaCompareWizardPageSettings.this.fixOutputFileExtension();
            }
        });
        this.fixOutputFileExtension();
        this.createObjectsTypesGroup(composite);
        if (!this.cmpOptions.isOnlyChangelog()) {
            Group optionsGroup = UIUtils.createControlGroup((Composite)composite, (String)LBMessages.wizard_schema_compare_page_settings_group_actions, (int)1, (int)770, (int)0);
            UIUtils.createCheckbox((Composite)optionsGroup, (String)LBMessages.wizard_schema_compare_input_options_create_objects, (String)LBMessages.wizard_schema_compare_input_options_create_objects_tip, (boolean)this.cmpOptions.isDoCreate(), (int)1).addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SchemaCompareWizardPageSettings.this.cmpOptions.setDoCreate(((Button)e.widget).getSelection());
                }
            });
            UIUtils.createCheckbox((Composite)optionsGroup, (String)LBMessages.wizard_schema_compare_input_options_alter_objects, (String)LBMessages.wizard_schema_compare_input_options_alter_objects_tip, (boolean)this.cmpOptions.isDoChange(), (int)1).addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SchemaCompareWizardPageSettings.this.cmpOptions.setDoChange(((Button)e.widget).getSelection());
                }
            });
            UIUtils.createCheckbox((Composite)optionsGroup, (String)LBMessages.wizard_schema_compare_input_options_drop_objects, (String)LBMessages.wizard_schema_compare_input_options_drop_objects_tip, (boolean)this.cmpOptions.isDoDrop(), (int)1).addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SchemaCompareWizardPageSettings.this.cmpOptions.setDoDrop(((Button)e.widget).getSelection());
                }
            });
            UIUtils.createCheckbox((Composite)optionsGroup, (String)LBMessages.wizard_schema_compare_input_options_case_insensitive, (String)LBMessages.wizard_schema_compare_input_options_case_insensitive_tip, (boolean)this.cmpOptions.isCaseInsensitiveCompare(), (int)1).addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SchemaCompareWizardPageSettings.this.cmpOptions.setCaseInsensitiveCompare(((Button)e.widget).getSelection());
                }
            });
        }
        Link urlHelpLabel = UIUtils.createLink((Composite)composite, (String)NLS.bind((String)LBMessages.wizard_schema_compare_page_settings_link, (Object)("<a href=\"" + HelpUtils.getHelpExternalReference((String)"Schema-compare") + "\">"), (Object)"</a>"), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShellUtils.launchProgram((String)HelpUtils.getHelpExternalReference((String)"Schema-compare"));
            }
        });
        GridData gridData = new GridData(4, 0x1000008, true, true);
        gridData.horizontalSpan = 2;
        urlHelpLabel.setLayoutData((Object)gridData);
        this.setControl((Control)composite);
    }

    private void createOutputFolderInput(@NotNull Composite outputGroup) {
        this.outputFolderText = DialogUtils.createOutputFolderChooser((Composite)outputGroup, (String)LBMessages.wizard_schema_compare_page_settings_output_folder, (String)this.cmpOptions.getOutputFolderPath(), e -> this.updatePageCompletion());
        UIUtils.setContentProposalToolTip((Control)this.outputFolderText, (String)LBMessages.wizard_schema_compare_page_settings_output_folder_tip, (String[])LBUtils.ALL_VARIABLES);
        ContentAssistUtils.installContentProposal((Control)this.outputFolderText, (IControlContentAdapter)new SmartTextContentAdapter(), (IContentProposalProvider)new StringContentProposalProvider((String[])Arrays.stream(LBUtils.ALL_VARIABLES).map(GeneralUtils::variablePattern).toArray(String[]::new)));
        this.outputFolderText.addModifyListener(e -> this.cmpOptions.setOutputFolderPath(this.outputFolderText.getText()));
        this.outputFolderText.setEnabled(this.saveOutputToFileCheckbox.getSelection());
        this.outputFileText = UIUtils.createLabelText((Composite)outputGroup, (String)LBMessages.wizard_schema_compare_page_settings_output_file, (String)this.cmpOptions.getOutputFilePattern());
        UIUtils.setContentProposalToolTip((Control)this.outputFileText, (String)LBMessages.wizard_schema_compare_page_settings_output_file_tip, (String[])LBUtils.ALL_VARIABLES);
        ContentAssistUtils.installContentProposal((Control)this.outputFileText, (IControlContentAdapter)new SmartTextContentAdapter(), (IContentProposalProvider)new StringContentProposalProvider((String[])Arrays.stream(LBUtils.ALL_VARIABLES).map(GeneralUtils::variablePattern).toArray(String[]::new)));
        this.outputFileText.addModifyListener(e -> this.cmpOptions.setOutputFilePattern(this.outputFileText.getText()));
        this.outputFileText.setEnabled(this.saveOutputToFileCheckbox.getSelection());
    }

    private void fixOutputFileExtension() {
        boolean isDotWithEmptyExt;
        String ext;
        String name;
        String text = this.outputFileText.getText();
        int idxOfExtStart = text.lastIndexOf(46);
        if (idxOfExtStart > -1 && idxOfExtStart <= text.length()) {
            name = text.substring(0, idxOfExtStart);
            ext = text.substring(idxOfExtStart + 1);
        } else {
            name = text;
            ext = "";
        }
        String newExt = ((SCMPReportEngineDescriptor)SCMPEngineRegistry.getInstance().getReportEngines().get(this.engineCombo.getSelectionIndex())).getFileExtension();
        boolean bl = isDotWithEmptyExt = ext.isEmpty() && idxOfExtStart > -1;
        if (!isDotWithEmptyExt && ext.equalsIgnoreCase(newExt)) {
            return;
        }
        if (!newExt.isEmpty()) {
            newExt = "." + newExt;
        }
        text = String.valueOf(name) + newExt;
        this.outputFileText.setText(text);
    }

    private void createObjectsTypesGroup(Composite composite) {
        Group group = UIUtils.createControlGroup((Composite)composite, (String)LBMessages.wizard_schema_compare_input_object_types, (int)1, (int)2, (int)0);
        Label otLabel = UIUtils.createControlLabel((Composite)group, (String)LBMessages.wizard_schema_compare_input_object_types_tip);
        otLabel.setLayoutData((Object)new GridData(2));
        GridData gd = new GridData(1808);
        gd.widthHint = 300;
        gd.heightHint = 200;
        composite.setLayoutData((Object)gd);
        this.tableChildClasses.add(Column.class);
        this.tableChildClasses.add(PrimaryKey.class);
        this.tableChildClasses.add(UniqueConstraint.class);
        this.tableChildClasses.add(ForeignKey.class);
        this.tableChildClasses.add(Index.class);
        this.tree = new Tree((Composite)group, 67616);
        this.tree.setLayoutData((Object)new GridData(1808));
        this.tableItem = this.createCheckedTreeItem(LBMessages.wizard_schema_compare_input_excluded_type_tables, Table.class);
        this.columnItem = this.createCheckedTableChildTreeItem(LBMessages.wizard_schema_compare_input_excluded_type_columns, Column.class);
        this.pkItem = this.createCheckedTableChildTreeItem(LBMessages.wizard_schema_compare_input_excluded_type_pk, PrimaryKey.class);
        this.ukItem = this.createCheckedTableChildTreeItem(LBMessages.wizard_schema_compare_input_excluded_type_uk, UniqueConstraint.class);
        this.fkItem = this.createCheckedTableChildTreeItem(LBMessages.wizard_schema_compare_input_excluded_type_fk, ForeignKey.class);
        this.indexItem = this.createCheckedTableChildTreeItem(LBMessages.wizard_schema_compare_input_excluded_type_indexes, Index.class);
        this.tableItem.setExpanded(true);
        this.viewItem = this.createCheckedTreeItem(LBMessages.wizard_schema_compare_input_excluded_type_views, View.class);
        this.createCheckedTreeItem(LBMessages.wizard_schema_compare_input_excluded_type_sequences, Sequence.class);
        if (this.cmpOptions.isHasLiquibaseLicense()) {
            this.triggerItem = this.createCheckedTreeItem(LBMessages.wizard_schema_compare_input_excluded_type_triggers, Trigger.class);
            this.functionItem = this.createCheckedTreeItem(LBMessages.wizard_schema_compare_input_excluded_type_functions, Function.class);
            this.procedureItem = this.createCheckedTreeItem(LBMessages.wizard_schema_compare_input_excluded_type_procedures, StoredProcedure.class);
            this.packageItem = this.createCheckedTreeItem(LBMessages.wizard_schema_compare_input_excluded_type_packages, DatabasePackage.class);
            this.synonymItem = this.createCheckedTreeItem(LBMessages.wizard_schema_compare_input_excluded_type_synonyms, Synonym.class);
            this.checkConstraintItem = this.createCheckedTableChildTreeItem(LBMessages.wizard_schema_compare_input_excluded_type_check_constraints, CheckConstraint.class);
        }
        this.tree.setVisible(true);
        this.tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail == 32 && e.item instanceof TreeItem) {
                    TreeItem checkedItem = (TreeItem)e.item;
                    boolean checked = checkedItem.getChecked();
                    if (checkedItem.equals(SchemaCompareWizardPageSettings.this.tableItem)) {
                        SchemaCompareWizardPageSettings.this.changeObjectsTypeSet(checked, Table.class);
                        if (!checked) {
                            TreeItem[] treeItemArray = SchemaCompareWizardPageSettings.this.tableItem.getItems();
                            int n = treeItemArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                TreeItem childItem = treeItemArray[n2];
                                childItem.setChecked(false);
                                ++n2;
                            }
                            for (Class<? extends DatabaseObject> type : SchemaCompareWizardPageSettings.this.tableChildClasses) {
                                SchemaCompareWizardPageSettings.this.changeObjectsTypeSet(false, type);
                            }
                        }
                    } else if (checkedItem.equals(SchemaCompareWizardPageSettings.this.columnItem)) {
                        SchemaCompareWizardPageSettings.this.changeObjectsTypeSet(checked, Column.class);
                    } else if (checkedItem.equals(SchemaCompareWizardPageSettings.this.pkItem)) {
                        SchemaCompareWizardPageSettings.this.changeObjectsTypeSet(checked, PrimaryKey.class);
                    } else if (checkedItem.equals(SchemaCompareWizardPageSettings.this.ukItem)) {
                        SchemaCompareWizardPageSettings.this.changeObjectsTypeSet(checked, UniqueConstraint.class);
                    } else if (checkedItem.equals(SchemaCompareWizardPageSettings.this.fkItem)) {
                        SchemaCompareWizardPageSettings.this.changeObjectsTypeSet(checked, ForeignKey.class);
                    } else if (checkedItem.equals(SchemaCompareWizardPageSettings.this.indexItem)) {
                        SchemaCompareWizardPageSettings.this.changeObjectsTypeSet(checked, Index.class);
                    } else if (checkedItem.equals(SchemaCompareWizardPageSettings.this.viewItem)) {
                        SchemaCompareWizardPageSettings.this.changeObjectsTypeSet(checked, View.class);
                    } else if (checkedItem.equals(SchemaCompareWizardPageSettings.this.triggerItem)) {
                        SchemaCompareWizardPageSettings.this.changeObjectsTypeSet(checked, Trigger.class);
                    } else if (checkedItem.equals(SchemaCompareWizardPageSettings.this.functionItem)) {
                        SchemaCompareWizardPageSettings.this.changeObjectsTypeSet(checked, Function.class);
                    } else if (checkedItem.equals(SchemaCompareWizardPageSettings.this.procedureItem)) {
                        SchemaCompareWizardPageSettings.this.changeObjectsTypeSet(checked, StoredProcedure.class);
                    } else if (checkedItem.equals(SchemaCompareWizardPageSettings.this.packageItem)) {
                        SchemaCompareWizardPageSettings.this.changeObjectsTypeSet(checked, DatabasePackage.class);
                    } else if (checkedItem.equals(SchemaCompareWizardPageSettings.this.synonymItem)) {
                        SchemaCompareWizardPageSettings.this.changeObjectsTypeSet(checked, Synonym.class);
                    } else if (checkedItem.equals(SchemaCompareWizardPageSettings.this.checkConstraintItem)) {
                        SchemaCompareWizardPageSettings.this.changeObjectsTypeSet(checked, CheckConstraint.class);
                    } else {
                        SchemaCompareWizardPageSettings.this.changeObjectsTypeSet(checked, Sequence.class);
                    }
                    SchemaCompareWizardPageSettings.this.cmpOptions.setExcludedObjectTypes(SchemaCompareWizardPageSettings.this.excludedObjectsSet);
                }
            }
        });
    }

    private void changeObjectsTypeSet(boolean checked, Class<? extends DatabaseObject> typeClass) {
        if (!checked) {
            this.excludedObjectsSet.add(typeClass);
        } else {
            this.excludedObjectsSet.removeIf(o -> o.equals(typeClass));
        }
    }

    private TreeItem createCheckedTreeItem(String text, Class<? extends DatabaseObject> typeClass) {
        TreeItem item = new TreeItem(this.tree, 0);
        item.setText(text);
        item.setChecked(!this.cmpOptions.getExcludedObjectTypes().contains(typeClass));
        return item;
    }

    private TreeItem createCheckedTableChildTreeItem(String text, Class<? extends DatabaseObject> typeClass) {
        TreeItem item = new TreeItem(this.tableItem, 0);
        item.setText(text);
        item.setChecked(!this.cmpOptions.getExcludedObjectTypes().contains(typeClass));
        return item;
    }

    protected void updatePageCompletion() {
        super.updatePageCompletion();
        ((SchemaCompareWizard)this.getWizard()).updateSaveTaskButtons();
    }

    protected boolean determinePageCompletion() {
        if (this.saveOutputToFileCheckbox.getSelection() && (CommonUtils.isEmptyTrimmed((String)this.outputFileText.getText()) || CommonUtils.isEmptyTrimmed((String)this.outputFolderText.getText()))) {
            this.setErrorMessage("Output file/folder path cannot be empty");
            return false;
        }
        return true;
    }
}

