/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.scmp.ui.wizard;

import com.dbeaver.ee.scmp.internal.ui.LBMessages;
import com.dbeaver.ee.scmp.model.CMPOptions;
import com.dbeaver.ee.scmp.model.CMPResult;
import com.dbeaver.ee.scmp.model.CMPUtils;
import com.dbeaver.ee.scmp.ui.wizard.SchemaComparePageDiff;
import com.dbeaver.ee.scmp.ui.wizard.SchemaComparePageInput;
import com.dbeaver.ee.scmp.ui.wizard.SchemaCompareWizardPageSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbench;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSStructContainer;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskConfigurationWizard;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskConfigurationWizardDialog;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskWizardExecutor;
import org.jkiss.dbeaver.ui.UIUtils;

public class SchemaCompareWizard
extends TaskConfigurationWizard<CMPOptions> {
    private static final Log log = Log.getLog(SchemaCompareWizard.class);
    private IWorkbench workbench;
    private IStructuredSelection selection;
    private boolean makeDiff;
    private CMPOptions options;
    private SchemaComparePageInput pageInput;
    private SchemaCompareWizardPageSettings pageSettings;
    private SchemaComparePageDiff pageDiff;

    public SchemaCompareWizard(@Nullable DBTTask task) {
        super(task);
        this.makeDiff = task != null && "schemaCompare".equals(task.getType().getId());
        this.setWindowTitle(this.makeDiff ? LBMessages.wizard_schema_compare_window_title_schema_compare : LBMessages.wizard_schema_compare_window_title_liquibase_changelog);
    }

    private void fillInputsFromSelection() {
        if (this.selection == null || this.selection.isEmpty()) {
            return;
        }
        LinkedHashMap<DBPDataSourceContainer, Set> dataSourceObjectMap = new LinkedHashMap<DBPDataSourceContainer, Set>();
        LinkedHashMap<DBSObjectContainer, Set> containerObjectMap = new LinkedHashMap<DBSObjectContainer, Set>();
        Object[] objectArray = this.selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            DBSObject object = null;
            if (element instanceof DBSObject) {
                object = (DBSObject)element;
            } else if (element instanceof DBNDatabaseNode) {
                object = ((DBNDatabaseNode)element).getObject();
            }
            if (object != null) {
                DBPDataSourceContainer dataSourceContainer;
                Object object2 = object instanceof DBPDataSourceContainer ? (DBPDataSourceContainer)object : (dataSourceContainer = object.getDataSource() == null ? null : object.getDataSource().getContainer());
                if (dataSourceContainer != null) {
                    Set dsObjectSet = dataSourceObjectMap.computeIfAbsent(dataSourceContainer, dataSourceContainer1 -> new LinkedHashSet());
                    dsObjectSet.add(object);
                    DBSObjectContainer container = null;
                    if (object instanceof DBSObjectContainer) {
                        container = (DBSObjectContainer)object;
                    } else if (object.getParentObject() instanceof DBSObjectContainer) {
                        container = (DBSObjectContainer)object.getParentObject();
                    }
                    if (container != null) {
                        Set contObjectSet = containerObjectMap.computeIfAbsent(container, dataSourceContainer1 -> new LinkedHashSet());
                        contObjectSet.add(object);
                    }
                }
            }
            ++n2;
        }
        Iterator dsIterator = dataSourceObjectMap.keySet().iterator();
        this.options.setSourceDataSourceContainer(dsIterator.hasNext() ? (DBPDataSourceContainer)dsIterator.next() : null);
        boolean emptyTarget = this.options.isOnlyChangelog();
        if (!emptyTarget) {
            this.options.setTargetDataSourceContainer(dsIterator.hasNext() ? (DBPDataSourceContainer)dsIterator.next() : null);
        }
        DBPDataSourceContainer sourceDataSourceContainer = this.options.getSourceDataSourceContainer();
        DBPDataSourceContainer targetDataSourceContainer = this.options.getTargetDataSourceContainer();
        if (sourceDataSourceContainer != null && targetDataSourceContainer != null) {
            this.options.setSourceInputObjects(new ArrayList((Collection)dataSourceObjectMap.get(sourceDataSourceContainer)));
            this.options.setTargetInputObjects(new ArrayList((Collection)dataSourceObjectMap.get(targetDataSourceContainer)));
        } else if (sourceDataSourceContainer != null) {
            if (!emptyTarget) {
                this.options.setTargetDataSourceContainer(sourceDataSourceContainer);
            }
            if (containerObjectMap.size() > 1) {
                Iterator objectIterator = containerObjectMap.values().iterator();
                this.options.setSourceInputObjects(new ArrayList((Collection)objectIterator.next()));
                if (!emptyTarget) {
                    this.options.setTargetInputObjects(new ArrayList((Collection)objectIterator.next()));
                }
            } else if (!containerObjectMap.isEmpty()) {
                Set allObjects = (Set)containerObjectMap.values().iterator().next();
                Iterator objectIterator = allObjects.iterator();
                this.options.setSourceInputObjects((List)(objectIterator.hasNext() ? new ArrayList<DBSObject>(Collections.singletonList((DBSObject)objectIterator.next())) : new ArrayList()));
                if (!emptyTarget) {
                    if (objectIterator.hasNext()) {
                        DBSObject nextObject = (DBSObject)objectIterator.next();
                        if (nextObject instanceof DBSStructContainer) {
                            this.options.setTargetInputObjects(new ArrayList<DBSObject>(Collections.singletonList(nextObject)));
                        }
                    } else {
                        this.options.setTargetInputObjects(new ArrayList());
                    }
                }
            }
        }
    }

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public boolean isMakeDiff() {
        return this.makeDiff;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.pageSettings) {
            return null;
        }
        return super.getNextPage(page);
    }

    public boolean performFinish() {
        TaskConfigurationWizardDialog container = this.getContainer();
        this.saveLocalSettings();
        try {
            DBTTask task = this.getProject().getTaskManager().createTemporaryTask(this.getTaskType(), this.getWindowTitle());
            this.saveConfigurationToTask(task);
            container.disableButtonsOnProgress();
            TaskWizardExecutor executor = new TaskWizardExecutor(this.getRunnableContext(), task, log, System.out){

                public void taskFinished(@Nullable DBTTask task, @Nullable Object result, @Nullable Throwable error, @Nullable Object settings) {
                    super.taskFinished(task, result, error, settings);
                    if (result instanceof CMPResult && settings instanceof CMPOptions) {
                        SchemaCompareWizard.this.getDiffResultPage().populateResults((CMPOptions)settings, (CMPResult)result);
                    }
                    if (error == null) {
                        UIUtils.syncExec(() -> SchemaCompareWizard.this.getContainer().showPage((IWizardPage)SchemaCompareWizard.this.getDiffResultPage()));
                    }
                }
            };
            executor.executeTask();
            container.enableButtonsAfterProgress();
            container.setCompleteMarkAfterProgress();
            return false;
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Data Compare", "Error executing task", (Throwable)e);
            return true;
        }
    }

    private void saveLocalSettings() {
        CMPOptions options = this.getSettings();
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        store.setValue("@dbeaver-create-missing-objects@", options.isDoCreate());
        store.setValue("@dbeaver-alter-existing-objects@", options.isDoChange());
        store.setValue("@dbeaver-drop-unexpected-objects@", options.isDoDrop());
        store.setValue("case-insensitive-compare", options.isCaseInsensitiveCompare());
        boolean exportFile = options.isExportFile();
        store.setValue("export-result-file", exportFile);
        if (exportFile) {
            store.setValue("scmp.output-folder-path", options.getOutputFolderPath());
            store.setValue("scmp.output-file-pattern", options.getOutputFilePattern());
            store.setValue("report-engine", options.getReportEngineId());
        }
    }

    private SchemaComparePageDiff getDiffResultPage() {
        return this.pageDiff;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        this.workbench = workbench;
        this.selection = selection;
        DBTTask currentTask = this.getCurrentTask();
        if (currentTask != null && !currentTask.isTemporary() && !currentTask.getProperties().isEmpty()) {
            this.options = new CMPOptions(!this.makeDiff, UIUtils.getDefaultRunnableContext(), currentTask.getProperties());
        } else {
            this.options = new CMPOptions(DBWorkbench.getPlatform().getPreferenceStore(), !this.makeDiff);
            try {
                this.fillInputsFromSelection();
            }
            catch (Exception e) {
                log.error((Object)"Can't check selected objects", (Throwable)e);
            }
        }
        this.pageInput = new SchemaComparePageInput(this);
        this.pageSettings = new SchemaCompareWizardPageSettings();
        this.pageDiff = new SchemaComparePageDiff();
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)this.pageInput);
        this.addPage((IWizardPage)this.pageSettings);
        this.addPage((IWizardPage)this.pageDiff);
    }

    protected String getDefaultWindowTitle() {
        return this.makeDiff ? LBMessages.wizard_schema_compare_window_title_schema_compare : LBMessages.wizard_schema_compare_window_title_liquibase_changelog;
    }

    public String getTaskTypeId() {
        return this.makeDiff ? "schemaCompare" : "schemaChangelog";
    }

    public void saveTaskState(DBRRunnableContext runnableContext, DBTTask task, Map<String, Object> state) {
        this.options.saveConfiguration(state);
    }

    @NotNull
    public DBPProject getProject() {
        return DBWorkbench.getPlatform().getWorkspace().getActiveProject();
    }

    protected CMPOptions getSettings() {
        return this.options;
    }

    boolean isValidMapping() {
        List targetContainers;
        List sourceContainers = CMPUtils.getContainers((Collection)this.options.getSourceInputObjects(), DBSObjectContainer.class, (boolean)false);
        List list = targetContainers = this.options.isOnlyChangelog() ? Collections.emptyList() : CMPUtils.getContainers((Collection)this.options.getTargetInputObjects(), DBSObjectContainer.class, (boolean)false);
        if (sourceContainers.isEmpty() || !this.options.isOnlyChangelog() && targetContainers.isEmpty()) {
            return false;
        }
        return this.options.isOnlyChangelog() || sourceContainers.size() == targetContainers.size();
    }

    boolean isSrcSameAsTarget() {
        if (this.options == null || this.options.isOnlyChangelog()) {
            return false;
        }
        if (this.options.getSourceDataSourceContainer() != this.options.getTargetDataSourceContainer()) {
            return false;
        }
        ArrayList targets = new ArrayList(this.options.getTargetInputObjects());
        for (DBSObject o : this.options.getSourceInputObjects()) {
            int idx = targets.indexOf(o);
            if (idx < 0) {
                return false;
            }
            targets.remove(idx);
        }
        return targets.size() <= 0;
    }
}

