/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.scmp.ui.wizard;

import com.dbeaver.ee.scmp.SCMPConstants;
import com.dbeaver.ee.scmp.internal.ui.LBMessages;
import com.dbeaver.ee.scmp.model.CMPException;
import com.dbeaver.ee.scmp.model.CMPOptions;
import com.dbeaver.ee.scmp.ui.wizard.SchemaCompareWizard;
import com.dbeaver.ee.scmp.ui.wizard.SchemaMappingDialog;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import liquibase.Scope;
import liquibase.license.LicenseInstallResult;
import liquibase.license.LicenseService;
import liquibase.license.LicenseServiceFactory;
import liquibase.license.Location;
import liquibase.license.LocationType;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCRemoteInstance;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNode;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableParametrized;
import org.jkiss.dbeaver.model.runtime.DefaultProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSStructContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomSashForm;
import org.jkiss.dbeaver.ui.controls.SelectDataSourceCombo;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.dbeaver.ui.navigator.INavigatorFilter;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTree;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTreeFilter;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTreeFilterObjectType;
import org.jkiss.dbeaver.ui.navigator.database.load.TreeNodeSpecial;
import org.jkiss.utils.CommonUtils;

class SchemaComparePageInput
extends ActiveWizardPage<SchemaCompareWizard> {
    private static final Log log = Log.getLog(SchemaComparePageInput.class);
    private DatabaseNavigatorTree sourceTree;
    private DatabaseNavigatorTree targetTree;
    private CMPOptions cmpOptions;
    private SelectDataSourceCombo sourceDSSelectCombo;
    private SelectDataSourceCombo targetDSSelectCombo;

    SchemaComparePageInput(SchemaCompareWizard wizard) {
        super("Input objects");
        this.setTitle(wizard.getSettings().isOnlyChangelog() ? LBMessages.wizard_schema_compare_input_title_specify_objects : LBMessages.wizard_schema_compare_input_title_specify_input);
        String description = LBMessages.wizard_schema_compare_input_title_specify_input_title;
        description = String.valueOf(description) + LBMessages.wizard_schema_compare_input_title_specify_description;
        this.setDescription(description);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        boolean doDiff = !((SchemaCompareWizard)this.getWizard()).getSettings().isOnlyChangelog();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        Composite sourceTargetPanel = UIUtils.createComposite((Composite)composite, (int)(doDiff ? 2 : 1));
        sourceTargetPanel.setLayoutData((Object)new GridData(1808));
        sourceTargetPanel.setLayout((Layout)new FillLayout());
        CustomSashForm panelDivider = UIUtils.createPartDivider(null, (Composite)sourceTargetPanel, (int)256);
        this.cmpOptions = ((SchemaCompareWizard)this.getWizard()).getSettings();
        this.sourceTree = this.createObjectSelectorPanel((Composite)panelDivider, LBMessages.wizard_schema_compare_input_panel_title_source, true);
        this.addDoubleClickListener(this.sourceTree);
        if (doDiff) {
            this.targetTree = this.createObjectSelectorPanel((Composite)panelDivider, LBMessages.wizard_schema_compare_input_panel_title_target, false);
            this.addDoubleClickListener(this.targetTree);
        }
        DBPPreferenceStore globalPreferences = DBWorkbench.getPlatform().getPreferenceStore();
        this.checkLBLicense(globalPreferences);
        this.checkLBLogLevel(globalPreferences);
        if (doDiff) {
            Composite settingsPanel = UIUtils.createComposite((Composite)composite, (int)3);
            Composite buttonsGroup = UIUtils.createComposite((Composite)settingsPanel, (int)3);
            buttonsGroup.setLayoutData((Object)new GridData(2));
            UIUtils.createDialogButton((Composite)buttonsGroup, (String)LBMessages.wizard_schema_compare_input_schema_mapping, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SchemaComparePageInput.this.showSchemaMappings();
                }
            });
            UIUtils.createDialogButton((Composite)buttonsGroup, (String)LBMessages.wizard_schema_compare_button_preferences, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    UIUtils.showPreferencesFor((Shell)SchemaComparePageInput.this.getShell(), null, (String[])new String[]{"com.dbeaver.ee.scmp.ui.preferencePages.page.schemaCompare"});
                }
            });
            Composite switchGroup = UIUtils.createComposite((Composite)settingsPanel, (int)1);
            switchGroup.setLayoutData((Object)new GridData(128));
            UIUtils.createPushButton((Composite)switchGroup, (String)LBMessages.wizard_schema_compare_input_push_button_swap_sources, (Image)DBeaverIcons.getImage((DBPImage)UIIcon.LINK_TO_EDITOR), (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SchemaComparePageInput.this.swapSources();
                }
            });
        }
        this.setControl((Control)composite);
    }

    private void addDoubleClickListener(@NotNull DatabaseNavigatorTree navigatorTree) {
        TreeViewer treeViewer = navigatorTree.getViewer();
        treeViewer.addDoubleClickListener(event -> {
            IStructuredSelection selection = (IStructuredSelection)treeViewer.getSelection();
            Object[] objectArray = selection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object node = objectArray[n2];
                if (node instanceof TreeNodeSpecial) {
                    ((TreeNodeSpecial)node).handleDefaultAction(navigatorTree);
                }
                ++n2;
            }
        });
    }

    private void checkLBLicense(DBPPreferenceStore globalPreferences) {
        String property = System.getProperty("liquibase.license.key");
        String licenseInPreferences = globalPreferences.getString("@dbeaver-prop-lb-lic@");
        if (CommonUtils.isNotEmpty((String)property)) {
            this.checkLicenseState(property);
        } else if (CommonUtils.isNotEmpty((String)licenseInPreferences)) {
            this.checkLicenseState(licenseInPreferences);
        }
    }

    private void checkLBLogLevel(DBPPreferenceStore globalPreferences) {
        SCMPConstants.LogLevels logLevel = (SCMPConstants.LogLevels)CommonUtils.valueOf(SCMPConstants.LogLevels.class, (String)globalPreferences.getString("@dbeaver-prop-lb-log-level@"), (Enum)SCMPConstants.LogLevels.OFF);
        this.cmpOptions.setLogLevel(logLevel);
    }

    private boolean checkLicenseState(String key) {
        LicenseService licenseService = ((LicenseServiceFactory)Scope.getCurrentScope().getSingleton(LicenseServiceFactory.class)).getLicenseService();
        Location licenseKeyLocation = new Location("property liquibaseProLicenseKey", LocationType.BASE64_STRING, key);
        LicenseInstallResult licenseInstallResult = licenseService.installLicense(new Location[]{licenseKeyLocation});
        if (licenseInstallResult.code == 0) {
            this.cmpOptions.setHasLiquibaseLicense(true);
            return true;
        }
        return false;
    }

    private void swapSources() {
        SchemaCompareWizard cfr_ignored_0 = (SchemaCompareWizard)this.getWizard();
        if (this.cmpOptions != null && !this.cmpOptions.isOnlyChangelog()) {
            DBPDataSourceContainer sourceDataSourceContainer = this.cmpOptions.getSourceDataSourceContainer();
            DBPDataSourceContainer targetDataSourceContainer = this.cmpOptions.getTargetDataSourceContainer();
            List sourceInputObjects = this.cmpOptions.getSourceInputObjects();
            List targetInputObjects = this.cmpOptions.getTargetInputObjects();
            this.cmpOptions.setSourceDataSourceContainer(targetDataSourceContainer);
            this.cmpOptions.setSourceInputObjects(targetInputObjects);
            this.cmpOptions.setTargetDataSourceContainer(sourceDataSourceContainer);
            this.cmpOptions.setTargetInputObjects(sourceInputObjects);
            this.cmpOptions.refreshSchemaMappings(true);
        }
        DBNNode sourceTreeModel = this.sourceTree.getModel();
        Object[] sourceCheckedElements = this.sourceTree.getCheckboxViewer().getCheckedElements();
        Object[] sourceExpandedElements = this.sourceTree.getViewer().getExpandedElements();
        DBNNode targetTreeModel = this.targetTree.getModel();
        Object[] targetCheckedElements = this.targetTree.getCheckboxViewer().getCheckedElements();
        Object[] targetExpandedElements = this.targetTree.getViewer().getExpandedElements();
        this.sourceTree.setInput(targetTreeModel);
        this.sourceTree.getCheckboxViewer().setCheckedElements(targetCheckedElements);
        this.targetTree.setInput(sourceTreeModel);
        this.targetTree.getCheckboxViewer().setCheckedElements(sourceCheckedElements);
        this.sourceTree.getViewer().setExpandedElements(targetExpandedElements);
        this.targetTree.getViewer().setExpandedElements(sourceExpandedElements);
        this.sourceTree.redraw();
        this.targetTree.redraw();
        if (!this.cmpOptions.isOnlyChangelog()) {
            this.sourceDSSelectCombo.select((Object)this.cmpOptions.getSourceDataSourceContainer());
            this.targetDSSelectCombo.select((Object)this.cmpOptions.getTargetDataSourceContainer());
            this.sourceDSSelectCombo.redraw();
            this.targetDSSelectCombo.redraw();
        }
    }

    private void showSchemaMappings() {
        SchemaMappingDialog dialog = new SchemaMappingDialog(this.getShell(), ((SchemaCompareWizard)this.getWizard()).getSettings());
        dialog.open();
    }

    private DatabaseNavigatorTree createObjectSelectorPanel(@NotNull Composite parent, @NotNull String panelTitle, boolean isSource) {
        List inputObjects;
        Composite group = UIUtils.createComposite((Composite)parent, (int)1);
        Composite dsPanel = UIUtils.createComposite((Composite)group, (int)2);
        dsPanel.setLayoutData((Object)new GridData(768));
        UIUtils.createControlLabel((Composite)dsPanel, (String)panelTitle);
        final SchemaCompareWizard wizard = (SchemaCompareWizard)this.getWizard();
        SelectDataSourceCombo dsSelectCombo = new SelectDataSourceCombo(dsPanel){

            protected DBPProject getActiveProject() {
                return wizard.getProject();
            }
        };
        GridData gd = new GridData(768);
        gd.widthHint = 200;
        dsSelectCombo.setLayoutData((Object)gd);
        dsSelectCombo.addProjectDataSources();
        ObjectNavigatorFilter filter = new ObjectNavigatorFilter(isSource);
        DatabaseNavigatorTree dataSourceTree = new DatabaseNavigatorTree(group, null, 2084, true, (INavigatorFilter)filter);
        gd = new GridData(1808);
        gd.minimumHeight = 100;
        gd.minimumWidth = 200;
        dataSourceTree.setLayoutData((Object)gd);
        dataSourceTree.setFilterObjectType(DatabaseNavigatorTreeFilterObjectType.container);
        DataSourceSelectListener dsSelectListener = new DataSourceSelectListener(dataSourceTree, isSource);
        dsSelectCombo.addSelectionListener((DBRRunnableParametrized)dsSelectListener);
        DBPDataSourceContainer container = isSource ? this.cmpOptions.getSourceDataSourceContainer() : this.cmpOptions.getTargetDataSourceContainer();
        dsSelectCombo.select((Object)container);
        if (isSource) {
            this.sourceDSSelectCombo = dsSelectCombo;
        } else {
            this.targetDSSelectCombo = dsSelectCombo;
        }
        dsSelectListener.loadObjects(container);
        CheckboxTreeViewer treeViewer = (CheckboxTreeViewer)dataSourceTree.getViewer();
        treeViewer.addCheckStateListener((ICheckStateListener)new ObjectsStateListener(treeViewer, isSource));
        List list = inputObjects = isSource ? this.cmpOptions.getSourceInputObjects() : this.cmpOptions.getTargetInputObjects();
        if (!CommonUtils.isEmpty((Collection)inputObjects)) {
            treeViewer.getControl().setRedraw(false);
            try {
                Iterator iterator = inputObjects.iterator();
                while (iterator.hasNext()) {
                    DBNDatabaseNode objectNode;
                    DBSObject object = (DBSObject)iterator.next();
                    if (!isSource && !(object instanceof DBSStructContainer)) {
                        object = object.getParentObject();
                    }
                    if ((objectNode = DBNUtils.getNodeByObject((DBRProgressMonitor)new VoidProgressMonitor(), (DBSObject)object, (boolean)false)) != null && this.isSelectableNode(objectNode)) {
                        if (object instanceof DBSObjectContainer) {
                            treeViewer.setGrayChecked((Object)objectNode, true);
                        } else {
                            treeViewer.setChecked((Object)objectNode, true);
                        }
                        treeViewer.reveal((Object)objectNode);
                        continue;
                    }
                    iterator.remove();
                }
            }
            finally {
                treeViewer.getControl().setRedraw(true);
            }
        }
        return dataSourceTree;
    }

    private boolean isSelectableNode(DBNDatabaseNode node) {
        Object valueObject;
        if (node instanceof DBNDatabaseFolder) {
            Class folderChildren = ((DBNDatabaseFolder)node).getChildrenClass();
            return folderChildren != null && DBSEntity.class.isAssignableFrom(folderChildren);
        }
        if (node instanceof DBNDataSource && (valueObject = node.getValueObject()) instanceof DBSObjectContainer) {
            try {
                return DBSTable.class.isAssignableFrom(((DBSObjectContainer)valueObject).getPrimaryChildType((DBRProgressMonitor)new VoidProgressMonitor()));
            }
            catch (DBException e) {
                log.debug((Object)"Can't find primary child type", (Throwable)e);
                return false;
            }
        }
        DBSObject object = node.getObject();
        if (object instanceof DBSEntity) {
            return true;
        }
        if (object instanceof DBSObjectContainer) {
            try {
                Class childType = ((DBSObjectContainer)object).getPrimaryChildType((DBRProgressMonitor)new VoidProgressMonitor());
                return childType != null && DBSEntity.class.isAssignableFrom(childType);
            }
            catch (DBException e) {
                log.debug((Object)e);
                return false;
            }
        }
        return false;
    }

    private void checkInputObject(List<DBSObject> inputObjects, DBSObject object) throws CMPException {
        DBSInstance newInstance = DBUtils.getObjectOwnerInstance((DBSObject)object);
        if (!(newInstance instanceof JDBCRemoteInstance)) {
            throw new CMPException("Only JDBC connections can be compared");
        }
        if (inputObjects.isEmpty()) {
            return;
        }
        DBSInstance curInstance = DBUtils.getObjectOwnerInstance((DBSObject)inputObjects.get(0));
        if (curInstance != newInstance) {
            throw new CMPException("You can't select objects which belong to different physical connections (" + curInstance.getName() + ", " + newInstance.getName() + ")");
        }
    }

    public void activatePage() {
        this.updatePageCompletion();
    }

    public void deactivatePage() {
    }

    protected boolean determinePageCompletion() {
        boolean doDiff;
        SchemaCompareWizard wizard = (SchemaCompareWizard)this.getWizard();
        if (this.cmpOptions.getSourceInputObjects().isEmpty()) {
            this.setErrorMessage("You must specify at least one input object");
            return false;
        }
        boolean bl = doDiff = !this.cmpOptions.isOnlyChangelog();
        if (doDiff && this.cmpOptions.getTargetInputObjects().isEmpty()) {
            this.setErrorMessage("You must specify at least one target schema");
            return false;
        }
        if (wizard.isSrcSameAsTarget()) {
            this.setErrorMessage("Source and target schema(s) must be different");
            return false;
        }
        if (!wizard.isValidMapping()) {
            this.setErrorMessage("Number of input schemas don't match target schemas");
            return false;
        }
        this.setErrorMessage(null);
        if (doDiff) {
            wizard.getSettings().refreshSchemaMappings(false);
        }
        return true;
    }

    private class DataSourceSelectListener
    implements DBRRunnableParametrized<DBPDataSourceContainer> {
        private final DatabaseNavigatorTree dataSourceTree;
        private final boolean isSource;

        DataSourceSelectListener(DatabaseNavigatorTree dataSourceTree, boolean isSource) {
            this.dataSourceTree = dataSourceTree;
            this.isSource = isSource;
        }

        public void run(DBPDataSourceContainer selectedDataSource) {
            if (this.isSource) {
                SchemaComparePageInput.this.cmpOptions.setSourceInputObjects(new ArrayList());
                SchemaComparePageInput.this.cmpOptions.setSourceDataSourceContainer(selectedDataSource);
            } else {
                SchemaComparePageInput.this.cmpOptions.setTargetInputObjects(new ArrayList());
                SchemaComparePageInput.this.cmpOptions.setTargetDataSourceContainer(selectedDataSource);
            }
            this.loadObjects(selectedDataSource);
        }

        void loadObjects(DBPDataSourceContainer selectedDataSource) {
            DBNModel model = DBWorkbench.getPlatform().getNavigatorModel();
            DBNDatabaseNode dsNode = selectedDataSource == null ? null : model.getNodeByObject((DBSObject)selectedDataSource);
            this.dataSourceTree.setInput((DBNNode)dsNode);
            this.dataSourceTree.getViewer().expandToLevel(2);
            TreeItem topItem = this.dataSourceTree.getViewer().getTree().getTopItem();
            if (topItem != null && topItem.getItemCount() == 1) {
                this.dataSourceTree.getViewer().expandToLevel(1);
            }
            SchemaComparePageInput.this.updatePageCompletion();
        }
    }

    private static class ObjectNavigatorFilter
    extends DatabaseNavigatorTreeFilter {
        private final boolean showSchemaObjects;

        public ObjectNavigatorFilter(boolean showSchemaObjects) {
            this.showSchemaObjects = showSchemaObjects;
        }

        public boolean filterFolders() {
            return true;
        }

        public boolean isLeafObject(Object object) {
            if (object instanceof DBNDatabaseNode) {
                DBNDatabaseNode databaseNode = (DBNDatabaseNode)object;
                DBSObject dbObject = databaseNode.getObject();
                if (!this.showSchemaObjects) {
                    if (dbObject instanceof DBSSchema) {
                        DBXTreeNode meta = databaseNode.getMeta();
                        return !DBNNode.nodeHasStructureContainers((DBNNode)databaseNode, (DBXTreeNode)meta);
                    }
                    if (dbObject instanceof DBSCatalog) {
                        try {
                            Class childType = ((DBSCatalog)dbObject).getPrimaryChildType((DBRProgressMonitor)new VoidProgressMonitor());
                            if (!DBSSchema.class.isAssignableFrom(childType)) {
                                return true;
                            }
                        }
                        catch (DBException e) {
                            log.debug((Object)e);
                        }
                    }
                }
                if (dbObject instanceof DBSEntityAttribute) {
                    return true;
                }
            }
            return false;
        }

        public boolean select(Object element) {
            DBSObject object;
            if (element instanceof DBNDatabaseFolder) {
                Class folderChildren = ((DBNDatabaseFolder)element).getChildrenClass();
                if (folderChildren == null) {
                    return false;
                }
                if (!this.isGoodClass(folderChildren)) {
                    return false;
                }
            } else if (element instanceof DBNDatabaseNode && !this.isGoodClass((object = ((DBNDatabaseNode)element).getObject()).getClass())) {
                return false;
            }
            return true;
        }

        private boolean isGoodClass(Class<? extends DBSObject> folderChildren) {
            if (!this.showSchemaObjects) {
                return DBPDataSourceContainer.class.isAssignableFrom(folderChildren) || DBSObjectContainer.class.isAssignableFrom(folderChildren);
            }
            return DBPDataSourceContainer.class.isAssignableFrom(folderChildren) || DBSEntity.class.isAssignableFrom(folderChildren) && !DBSDataType.class.isAssignableFrom(folderChildren) || DBSObjectContainer.class.isAssignableFrom(folderChildren);
        }
    }

    private class ObjectsStateListener
    implements ICheckStateListener {
        private final CheckboxTreeViewer treeViewer;
        private boolean isSource;

        ObjectsStateListener(CheckboxTreeViewer treeViewer, boolean isSource) {
            this.treeViewer = treeViewer;
            this.isSource = isSource;
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            List inputObjects;
            boolean isFolder;
            Object element = event.getElement();
            if (!(element instanceof DBNDatabaseNode)) {
                this.treeViewer.setGrayed(element, false);
                this.treeViewer.setChecked(element, false);
                return;
            }
            if (!SchemaComparePageInput.this.isSelectableNode((DBNDatabaseNode)element)) {
                this.treeViewer.setGrayed(element, false);
                this.treeViewer.setChecked(element, false);
                UIUtils.showMessageBox((Shell)SchemaComparePageInput.this.getShell(), (String)"Wrong node", (String)("You can't select item '" + element + "' (" + ((DBNDatabaseNode)element).getNodeType() + "). Only tables or table containers are allowed."), (int)8);
                return;
            }
            boolean bl = isFolder = element instanceof DBNDatabaseFolder || ((DBNDatabaseNode)element).getObject() instanceof DBSObjectContainer;
            if (event.getChecked()) {
                this.treeViewer.setGrayed(element, isFolder);
            }
            List list = inputObjects = this.isSource ? SchemaComparePageInput.this.cmpOptions.getSourceInputObjects() : SchemaComparePageInput.this.cmpOptions.getTargetInputObjects();
            if (element instanceof DBNDatabaseFolder) {
                this.toggleFolderObjects((DBNDatabaseFolder)element, event.getChecked());
            } else {
                DBSObject object = ((DBNDatabaseNode)element).getObject();
                if (event.getChecked()) {
                    if (!inputObjects.contains(object)) {
                        try {
                            SchemaComparePageInput.this.checkInputObject(inputObjects, object);
                            inputObjects.add(object);
                        }
                        catch (Exception e) {
                            this.treeViewer.setChecked(element, false);
                            DBWorkbench.getPlatformUI().showError("Wrong object", "You can't add object [" + object.getName() + "]", (Throwable)e);
                        }
                    }
                } else {
                    inputObjects.remove(object);
                }
            }
            SchemaComparePageInput.this.updatePageCompletion();
        }

        private void toggleFolderObjects(DBNDatabaseFolder folder, boolean checked) {
            try {
                SchemaComparePageInput.this.getContainer().run(false, true, monitor -> {
                    try {
                        DBNDatabaseNode[] children = folder.getChildren((DBRProgressMonitor)new DefaultProgressMonitor(monitor));
                        if (children != null) {
                            List inputObjects = this.isSource ? SchemaComparePageInput.this.cmpOptions.getSourceInputObjects() : SchemaComparePageInput.this.cmpOptions.getTargetInputObjects();
                            DBNDatabaseNode[] dBNDatabaseNodeArray = children;
                            int n = children.length;
                            int n2 = 0;
                            while (n2 < n) {
                                DBNDatabaseNode child = dBNDatabaseNodeArray[n2];
                                DBSObject object = child.getObject();
                                SchemaComparePageInput.this.checkInputObject(inputObjects, object);
                                if (checked) {
                                    inputObjects.add(object);
                                } else {
                                    inputObjects.remove(object);
                                }
                                ++n2;
                            }
                            UIUtils.asyncExec(() -> {
                                DBNDatabaseNode[] dBNDatabaseNodeArray2 = children;
                                int n = children.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    DBNDatabaseNode child = dBNDatabaseNodeArray2[n2];
                                    this.treeViewer.setChecked((Object)child, checked);
                                    ++n2;
                                }
                            });
                        }
                    }
                    catch (DBException e) {
                        throw new InvocationTargetException(e);
                    }
                });
            }
            catch (InvocationTargetException e) {
                log.error((Object)e.getTargetException());
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

