/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.scmp.ui;

import com.dbeaver.ee.scmp.SCMPConstants;
import com.dbeaver.ee.scmp.internal.ui.LBMessages;
import com.dbeaver.ee.scmp.ui.ImportLBKeyDialog;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.dbeaver.ui.preferences.PreferenceStoreDelegate;
import org.jkiss.dbeaver.utils.HelpUtils;
import org.jkiss.dbeaver.utils.PrefUtils;
import org.jkiss.utils.CommonUtils;

public class PrefPageSchemaCompare
extends AbstractPrefPage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    public static final String PAGE_ID = "com.dbeaver.ee.scmp.ui.preferencePages.page.schemaCompare";
    private static final String SCHEMA_COMPARE_LINK = "Schema-compare";
    private IAdaptable element;
    private Button createObjects;
    private Button alterObjects;
    private Button dropObjects;
    private Button caseInsensitiveCompare;
    private Button quoteAllObjects;
    private Combo logLevelCombo;

    public PrefPageSchemaCompare() {
        this.setPreferenceStore((IPreferenceStore)new PreferenceStoreDelegate(DBWorkbench.getPlatform().getPreferenceStore()));
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        SCMPConstants.LogLevels logLevel;
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1);
        DBPPreferenceStore globalPreferences = DBWorkbench.getPlatform().getPreferenceStore();
        this.initDefaultPreferences(globalPreferences);
        Link scmpDocumentation = new Link(composite, 0);
        scmpDocumentation.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
        scmpDocumentation.setText("<a>Schema Compare Documentation</a>");
        scmpDocumentation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShellUtils.launchProgram((String)HelpUtils.getHelpExternalReference((String)PrefPageSchemaCompare.SCHEMA_COMPARE_LINK));
            }
        });
        Group objectsActions = UIUtils.createControlGroup((Composite)composite, (String)LBMessages.preference_schema_compare_control_group_generate_diff, (int)1, (int)800, (int)0);
        this.createObjects = UIUtils.createCheckbox((Composite)objectsActions, (String)LBMessages.wizard_schema_compare_input_options_create_objects, (String)LBMessages.wizard_schema_compare_input_options_create_objects_tip, (boolean)globalPreferences.getBoolean("@dbeaver-create-missing-objects@"), (int)1);
        this.alterObjects = UIUtils.createCheckbox((Composite)objectsActions, (String)LBMessages.wizard_schema_compare_input_options_alter_objects, (String)LBMessages.wizard_schema_compare_input_options_alter_objects_tip, (boolean)globalPreferences.getBoolean("@dbeaver-alter-existing-objects@"), (int)1);
        this.dropObjects = UIUtils.createCheckbox((Composite)objectsActions, (String)LBMessages.wizard_schema_compare_input_options_drop_objects, (String)LBMessages.wizard_schema_compare_input_options_drop_objects_tip, (boolean)globalPreferences.getBoolean("@dbeaver-drop-unexpected-objects@"), (int)1);
        this.caseInsensitiveCompare = UIUtils.createCheckbox((Composite)objectsActions, (String)LBMessages.wizard_schema_compare_input_options_case_insensitive, (String)LBMessages.wizard_schema_compare_input_options_case_insensitive_tip, (boolean)globalPreferences.getBoolean("case-insensitive-compare"), (int)1);
        Group micsSettings = UIUtils.createControlGroup((Composite)composite, (String)LBMessages.preference_schema_compare_control_group_mics_settings, (int)1, (int)800, (int)0);
        this.quoteAllObjects = UIUtils.createCheckbox((Composite)micsSettings, (String)LBMessages.preference_schema_compare_diff_button_quote_objects, (String)LBMessages.preference_schema_compare_diff_button_quote_objects_tip, (boolean)globalPreferences.getBoolean("quote-all-objects"), (int)1);
        Group logSettings = UIUtils.createControlGroup((Composite)composite, (String)LBMessages.preference_schema_compare_control_group_logging, (int)2, (int)2, (int)0);
        this.logLevelCombo = UIUtils.createLabelCombo((Composite)logSettings, (String)LBMessages.preference_schema_compare_label_combo_log_level, (int)12);
        SCMPConstants.LogLevels[] logLevelsArray = SCMPConstants.LogLevels.values();
        int n = logLevelsArray.length;
        int n2 = 0;
        while (n2 < n) {
            logLevel = logLevelsArray[n2];
            this.logLevelCombo.add(logLevel.name());
            ++n2;
        }
        logLevel = (SCMPConstants.LogLevels)CommonUtils.valueOf(SCMPConstants.LogLevels.class, (String)globalPreferences.getString("@dbeaver-prop-lb-log-level@"), (Enum)SCMPConstants.LogLevels.OFF);
        this.logLevelCombo.setText(logLevel.name());
        Button dialogButton = UIUtils.createDialogButton((Composite)composite, (String)LBMessages.preference_schema_compare_dialog_button_import_key, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportLBKeyDialog dialog = new ImportLBKeyDialog(PrefPageSchemaCompare.this.getShell());
                dialog.open();
            }
        });
        dialogButton.setLayoutData((Object)new GridData(1, 1, true, false));
        return composite;
    }

    public boolean performOk() {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        store.setValue("@dbeaver-create-missing-objects@", String.valueOf(this.createObjects.getSelection()));
        store.setValue("@dbeaver-alter-existing-objects@", String.valueOf(this.alterObjects.getSelection()));
        store.setValue("@dbeaver-drop-unexpected-objects@", String.valueOf(this.dropObjects.getSelection()));
        store.setValue("case-insensitive-compare", String.valueOf(this.caseInsensitiveCompare.getSelection()));
        store.setValue("quote-all-objects", String.valueOf(this.quoteAllObjects.getSelection()));
        store.setValue("@dbeaver-prop-lb-log-level@", String.valueOf(this.logLevelCombo.getText()));
        return true;
    }

    protected void performDefaults() {
        this.createObjects.setSelection(true);
        this.alterObjects.setSelection(true);
        this.dropObjects.setSelection(true);
        this.caseInsensitiveCompare.setSelection(false);
        this.quoteAllObjects.setSelection(true);
        this.logLevelCombo.setText(SCMPConstants.LogLevels.OFF.name());
    }

    public void init(IWorkbench workbench) {
    }

    private void initDefaultPreferences(DBPPreferenceStore globalPreferences) {
        PrefUtils.setDefaultPreferenceValue((DBPPreferenceStore)globalPreferences, (String)"@dbeaver-create-missing-objects@", (Object)true);
        PrefUtils.setDefaultPreferenceValue((DBPPreferenceStore)globalPreferences, (String)"@dbeaver-alter-existing-objects@", (Object)true);
        PrefUtils.setDefaultPreferenceValue((DBPPreferenceStore)globalPreferences, (String)"@dbeaver-drop-unexpected-objects@", (Object)true);
        PrefUtils.setDefaultPreferenceValue((DBPPreferenceStore)globalPreferences, (String)"case-insensitive-compare", (Object)false);
        PrefUtils.setDefaultPreferenceValue((DBPPreferenceStore)globalPreferences, (String)"quote-all-objects", (Object)true);
    }

    public IAdaptable getElement() {
        return this.element;
    }

    public void setElement(IAdaptable element) {
        this.element = element;
    }
}

