/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.sqlite;

import com.dbeaver.db.sqlite.model.SQLiteAttachedDatabase;
import com.dbeaver.db.sqlite.model.SQLiteSQLDialectExt;
import java.io.File;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.ext.sqlite.model.SQLiteDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class SQLiteDataSourceExt
extends SQLiteDataSource {
    private static final String SQL_ATTACH_DATABASE = "ATTACH DATABASE ? AS ?";

    public SQLiteDataSourceExt(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container, @NotNull GenericMetaModel metaModel) throws DBException {
        super(monitor, container, metaModel, (SQLDialect)new SQLiteSQLDialectExt());
        this.attachDatabases(monitor, this.getContainer().getConnectionConfiguration());
    }

    private void attachDatabases(@NotNull DBRProgressMonitor monitor, @NotNull DBPConnectionConfiguration configuration) throws DBException {
        if (CommonUtils.toBoolean((Object)configuration.getProviderProperty("use-attached-databases")) && !CommonUtils.isEmpty((String)configuration.getProviderProperty("sqlite-attached-databases-names"))) {
            String[] names = configuration.getProviderProperty("sqlite-attached-databases-names").split(",");
            String[] paths = configuration.getProviderProperty("sqlite-attached-databased-paths").split(File.pathSeparator);
            Throwable throwable = null;
            Object var6_7 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openUtilSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Attach databases");){
                try {
                    Throwable throwable2 = null;
                    Object var9_13 = null;
                    try (JDBCPreparedStatement statement = session.prepareStatement(SQL_ATTACH_DATABASE);){
                        int i = 0;
                        while (i < names.length) {
                            statement.setString(1, paths[i]);
                            statement.setString(2, names[i]);
                            statement.execute();
                            ++i;
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (SQLException ex) {
                    throw new DBException("Error attaching databases", (Throwable)ex);
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
    }

    @NotNull
    public Class<? extends DBSObject> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) throws DBException {
        if (CommonUtils.toBoolean((Object)this.getContainer().getConnectionConfiguration().getProviderProperty("use-attached-databases"))) {
            return SQLiteAttachedDatabase.class;
        }
        return super.getPrimaryChildType(monitor);
    }

    public void initialize(@NotNull DBRProgressMonitor monitor) throws DBException {
        super.initialize(monitor);
        DBPConnectionConfiguration configuration = this.getContainer().getConnectionConfiguration();
        String extensions = configuration.getProviderProperty("sqlite-extensions");
        if (CommonUtils.isNotEmpty((String)extensions)) {
            Throwable throwable = null;
            Object var5_6 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openUtilSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load extensions");){
                try {
                    Throwable throwable2 = null;
                    Object var8_12 = null;
                    try (JDBCPreparedStatement stmt = session.prepareStatement("SELECT load_extension(?)");){
                        String[] stringArray = extensions.split(File.pathSeparator);
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String extension = stringArray[n2];
                            try {
                                stmt.setString(1, extension);
                                stmt.executeQuery();
                            }
                            catch (SQLException e1) {
                                throw new DBCException("Error while loading extension '" + extension + "'", (Throwable)e1, (DBCExecutionContext)session.getExecutionContext());
                            }
                            ++n2;
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (SQLException e) {
                    throw new DBCException("Error loading extensions", (Throwable)e, (DBCExecutionContext)session.getExecutionContext());
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
    }
}

