/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.ai.preferences;

import java.io.IOException;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.ai.AISettings;
import org.jkiss.dbeaver.model.ai.gpt3.GPTCompletionEngine;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.registry.configurator.UIPropertyConfiguratorDescriptor;
import org.jkiss.dbeaver.registry.configurator.UIPropertyConfiguratorRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.ai.preferences.AIConfiguratorDefault;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;

public class AIPreferencePage
extends AbstractPrefPage
implements IWorkbenchPreferencePage {
    private static final Log log = Log.getLog(AIPreferencePage.class);
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.ai";
    private final AISettings settings;
    private IObjectPropertyConfigurator<GPTCompletionEngine, AISettings> configurator;

    public AIPreferencePage() {
        UIPropertyConfiguratorDescriptor cfgDescriptor = UIPropertyConfiguratorRegistry.getInstance().getDescriptor(GPTCompletionEngine.class.getName());
        if (cfgDescriptor != null) {
            try {
                this.configurator = cfgDescriptor.createConfigurator();
            }
            catch (DBException e) {
                log.error((Object)e);
            }
        }
        if (this.configurator == null) {
            this.configurator = new AIConfiguratorDefault();
        }
        this.settings = AISettings.getSettings();
    }

    protected void performDefaults() {
        this.configurator.loadSettings((Object)this.settings);
    }

    public boolean performOk() {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        this.configurator.saveSettings((Object)this.settings);
        try {
            store.save();
        }
        catch (IOException e) {
            log.debug((Object)e);
        }
        if (DBWorkbench.getPlatform().getWorkspace().hasRealmPermission("configuration-manager")) {
            this.settings.saveSettings();
        }
        return true;
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        Composite placeholder = UIUtils.createPlaceholder((Composite)parent, (int)1);
        placeholder.setLayoutData((Object)new GridData(1808));
        GPTCompletionEngine engine = new GPTCompletionEngine();
        this.configurator.createControl(placeholder, (Object)engine, () -> {});
        this.performDefaults();
        return placeholder;
    }

    public void init(IWorkbench workbench) {
    }
}

