/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.ai.preferences;

import java.util.Locale;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.ai.AIEngineSettings;
import org.jkiss.dbeaver.model.ai.AISettings;
import org.jkiss.dbeaver.model.ai.gpt3.GPTCompletionEngine;
import org.jkiss.dbeaver.model.ai.gpt3.GPTModel;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.ai.internal.AIUIMessages;
import org.jkiss.utils.CommonUtils;

public class AIConfiguratorDefault
implements IObjectPropertyConfigurator<GPTCompletionEngine, AISettings> {
    private static final String API_KEY_URL = "https://beta.openai.com/account/api-keys";
    private Button enableAICheck;
    private Button includeSourceTextInCommentCheck;
    private Button executeQueryImmediatelyCheck;
    private Text tokenText;
    private Combo modelCombo;
    private Text temperatureText;
    private Button logQueryCheck;

    public void createControl(@NotNull Composite placeholder, GPTCompletionEngine object, @NotNull Runnable propertyChangeListener) {
        this.enableAICheck = UIUtils.createCheckbox((Composite)placeholder, (String)"Enable smart completion", (String)"Enable AI smart completion. If you don't want to see it in SQL editor then you can disable this feature.", (boolean)false, (int)2);
        Group authorizationGroup = UIUtils.createControlGroup((Composite)placeholder, (String)AIUIMessages.gpt_preference_page_group_authorization, (int)2, (int)0, (int)5);
        this.tokenText = UIUtils.createLabelText((Composite)authorizationGroup, (String)AIUIMessages.gpt_preference_page_selector_token, (String)"", (int)0x400800);
        this.tokenText.setLayoutData((Object)new GridData(768));
        Link link = UIUtils.createLink((Composite)authorizationGroup, (String)"Copy-paste API token from <a>https://beta.openai.com/account/api-keys</a>", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UIUtils.openWebBrowser((String)AIConfiguratorDefault.API_KEY_URL);
            }
        });
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        link.setLayoutData((Object)gd);
        authorizationGroup.setLayoutData((Object)new GridData(768));
        Composite settingsPanel = UIUtils.createComposite((Composite)placeholder, (int)2);
        settingsPanel.setLayoutData((Object)new GridData(768));
        Group completionGroup = UIUtils.createControlGroup((Composite)settingsPanel, (String)"Completion", (int)2, (int)0, (int)5);
        completionGroup.setLayoutData((Object)new GridData(768));
        this.includeSourceTextInCommentCheck = UIUtils.createCheckbox((Composite)completionGroup, (String)"Include source in query comment", (String)"Add your human language text in query comment", (boolean)false, (int)2);
        this.executeQueryImmediatelyCheck = UIUtils.createCheckbox((Composite)completionGroup, (String)"Execute SQL immediately", (String)"Try to execute translated SQL immediately after completion", (boolean)false, (int)2);
        this.createCompletionSettings(completionGroup, propertyChangeListener);
        this.createFormattingSettings(settingsPanel, propertyChangeListener);
        Group modelGroup = UIUtils.createControlGroup((Composite)placeholder, (String)AIUIMessages.gpt_preference_page_group_model, (int)2, (int)0, (int)5);
        modelGroup.setLayoutData((Object)new GridData(768));
        this.modelCombo = UIUtils.createLabelCombo((Composite)modelGroup, (String)AIUIMessages.gpt_preference_page_combo_engine, (int)8);
        GPTModel[] gPTModelArray = GPTModel.values();
        int n = gPTModelArray.length;
        int n2 = 0;
        while (n2 < n) {
            GPTModel model = gPTModelArray[n2];
            this.modelCombo.add(model.getName());
            ++n2;
        }
        UIUtils.createInfoLabel((Composite)modelGroup, (String)"code-davinci model suits the best for SQL code completion", (int)768, (int)2);
        Group modelAdvancedGroup = UIUtils.createControlGroup((Composite)placeholder, (String)AIUIMessages.gpt_preference_page_group_model_advanced, (int)2, (int)0, (int)5);
        this.temperatureText = UIUtils.createLabelText((Composite)modelAdvancedGroup, (String)AIUIMessages.gpt_preference_page_text_temperature, (String)"0.0");
        this.temperatureText.addVerifyListener(UIUtils.getNumberVerifyListener((Locale)Locale.getDefault()));
        UIUtils.createInfoLabel((Composite)modelAdvancedGroup, (String)"Lower temperatures give more precise results", (int)768, (int)2);
        this.temperatureText.addVerifyListener(UIUtils.getNumberVerifyListener((Locale)Locale.getDefault()));
        modelAdvancedGroup.setLayoutData((Object)new GridData(768));
        this.logQueryCheck = UIUtils.createCheckbox((Composite)modelAdvancedGroup, (String)"Write GPT queries to debug log", (String)"Write GPT queries with metadata info in debug logs", (boolean)false, (int)2);
        this.createAdvancedSettings(modelAdvancedGroup, propertyChangeListener);
    }

    protected void createCompletionSettings(Group group, Runnable propertyChangeListener) {
    }

    protected void createFormattingSettings(Composite settingsPanel, Runnable propertyChangeListener) {
        UIUtils.createEmptyLabel((Composite)settingsPanel, (int)1, (int)1);
    }

    protected void createAdvancedSettings(Group group, Runnable propertyChangeListener) {
    }

    public void loadSettings(@NotNull AISettings aiSettings) {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        AISettings settings = AISettings.getSettings();
        AIEngineSettings openAiSettings = settings.getEngineConfiguration("openai");
        this.enableAICheck.setSelection(!settings.isAiDisabled());
        this.includeSourceTextInCommentCheck.setSelection(store.getBoolean("ai.completion.includeSourceTextInQuery"));
        this.executeQueryImmediatelyCheck.setSelection(store.getBoolean("ai.completion.executeImmediately"));
        this.modelCombo.select(GPTModel.getByName((String)store.getString("gpt.model")).ordinal());
        this.temperatureText.setText(String.valueOf(store.getDouble("gpt.model.temperature")));
        this.logQueryCheck.setSelection(store.getBoolean("gpt.log.query"));
        String secretValue = CommonUtils.toString(openAiSettings.getProperties().get("gpt.token"), null);
        if (secretValue == null) {
            secretValue = DBWorkbench.getPlatform().getPreferenceStore().getString("gpt.token");
        }
        this.tokenText.setText(secretValue == null ? "" : secretValue);
    }

    public void saveSettings(@NotNull AISettings settings) {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        settings.setAiDisabled(!this.enableAICheck.getSelection());
        AIEngineSettings engineConfiguration = settings.getEngineConfiguration("openai");
        engineConfiguration.setEngineEnabled(this.enableAICheck.getSelection());
        store.setValue("ai.completion.includeSourceTextInQuery", this.includeSourceTextInCommentCheck.getSelection());
        store.setValue("ai.completion.executeImmediately", this.executeQueryImmediatelyCheck.getSelection());
        store.setValue("gpt.model", this.modelCombo.getText());
        store.setValue("gpt.model.temperature", this.temperatureText.getText());
        store.setValue("gpt.log.query", this.logQueryCheck.getSelection());
        if (!this.modelCombo.getText().equals(store.getString("gpt.model")) || !this.tokenText.getText().equals(store.getString("gpt.token"))) {
            GPTCompletionEngine.resetServices();
        }
        store.setToDefault("gpt.token");
        engineConfiguration.getProperties().put("gpt.token", this.tokenText.getText());
    }

    public void resetSettings(@NotNull AISettings settings) {
    }

    public boolean isComplete() {
        return !CommonUtils.isEmpty((String)this.tokenText.getText());
    }
}

