/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.ai.popup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.ai.completion.DAICompletionScope;
import org.jkiss.dbeaver.model.ai.completion.DAICompletionSettings;
import org.jkiss.dbeaver.model.ai.translator.DAIHistoryItem;
import org.jkiss.dbeaver.model.ai.translator.DAIHistoryManager;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.logical.DBSLogicalDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.LoggingProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSStructContainer;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.AbstractPopupPanel;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.HelpUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class AISuggestionPopup
extends AbstractPopupPanel {
    private static final Log log = Log.getLog(AISuggestionPopup.class);
    @NotNull
    private final DAIHistoryManager historyManager;
    @NotNull
    private final DBSLogicalDataSource dataSource;
    @NotNull
    private final DBCExecutionContext executionContext;
    private final DAICompletionSettings settings;
    private Text inputField;
    private String inputText;
    private DAICompletionScope currentScope = DAICompletionScope.CURRENT_SCHEMA;
    private Text scopeText;
    private ToolItem scopeConfigItem;
    private final Set<String> checkedObjectIds = new LinkedHashSet<String>();

    public AISuggestionPopup(@NotNull Shell parentShell, @NotNull String title, @NotNull DAIHistoryManager historyManager, @NotNull DBSLogicalDataSource dataSource, @NotNull DBCExecutionContext executionContext, @NotNull DAICompletionSettings settings) {
        super(parentShell, title);
        this.historyManager = historyManager;
        this.dataSource = dataSource;
        this.executionContext = executionContext;
        this.settings = settings;
        this.setImage((DBPImage)DBIcon.AI);
        this.setModeless(true);
    }

    protected Composite createDialogArea(Composite parent) {
        Composite placeholder = super.createDialogArea(parent);
        Composite hintPanel = UIUtils.createComposite((Composite)placeholder, (int)2);
        hintPanel.setLayoutData((Object)new GridData(768));
        Link hintLabel = new Link(hintPanel, 0);
        hintLabel.setText("Enter a text in a human language, it will be translated into SQL (<a>instructions</a>)");
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        hintLabel.setLayoutData((Object)gd);
        hintLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UIUtils.openWebBrowser((String)HelpUtils.getHelpExternalReference((String)"AI-Smart-Assistance"));
            }
        });
        Composite scopePanel = UIUtils.createComposite((Composite)placeholder, (int)5);
        scopePanel.setLayoutData((Object)new GridData(768));
        UIUtils.createControlLabel((Composite)scopePanel, (String)"Scope");
        this.currentScope = this.settings.getScope();
        if (this.settings.getCustomObjectIds() != null) {
            this.checkedObjectIds.addAll(Arrays.asList(this.settings.getCustomObjectIds()));
        }
        final Combo scopeCombo = new Combo(scopePanel, 12);
        DAICompletionScope[] dAICompletionScopeArray = DAICompletionScope.values();
        int n = dAICompletionScopeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DAICompletionScope scope = dAICompletionScopeArray[n2];
            scopeCombo.add(scope.getTitle());
            if (this.currentScope == scope) {
                scopeCombo.select(scopeCombo.getItemCount() - 1);
            }
            ++n2;
        }
        scopeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AISuggestionPopup.this.currentScope = (DAICompletionScope)CommonUtils.fromOrdinal(DAICompletionScope.class, (int)scopeCombo.getSelectionIndex());
                AISuggestionPopup.this.showScopeSettings(AISuggestionPopup.this.currentScope);
                if (AISuggestionPopup.this.currentScope == DAICompletionScope.CUSTOM) {
                    AISuggestionPopup.this.showScopeConfiguration();
                }
            }
        });
        this.scopeText = new Text(scopePanel, 2056);
        this.scopeText.setEditable(false);
        this.scopeText.setLayoutData((Object)new GridData(768));
        ToolBar tb = new ToolBar(scopePanel, 0x800000);
        this.scopeConfigItem = UIUtils.createToolItem((ToolBar)tb, (String)"Customize", (DBPImage)UIIcon.RS_DETAILS, (SelectionListener)SelectionListener.widgetSelectedAdapter(selectionEvent -> this.showScopeConfiguration()));
        UIUtils.createToolItem((ToolBar)tb, (String)"Settings", (DBPImage)UIIcon.CONFIGURATION, (SelectionListener)SelectionListener.widgetSelectedAdapter(selectionEvent -> UIUtils.showPreferencesFor((Shell)this.getShell(), null, (String[])new String[]{"org.jkiss.dbeaver.preferences.ai"})));
        tb.setLayoutData((Object)new GridData(128));
        this.inputField = new Text(placeholder, 2050);
        gd = new GridData(1808);
        gd.heightHint = UIUtils.getFontHeight((Font)placeholder.getFont()) * 10;
        gd.widthHint = UIUtils.getFontHeight((Font)placeholder.getFont()) * 40;
        this.inputField.setLayoutData((Object)gd);
        this.inputField.setTextLimit(10000);
        this.inputField.addModifyListener(e -> {
            String string = this.inputText = this.inputField.getText();
        });
        this.inputField.addListener(1, event -> {
            if (event.keyCode == 13 && event.stateMask == 0) {
                event.doit = false;
                this.okPressed();
            }
        });
        Composite miscPanel = UIUtils.createComposite((Composite)placeholder, (int)2);
        miscPanel.setLayoutData((Object)new GridData(768));
        UIUtils.createControlLabel((Composite)miscPanel, (String)"History");
        final Combo historyCombo = new Combo(miscPanel, 12);
        historyCombo.setLayoutData((Object)new GridData(768));
        Button applyButton = UIUtils.createDialogButton((Composite)placeholder, (String)"Translate", (SelectionListener)SelectionListener.widgetSelectedAdapter(selectionEvent -> this.okPressed()));
        ((GridData)applyButton.getLayoutData()).grabExcessHorizontalSpace = false;
        ((GridData)applyButton.getLayoutData()).horizontalAlignment = 3;
        this.closeOnFocusLost(new Control[]{this.inputField, scopeCombo, this.scopeText, historyCombo, applyButton});
        historyCombo.setEnabled(false);
        AbstractJob completionJob = new AbstractJob("Read completion history"){

            protected IStatus run(DBRProgressMonitor monitor) {
                try {
                    List queries = AISuggestionPopup.this.historyManager.readTranslationHistory(monitor, AISuggestionPopup.this.dataSource, AISuggestionPopup.this.executionContext, 100);
                    UIUtils.syncExec(() -> {
                        if (!CommonUtils.isEmpty((Collection)queries)) {
                            for (DAIHistoryItem query : queries) {
                                historyCombo.add(query.getNaturalText());
                            }
                            historyCombo.select(0);
                            AISuggestionPopup.this.inputField.setText(((DAIHistoryItem)queries.get(0)).getNaturalText());
                            AISuggestionPopup.this.inputField.selectAll();
                            historyCombo.setEnabled(true);
                        } else {
                            historyCombo.setEnabled(false);
                        }
                    });
                }
                catch (DBException e) {
                    log.error((Object)"Error reading completion history", (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        completionJob.schedule();
        this.inputField.setFocus();
        historyCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String text = historyCombo.getText();
                if (!CommonUtils.isEmpty((String)text)) {
                    AISuggestionPopup.this.inputField.setText(text);
                }
            }
        });
        this.showScopeSettings(this.currentScope);
        return placeholder;
    }

    private void showScopeConfiguration() {
        ScopeConfigDialog dialog = new ScopeConfigDialog(this.checkedObjectIds);
        if (dialog.open() != 0) {
            return;
        }
        this.checkedObjectIds.clear();
        this.checkedObjectIds.addAll(dialog.checkedObjectIds);
        this.showScopeSettings(DAICompletionScope.CUSTOM);
    }

    private void showScopeSettings(DAICompletionScope scope) {
        String text;
        switch (scope) {
            case CURRENT_SCHEMA: {
                text = this.dataSource.getCurrentSchema();
                if (CommonUtils.isEmpty((String)text)) {
                    text = this.dataSource.getCurrentCatalog();
                }
                if (!CommonUtils.isEmpty((String)text)) break;
                text = this.dataSource.getDataSourceContainer().getName();
                break;
            }
            case CURRENT_DATABASE: {
                text = this.dataSource.getCurrentCatalog();
                if (!CommonUtils.isEmpty((String)text)) break;
                text = this.dataSource.getDataSourceContainer().getName();
                break;
            }
            case CURRENT_DATASOURCE: {
                text = this.dataSource.getDataSourceContainer().getName();
                break;
            }
            default: {
                text = this.checkedObjectIds.size() + " object(s)";
            }
        }
        this.scopeConfigItem.setEnabled(scope == DAICompletionScope.CUSTOM);
        this.scopeText.setText(CommonUtils.toString((Object)text, (String)"N/A"));
    }

    protected void createButtonsForButtonBar(Composite parent) {
    }

    protected boolean isModeless() {
        return true;
    }

    public String getInputText() {
        return this.inputText;
    }

    public DAICompletionScope getScope() {
        return this.currentScope;
    }

    public List<DBSEntity> getCustomEntities() {
        ArrayList<DBSEntity> entities = new ArrayList<DBSEntity>();
        try {
            DBPDataSource dataSource = this.executionContext.getDataSource();
            if (dataSource instanceof DBSObjectContainer) {
                this.loadCheckedEntitiesById((DBSObjectContainer)dataSource, entities);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return entities;
    }

    private void loadCheckedEntitiesById(DBSObjectContainer container, List<DBSEntity> entities) throws DBException {
        Collection children = container.getChildren((DBRProgressMonitor)new LoggingProgressMonitor(log));
        if (children != null) {
            for (DBSObject child : children) {
                if (child instanceof DBSEntity) {
                    if (!this.checkedObjectIds.contains(DBUtils.getObjectFullId((DBSObject)child))) continue;
                    entities.add((DBSEntity)child);
                    continue;
                }
                if (!(child instanceof DBSStructContainer)) continue;
                this.loadCheckedEntitiesById((DBSObjectContainer)child, entities);
            }
        }
    }

    protected void okPressed() {
        this.inputText = this.inputField.getText().trim();
        this.settings.setScope(this.currentScope);
        this.settings.setCustomObjectIds(this.checkedObjectIds.toArray(new String[0]));
        this.settings.saveSettings();
        super.okPressed();
    }

    private class ScopeConfigDialog
    extends BaseDialog {
        private Tree objectTree;
        private final Set<String> checkedObjectIds;

        public ScopeConfigDialog(Set<String> checkedIds) {
            super(AISuggestionPopup.this.getShell(), "Customize scope", (DBPImage)DBIcon.AI);
            this.checkedObjectIds = new LinkedHashSet<String>(checkedIds);
        }

        protected Composite createDialogArea(Composite parent) {
            Composite composite = super.createDialogArea(parent);
            this.objectTree = new Tree(composite, 32);
            GridData gd = new GridData(1808);
            gd.widthHint = 400;
            gd.heightHint = 300;
            this.objectTree.setLayoutData((Object)gd);
            this.objectTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (e.detail != 32) {
                        return;
                    }
                    TreeItem item = (TreeItem)e.item;
                    if (item.getData() instanceof DBSStructContainer) {
                        this.checkTreeItems(item.getItems(), item.getChecked());
                    }
                }

                private void checkTreeItems(TreeItem[] items, boolean check) {
                    TreeItem[] treeItemArray = items;
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object[] children;
                        TreeItem child = treeItemArray[n2];
                        child.setChecked(check);
                        if (!(child.getData() instanceof DBSEntity) && !ArrayUtils.isEmpty((Object[])(children = child.getItems()))) {
                            this.checkTreeItems((TreeItem[])children, check);
                        }
                        ++n2;
                    }
                }
            });
            this.loadObjects(this.objectTree, AISuggestionPopup.this.executionContext.getDataSource());
            return composite;
        }

        private void loadObjects(final Tree objectTree, final DBPDataSource ds) {
            new AbstractJob("Load database structure"){

                protected IStatus run(DBRProgressMonitor monitor) {
                    if (ds instanceof DBSObjectContainer) {
                        try {
                            ScopeConfigDialog.this.loadContainer(monitor, objectTree, null, (DBSObjectContainer)ds, ScopeConfigDialog.this.checkedObjectIds);
                        }
                        catch (Exception e) {
                            return GeneralUtils.makeExceptionStatus((Throwable)e);
                        }
                        UIUtils.syncExec(() -> {
                            TreeItem[] treeItemArray = objectTree.getItems();
                            int n = treeItemArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                TreeItem item = treeItemArray[n2];
                                item.setExpanded(true);
                                ++n2;
                            }
                        });
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }

        private void loadContainer(DBRProgressMonitor monitor, Tree objectTree, TreeItem parentItem, DBSObjectContainer objectContainer, Set<String> checkedObjectIds) throws DBException {
            Collection children;
            try {
                children = objectContainer.getChildren(monitor);
            }
            catch (Exception e) {
                log.debug((Object)("Error loading container '" + objectContainer.getName() + "' contents: " + e.getMessage()));
                return;
            }
            if (children == null) {
                return;
            }
            LinkedHashMap addedContainers = new LinkedHashMap();
            UIUtils.syncExec(() -> {
                for (DBSObject child : children) {
                    DBNDatabaseNode node;
                    if (monitor.isCanceled()) {
                        return;
                    }
                    if (!(child instanceof DBSStructContainer) && !(child instanceof DBSEntity) || (node = DBNUtils.getNodeByObject((DBRProgressMonitor)monitor, (DBSObject)child, (boolean)false)) == null) continue;
                    TreeItem item = parentItem == null ? new TreeItem(objectTree, 0) : new TreeItem(parentItem, 0);
                    item.setData((Object)child);
                    item.setImage(DBeaverIcons.getImage((DBPImage)node.getNodeIconDefault()));
                    item.setText(node.getNodeName());
                    String objectId = DBUtils.getObjectFullId((DBSObject)child);
                    if (checkedObjectIds.contains(objectId)) {
                        item.setChecked(true);
                        if (parentItem != null && !parentItem.getExpanded()) {
                            parentItem.setExpanded(true);
                        }
                    }
                    if (!(child instanceof DBSObjectContainer)) continue;
                    addedContainers.put(item, (DBSObjectContainer)child);
                }
            });
            if (monitor.isCanceled()) {
                return;
            }
            for (Map.Entry contItem : addedContainers.entrySet()) {
                DBSObjectContainer object = (DBSObjectContainer)contItem.getValue();
                this.loadContainer(monitor, objectTree, (TreeItem)contItem.getKey(), object, checkedObjectIds);
            }
        }

        protected void okPressed() {
            this.checkedObjectIds.clear();
            this.collectCheckedObjects(this.objectTree.getItems());
            super.okPressed();
        }

        private void collectCheckedObjects(TreeItem[] items) {
            TreeItem[] treeItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                Object[] children;
                TreeItem item = treeItemArray[n2];
                if (item.getChecked() && item.getData() instanceof DBSEntity) {
                    this.checkedObjectIds.add(DBUtils.getObjectFullId((DBSObject)((DBSEntity)item.getData())));
                }
                if (!ArrayUtils.isEmpty((Object[])(children = item.getItems()))) {
                    this.collectCheckedObjects((TreeItem[])children);
                }
                ++n2;
            }
        }
    }
}

