/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.ai.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.ai.AIEngineRegistry;
import org.jkiss.dbeaver.model.ai.completion.DAICompletionEngine;
import org.jkiss.dbeaver.model.ai.completion.DAICompletionRequest;
import org.jkiss.dbeaver.model.ai.completion.DAICompletionResponse;
import org.jkiss.dbeaver.model.ai.completion.DAICompletionSettings;
import org.jkiss.dbeaver.model.ai.translator.DAIHistoryManager;
import org.jkiss.dbeaver.model.ai.translator.SimpleFilterManager;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.logical.DBSLogicalDataSource;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.editors.sql.ai.popup.AISuggestionPopup;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class AITranslateHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        AISuggestionPopup aiCompletionPopup;
        DAIHistoryManager historyManager;
        DAICompletionEngine engine;
        if (DBWorkbench.getPlatform().getPreferenceStore().getBoolean("ai.completion.disabled")) {
            return null;
        }
        SQLEditor editor = (SQLEditor)RuntimeUtils.getObjectAdapter((Object)HandlerUtil.getActiveEditor((ExecutionEvent)event), SQLEditor.class);
        DBPDataSourceContainer dataSourceContainer = editor.getDataSourceContainer();
        if (dataSourceContainer == null) {
            DBWorkbench.getPlatformUI().showError("No datasource", "Connection must be associated with the SQL script");
            return null;
        }
        try {
            engine = AIEngineRegistry.getInstance().getCompletionEngine("openai");
        }
        catch (Exception e) {
            DBWorkbench.getPlatformUI().showError("AI error", "Cannot determine AI engine", (Throwable)e);
            return null;
        }
        if (!engine.isValidConfiguration()) {
            UIUtils.showPreferencesFor((Shell)editor.getSite().getShell(), null, (String[])new String[]{"org.jkiss.dbeaver.preferences.ai"});
        }
        if (!engine.isValidConfiguration()) {
            DBWorkbench.getPlatformUI().showError("Bad AI engine configuration", "You must specify OpenAI API token in preferences");
            return null;
        }
        DBCExecutionContext executionContext = editor.getExecutionContext();
        if (executionContext == null) {
            DBWorkbench.getPlatformUI().showError("No connection", "You must connect to the database before performing completion");
            return null;
        }
        DAICompletionSettings settings = new DAICompletionSettings(dataSourceContainer);
        if (!settings.isMetaTransferConfirmed()) {
            if (UIUtils.confirmAction((Shell)editor.getSite().getShell(), (String)"Transfer information to OpenAI", (String)("In order to perform AI smart completion DBeaver needs to transfer\nyour database metadata information (table and column names) to OpenAI API.\nDo you confirm it for connection '" + dataSourceContainer.getName() + "'?"), (DBPImage)DBIcon.AI)) {
                settings.setMetaTransferConfirmed(true);
                settings.saveSettings();
            } else {
                return null;
            }
        }
        if ((historyManager = (DAIHistoryManager)GeneralUtils.adapt(AISuggestionPopup.class, DAIHistoryManager.class)) == null) {
            historyManager = new SimpleFilterManager();
        }
        DBSLogicalDataSource lDataSource = new DBSLogicalDataSource(dataSourceContainer, "AI logical wrapper", null);
        DBCExecutionContextDefaults contextDefaults = executionContext.getContextDefaults();
        if (contextDefaults != null) {
            if (contextDefaults.getDefaultCatalog() != null) {
                lDataSource.setCurrentCatalog(contextDefaults.getDefaultCatalog().getName());
            }
            if (contextDefaults.getDefaultSchema() != null) {
                lDataSource.setCurrentSchema(contextDefaults.getDefaultSchema().getName());
            }
        }
        if ((aiCompletionPopup = new AISuggestionPopup(HandlerUtil.getActiveShell((ExecutionEvent)event), "ChatGPT smart completion", historyManager, lDataSource, executionContext, settings)).open() == 0) {
            DAICompletionRequest completionRequest = new DAICompletionRequest();
            completionRequest.setPromptText(aiCompletionPopup.getInputText());
            completionRequest.setScope(aiCompletionPopup.getScope());
            completionRequest.setCustomEntities(aiCompletionPopup.getCustomEntities());
            this.doAutoCompletion(executionContext, historyManager, lDataSource, editor, engine, completionRequest);
        }
        return null;
    }

    private void doAutoCompletion(final DBCExecutionContext executionContext, final DAIHistoryManager historyManager, final DBSLogicalDataSource lDataSource, SQLEditor editor, DAICompletionEngine engine, final DAICompletionRequest request) {
        if (CommonUtils.isEmptyTrimmed((String)request.getPromptText())) {
            return;
        }
        ArrayList completionResult = new ArrayList();
        try {
            UIUtils.runInProgressDialog(monitor -> {
                try {
                    completionResult.addAll(engine.performQueryCompletion(monitor, lDataSource, executionContext, request, true, 100));
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError("Auto completion error", null, e.getTargetException());
            return;
        }
        if (completionResult.isEmpty()) {
            DBWorkbench.getPlatformUI().showError("AI error", "No smart completions returned");
            return;
        }
        DAICompletionResponse response = (DAICompletionResponse)completionResult.get(0);
        final String completion = response.getResultCompletion();
        if (CommonUtils.isEmptyTrimmed((String)completion)) {
            return;
        }
        new AbstractJob("Save smart completion history"){

            protected IStatus run(DBRProgressMonitor monitor) {
                try {
                    historyManager.saveTranslationHistory(monitor, lDataSource, executionContext, request.getPromptText(), completion);
                }
                catch (DBException e) {
                    return GeneralUtils.makeExceptionStatus((Throwable)e);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
        ISelection selection = editor.getSelectionProvider().getSelection();
        IDocument document = editor.getDocument();
        if (document != null && selection instanceof TextSelection) {
            try {
                int offset = ((TextSelection)selection).getOffset();
                int length = ((TextSelection)selection).getLength();
                SQLScriptElement query = editor.extractQueryAtPos(offset);
                if (query != null) {
                    offset = query.getOffset();
                    length = query.getLength();
                }
                document.replace(offset, length, completion);
                editor.getSelectionProvider().setSelection((ISelection)new TextSelection(offset + completion.length(), 0));
            }
            catch (BadLocationException e) {
                DBWorkbench.getPlatformUI().showError("Insert SQL", "Error inserting SQL completion in text editor", (Throwable)e);
            }
        }
        if (DBWorkbench.getPlatform().getPreferenceStore().getBoolean("ai.completion.executeImmediately")) {
            editor.processSQL(false, false);
        }
    }
}

