/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.scheduler;

import java.util.concurrent.TimeUnit;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

final class SchedulerState<T> {
    @Nullable
    final T initialResource;
    final T currentResource;
    final Mono<Void> onDispose;

    private SchedulerState(@Nullable T initialResource, T currentResource, Mono<Void> onDispose) {
        this.initialResource = initialResource;
        this.currentResource = currentResource;
        this.onDispose = onDispose;
    }

    static <T> SchedulerState<T> init(T resource) {
        return new SchedulerState<T>(resource, resource, Mono.empty());
    }

    static <T> SchedulerState<T> transition(@Nullable T initial, T next, DisposeAwaiter<T> awaiter) {
        return new SchedulerState<T>(initial, next, initial == null ? Mono.empty() : Flux.create(sink -> {
            Thread backgroundThread = new Thread(() -> {
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        if (!awaiter.await(initial, 1L, TimeUnit.SECONDS)) continue;
                        sink.complete();
                        return;
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            });
            sink.onCancel(backgroundThread::interrupt);
            backgroundThread.start();
        }).replay().refCount().next());
    }

    static interface DisposeAwaiter<T> {
        public boolean await(T var1, long var2, TimeUnit var4) throws InterruptedException;
    }
}

