/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.teradata.snapshot;

import java.util.List;
import liquibase.CatalogAndSchema;
import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.Database;
import liquibase.diff.compare.DatabaseObjectComparatorFactory;
import liquibase.exception.DatabaseException;
import liquibase.ext.teradata.database.TeradataDatabase;
import liquibase.snapshot.CachedRow;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.JdbcDatabaseSnapshot;
import liquibase.snapshot.SnapshotGenerator;
import liquibase.snapshot.jvm.ForeignKeySnapshotGenerator;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Catalog;
import liquibase.structure.core.Column;
import liquibase.structure.core.ForeignKey;
import liquibase.structure.core.ForeignKeyConstraintType;
import liquibase.structure.core.Index;
import liquibase.structure.core.Relation;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;

public class TeradataForeignKeySnapshotGenerator
extends ForeignKeySnapshotGenerator {
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        return database instanceof TeradataDatabase ? 5 : -1;
    }

    public Class<? extends SnapshotGenerator>[] replaces() {
        return new Class[]{ForeignKeySnapshotGenerator.class};
    }

    protected DatabaseObject snapshotObject(DatabaseObject example, DatabaseSnapshot snapshot) throws DatabaseException {
        Database database = snapshot.getDatabase();
        try {
            Table fkTable = ((ForeignKey)example).getForeignKeyTable();
            String searchCatalog = ((AbstractJdbcDatabase)database).getJdbcCatalogName(fkTable.getSchema());
            String searchSchema = ((AbstractJdbcDatabase)database).getJdbcSchemaName(fkTable.getSchema());
            String searchTableName = database.correctObjectName(fkTable.getName(), Table.class);
            List importedKeyMetadataResultSet = ((JdbcDatabaseSnapshot)snapshot).getMetaDataFromCache().getForeignKeys(searchCatalog, searchSchema, searchTableName, example.getName());
            ForeignKey foreignKey = null;
            for (CachedRow row : importedKeyMetadataResultSet) {
                String fk_name = this.cleanNameFromDatabase(row.getString("FK_NAME"), database);
                if (snapshot.getDatabase().isCaseSensitive() && (!fk_name.equals(example.getName()) || !fk_name.equalsIgnoreCase(example.getName()))) continue;
                if (foreignKey == null) {
                    foreignKey = new ForeignKey();
                }
                foreignKey.setName(fk_name);
                String fkTableCatalog = this.cleanNameFromDatabase(row.getString("FKTABLE_CAT"), database);
                String fkTableSchema = this.cleanNameFromDatabase(row.getString("FKTABLE_SCHEM"), database);
                String fkTableName = this.cleanNameFromDatabase(row.getString("FKTABLE_NAME"), database);
                Table foreignKeyTable = new Table().setName(fkTableName);
                foreignKeyTable.setSchema(new Schema(new Catalog(fkTableCatalog), fkTableSchema));
                foreignKey.setForeignKeyTable(foreignKeyTable);
                Column fkColumn = new Column(this.cleanNameFromDatabase(row.getString("FKCOLUMN_NAME"), database)).setRelation((Relation)foreignKeyTable);
                boolean alreadyAdded = false;
                for (Column existing : foreignKey.getForeignKeyColumns()) {
                    if (!DatabaseObjectComparatorFactory.getInstance().isSameObject((DatabaseObject)existing, (DatabaseObject)fkColumn, snapshot.getSchemaComparisons(), database)) continue;
                    alreadyAdded = true;
                    break;
                }
                if (alreadyAdded) break;
                CatalogAndSchema pkTableSchema = ((AbstractJdbcDatabase)database).getSchemaFromJdbcInfo(row.getString("PKTABLE_CAT"), row.getString("PKTABLE_SCHEM"));
                Table tempPkTable = (Table)new Table().setName(row.getString("PKTABLE_NAME")).setSchema(new Schema(pkTableSchema.getCatalogName(), pkTableSchema.getSchemaName()));
                foreignKey.setPrimaryKeyTable(tempPkTable);
                Column pkColumn = new Column(this.cleanNameFromDatabase(row.getString("PKCOLUMN_NAME"), database)).setRelation((Relation)tempPkTable);
                foreignKey.addForeignKeyColumn(fkColumn);
                foreignKey.addPrimaryKeyColumn(pkColumn);
                ForeignKeyConstraintType updateRule = this.convertToForeignKeyConstraintType(row.getInt("UPDATE_RULE"), database);
                foreignKey.setUpdateRule(updateRule);
                ForeignKeyConstraintType deleteRule = this.convertToForeignKeyConstraintType(row.getInt("DELETE_RULE"), database);
                foreignKey.setDeleteRule(deleteRule);
                foreignKey.setDeferrable(false);
                foreignKey.setInitiallyDeferred(false);
                Index exampleIndex = new Index().setRelation((Relation)foreignKey.getForeignKeyTable());
                exampleIndex.getColumns().addAll(foreignKey.getForeignKeyColumns());
                exampleIndex.addAssociatedWith("foreignKey");
                foreignKey.setBackingIndex(exampleIndex);
            }
            if (snapshot.get(ForeignKey.class).contains(foreignKey)) {
                return null;
            }
            return foreignKey;
        }
        catch (Exception e) {
            throw new DatabaseException((Throwable)e);
        }
    }
}

