/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.compare.ui.tools;

import com.dbeaver.data.compare.model.tasks.DCCompareTaskSettings;
import com.dbeaver.data.compare.ui.internal.DCMessages;
import com.dbeaver.data.compare.ui.tools.DCCompareTaskWizard;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseItem;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseObjectsSelectorPanel;
import org.jkiss.dbeaver.utils.HelpUtils;

public class DCCompareTaskWizardPageObjects
extends ActiveWizardPage<DCCompareTaskWizard> {
    private static final Log log = Log.getLog(DCCompareTaskWizardPageObjects.class);
    private DataSourceSelectorPanel leftSourcePanel;
    private DataSourceSelectorPanel rightSourcePanel;

    protected DCCompareTaskWizardPageObjects() {
        super(DCMessages.data_compare_wizard_name);
        this.setTitle(DCMessages.data_compare_wizard_objects_title);
        this.setDescription(DCMessages.data_compare_wizard_objects_description);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = UIUtils.createComposite((Composite)parent, (int)2);
        this.leftSourcePanel = new DataSourceSelectorPanel(composite, DCMessages.data_compare_wizard_objects_first_container_title);
        this.rightSourcePanel = new DataSourceSelectorPanel(composite, DCMessages.data_compare_wizard_objects_second_container_title);
        this.setControl((Control)composite);
    }

    protected boolean determinePageCompletion() {
        DBSDataContainer leftContainer = this.leftSourcePanel.getContainer();
        DBSDataContainer rightContainer = this.rightSourcePanel.getContainer();
        if (leftContainer == null || rightContainer == null) {
            this.setErrorMessage(DCMessages.data_compare_wizard_objects_error_no_sources_selected);
            return false;
        }
        if (leftContainer == rightContainer) {
            this.setErrorMessage(DCMessages.data_compare_wizard_objects_error_same_sources);
            return false;
        }
        return true;
    }

    public void activatePage() {
        DCCompareTaskSettings settings = ((DCCompareTaskWizard)this.getWizard()).getSettings();
        if (this.leftSourcePanel.getContainer() == null || this.rightSourcePanel.getContainer() == null) {
            UIUtils.asyncExec(() -> {
                this.leftSourcePanel.setContainer(settings.getLeftContainer(), true);
                this.rightSourcePanel.setContainer(settings.getRightContainer(), true);
            });
        }
    }

    public void performHelp() {
        ShellUtils.launchProgram((String)HelpUtils.getHelpExternalReference((String)"Data-compare"));
    }

    private void saveContainer(DBSDataContainer container) {
        DCCompareTaskSettings settings = ((DCCompareTaskWizard)this.getWizard()).getSettings();
        if (container == this.leftSourcePanel.getContainer()) {
            settings.setLeftContainer(container);
        } else {
            settings.setRightContainer(container);
        }
    }

    private class DataSourceSelectorPanel
    extends Composite {
        private final DatabaseObjectsSelectorPanel panel;
        private DBSDataContainer container;

        public DataSourceSelectorPanel(@NotNull Composite parent, String title) {
            super(parent, 0);
            if (parent.getLayout() instanceof GridLayout) {
                this.setLayoutData(new GridData(1808));
            }
            GridLayout gl = new GridLayout(1, true);
            gl.marginHeight = 0;
            gl.marginWidth = 0;
            this.setLayout((Layout)gl);
            Group group = UIUtils.createControlGroup((Composite)this, (String)title, (int)1, (int)1808, (int)-1);
            this.panel = new DatabaseObjectsSelectorPanel((Composite)group, false, ((DCCompareTaskWizard)DCCompareTaskWizardPageObjects.this.getWizard()).getRunnableContext());
            this.panel.addSelectionListener(event -> {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object object = selection.isEmpty() ? null : selection.getFirstElement();
                this.setContainerFromSelection(object);
                DCCompareTaskWizardPageObjects.this.updatePageCompletion();
            });
            GridData gd = new GridData(1808);
            gd.widthHint = 300;
            gd.heightHint = 250;
            this.panel.setLayoutData((Object)gd);
        }

        public DBSDataContainer getContainer() {
            return this.container;
        }

        public void setContainer(DBSDataContainer container, boolean highlight) {
            this.container = container;
            if (container != null) {
                if (highlight) {
                    ArrayList selection = new ArrayList(1);
                    try {
                        ((DCCompareTaskWizard)DCCompareTaskWizardPageObjects.this.getWizard()).getRunnableContext().run(true, true, monitor -> {
                            DBNDatabaseNode node = DBNUtils.getNodeByObject((DBRProgressMonitor)monitor, (DBSObject)container, (boolean)false);
                            if (node != null) {
                                selection.add(node);
                            } else {
                                log.warn((Object)("Cannot find node for container '" + DBUtils.getObjectFullName((DBPNamedObject)container, (DBPEvaluationContext)DBPEvaluationContext.UI) + "'"));
                            }
                        });
                    }
                    catch (InvocationTargetException e) {
                        DBWorkbench.getPlatformUI().showError("Data Compare", "Error updating settings", e.getTargetException());
                    }
                    catch (InterruptedException e) {
                        log.debug((Object)"Canceled by user", (Throwable)e);
                    }
                    this.panel.refreshNodes();
                    this.panel.checkNodes(selection, true);
                    this.panel.setSelection(selection);
                }
                DCCompareTaskWizardPageObjects.this.saveContainer(container);
            }
            DCCompareTaskWizardPageObjects.this.updatePageCompletion();
        }

        private void setContainerFromSelection(Object selection) {
            DBSObject dbsObject;
            this.setContainer(null, false);
            if (selection instanceof DBNDatabaseItem && (dbsObject = ((DBNDatabaseItem)selection).getObject()) instanceof DBSDataContainer) {
                this.setContainer((DBSDataContainer)dbsObject, false);
            }
        }
    }
}

