/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.compare.ui.tools;

import com.dbeaver.data.compare.model.DCInput;
import com.dbeaver.data.compare.model.DCSummary;
import com.dbeaver.data.compare.model.tasks.DCCompareTaskSettings;
import com.dbeaver.data.compare.ui.editor.DCCompareEditorInput;
import com.dbeaver.data.compare.ui.internal.DCMessages;
import com.dbeaver.data.compare.ui.tools.DCCompareTaskWizardPageConstraints;
import com.dbeaver.data.compare.ui.tools.DCCompareTaskWizardPageLog;
import com.dbeaver.data.compare.ui.tools.DCCompareTaskWizardPageMappings;
import com.dbeaver.data.compare.ui.tools.DCCompareTaskWizardPageObjects;
import com.dbeaver.data.compare.ui.tools.DCCompareTaskWizardPageSettings;
import java.util.Map;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbench;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskConfigurationWizard;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskConfigurationWizardDialog;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskWizardExecutor;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIUtils;

public class DCCompareTaskWizard
extends TaskConfigurationWizard<DCCompareTaskSettings> {
    private static final Log log = Log.getLog(DCCompareTaskWizard.class);
    private final DCCompareTaskSettings settings = new DCCompareTaskSettings();
    private DCCompareTaskWizardPageObjects objectsPage;
    private DCCompareTaskWizardPageConstraints constraintsPage;
    private DCCompareTaskWizardPageMappings mappingsPage;
    private DCCompareTaskWizardPageSettings settingsPage;
    private DCCompareTaskWizardPageLog logPage;

    public DCCompareTaskWizard(DBTTask task) {
        super(task);
        this.setHelpAvailable(true);
        this.setNeedsProgressMonitor(true);
        this.settings.loadConfiguration(UIUtils.getDefaultRunnableContext(), task.getProperties());
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        super.init(workbench, currentSelection);
        this.objectsPage = new DCCompareTaskWizardPageObjects();
        this.constraintsPage = new DCCompareTaskWizardPageConstraints();
        this.mappingsPage = new DCCompareTaskWizardPageMappings();
        this.settingsPage = new DCCompareTaskWizardPageSettings();
        this.logPage = new DCCompareTaskWizardPageLog();
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)this.objectsPage);
        this.addPage((IWizardPage)this.constraintsPage);
        this.addPage((IWizardPage)this.mappingsPage);
        this.addPage((IWizardPage)this.settingsPage);
        this.addPage((IWizardPage)this.logPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.settingsPage) {
            return null;
        }
        return super.getNextPage(page);
    }

    public boolean performFinish() {
        TaskConfigurationWizardDialog container = this.getContainer();
        if (container.getCurrentPage() != this.logPage) {
            container.showPage((IWizardPage)this.logPage);
        }
        this.logPage.clear();
        final DCCompareTaskSettings dcCompareTaskSettings = this.getSettings();
        try {
            DBTTask task = this.getProject().getTaskManager().createTemporaryTask(this.getTaskType(), this.getWindowTitle());
            this.saveConfigurationToTask(task);
            container.disableButtonsOnProgress();
            TaskWizardExecutor executor = new TaskWizardExecutor(this.getRunnableContext(), task, log, this.logPage.getWriter()){

                public void taskFinished(@Nullable DBTTask task, @Nullable Object result, @Nullable Throwable error, @Nullable Object settings) {
                    super.taskFinished(task, result, error, settings);
                    if (result instanceof DCSummary) {
                        DCCompareEditorInput input = new DCCompareEditorInput(new DCInput(dcCompareTaskSettings.getLeftContainer(), dcCompareTaskSettings.getLeftKeys()), new DCInput(dcCompareTaskSettings.getRightContainer(), dcCompareTaskSettings.getRightKeys()), (DCSummary)result);
                        if (dcCompareTaskSettings.isOpenViewerOnFinish()) {
                            UIUtils.syncExec(() -> CompareUI.openCompareEditor((CompareEditorInput)input));
                        }
                        if (dcCompareTaskSettings.getOutputFilePath() != null) {
                            ShellUtils.showInSystemExplorer((String)dcCompareTaskSettings.getOutputFilePath());
                        }
                    }
                }
            };
            executor.executeTask();
            container.enableButtonsAfterProgress();
            container.setCompleteMarkAfterProgress();
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Data Compare", "Error executing task", (Throwable)e);
        }
        return false;
    }

    protected DCCompareTaskSettings getSettings() {
        return this.settings;
    }

    protected String getDefaultWindowTitle() {
        return DCMessages.data_compare_wizard_name;
    }

    public String getTaskTypeId() {
        return "dataCompare";
    }

    public void saveTaskState(DBRRunnableContext runnableContext, DBTTask task, Map<String, Object> state) {
        this.settings.saveConfiguration(state);
    }
}

