/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.compare.ui.editor;

import com.dbeaver.data.compare.model.DCInput;
import com.dbeaver.data.compare.model.DCRowDiff;
import com.dbeaver.data.compare.model.DCSettings;
import com.dbeaver.data.compare.ui.editor.DCCompareViewer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraint;
import org.jkiss.dbeaver.model.data.DBDAttributeDecorator;
import org.jkiss.dbeaver.model.data.DBDAttributeValue;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetContainer;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetDecorator;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetListener;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetSelection;
import org.jkiss.dbeaver.ui.controls.resultset.QueryResultsDecorator;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetModel;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.controls.resultset.spreadsheet.Spreadsheet;
import org.jkiss.dbeaver.ui.controls.resultset.spreadsheet.SpreadsheetPresentation;

public class DCCompareViewerPane
extends Composite
implements IResultSetContainer,
IResultSetListener {
    private final DCCompareViewer compareViewer;
    private final ResultSetViewer resultSetViewer;
    private final List<DCRowDiff> diffs = new ArrayList<DCRowDiff>();
    private boolean left;
    private DCSettings settings;
    private DCInput input;

    public DCCompareViewerPane(@NotNull Composite parent, @NotNull DCCompareViewer viewer, boolean left) {
        super(parent, 0);
        this.setLayout((Layout)new FillLayout());
        this.compareViewer = viewer;
        this.resultSetViewer = new ResultSetViewer((Composite)this, viewer.getCompareConfiguration().getContainer().getWorkbenchPart().getSite(), (IResultSetContainer)this);
        this.resultSetViewer.addListener((IResultSetListener)this);
        this.left = left;
    }

    public void refresh() {
        this.resultSetViewer.resetHistory();
        this.resultSetViewer.refresh();
        this.diffs.clear();
    }

    @Nullable
    public DBCExecutionContext getExecutionContext() {
        return this.input == null ? null : DBUtils.getDefaultContext((DBSObject)this.input.getContainer(), (boolean)false);
    }

    @Nullable
    public DBPProject getProject() {
        return this.input == null ? null : this.input.getContainer().getDataSource().getContainer().getProject();
    }

    @NotNull
    public IResultSetController getResultSetController() {
        return this.resultSetViewer;
    }

    @Nullable
    public DBSDataContainer getDataContainer() {
        return this.input == null ? null : new FilteredDataContainer(this.input.getContainer());
    }

    public boolean isReadyToRun() {
        return true;
    }

    public void openNewContainer(DBRProgressMonitor monitor, @NotNull DBSDataContainer dataContainer, @NotNull DBDDataFilter newFilter) {
        DBWorkbench.getPlatformUI().showError("Data container", "Not supported");
    }

    public IResultSetDecorator createResultSetDecorator() {
        return new ResultSetDecorator();
    }

    public void dispose() {
        this.resultSetViewer.removeListener((IResultSetListener)this);
        super.dispose();
    }

    public void handleResultSetLoad() {
        if (this.diffs.isEmpty()) {
            for (DCRowDiff diff : this.compareViewer.getSummary()) {
                if (!diff.getState().isRelated(this.left)) continue;
                this.diffs.add(diff);
            }
        }
        ResultSetModel model = this.resultSetViewer.getModel();
        DBSAttributeBase[] keys = this.input.getKeys();
        Collection mappings = this.settings.getMappings(this.left);
        DBDAttributeBinding[] dBDAttributeBindingArray = model.getAttributes();
        int n = dBDAttributeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBDAttributeBinding binding = dBDAttributeBindingArray[n2];
            boolean isKey = Arrays.stream(keys).anyMatch(attr -> binding.matches(attr, true));
            boolean isMapped = mappings.stream().anyMatch(attr -> binding.matches(attr, true));
            model.setAttributeVisibility(binding, isKey || isMapped);
            ++n2;
        }
        this.compareViewer.signalDataLoad(this);
    }

    public void handleResultSetChange() {
    }

    public void handleResultSetSelectionChange(SelectionChangedEvent event) {
        List rows = ((IResultSetSelection)event.getSelection()).getSelectedRows();
        if (rows.isEmpty()) {
            return;
        }
        ResultSetRow selectedRow = (ResultSetRow)rows.get(0);
        if (this.diffs.size() <= selectedRow.getVisualNumber()) {
            return;
        }
        DCCompareViewerPane oppositePane = this.compareViewer.getOppositePane(this);
        int index = oppositePane.diffs.indexOf(this.diffs.get(selectedRow.getVisualNumber()));
        if (index >= 0) {
            Spreadsheet spreadsheet = this.getSpreadsheet();
            Spreadsheet oppositeSpreadsheet = oppositePane.getSpreadsheet();
            if (spreadsheet != null && oppositeSpreadsheet != null) {
                int topIndex = spreadsheet.getTopIndex();
                int topOffset = selectedRow.getVisualNumber() - topIndex;
                oppositeSpreadsheet.setSelection(index);
                oppositeSpreadsheet.showItem(index, topOffset);
                this.compareViewer.redrawRuler();
            }
        }
    }

    @NotNull
    public ResultSetViewer getResultSetViewer() {
        return this.resultSetViewer;
    }

    @Nullable
    public SpreadsheetPresentation getPresentation() {
        IResultSetPresentation presentation = this.resultSetViewer.getActivePresentation();
        return presentation instanceof SpreadsheetPresentation ? (SpreadsheetPresentation)presentation : null;
    }

    @Nullable
    public Spreadsheet getSpreadsheet() {
        SpreadsheetPresentation presentation = this.getPresentation();
        return presentation != null ? presentation.getSpreadsheet() : null;
    }

    @Nullable
    public ResultSetRow getResultSetRow(@NotNull DCRowDiff diff) {
        int index = this.diffs.indexOf(diff);
        if (index < 0) {
            return null;
        }
        ResultSetModel model = this.resultSetViewer.getModel();
        if (model.getRowCount() <= index) {
            return null;
        }
        return model.getRow(index);
    }

    public void setInput(@NotNull DCSettings settings, @NotNull DCInput input, boolean left) {
        this.settings = settings;
        this.input = input;
        this.left = left;
    }

    @NotNull
    private DBDDataFilter createFilter(long rowOffset, long rowCount) {
        DBSAttributeBase[] attributes = this.input.getKeys();
        List values = IntStream.range(0, attributes.length).mapToObj(ArrayList::new).collect(Collectors.toList());
        if (rowOffset < 0L) {
            rowOffset = 0L;
        }
        if (rowCount < 0L) {
            rowCount = Long.MAX_VALUE;
        }
        Iterator iterator = this.compareViewer.getSummary().iterator();
        while (iterator.hasNext() && rowOffset > 0L) {
            iterator.next();
            --rowOffset;
        }
        while (iterator.hasNext() && rowCount > 0L) {
            DCRowDiff diff = (DCRowDiff)iterator.next();
            if (!diff.getState().isRelated(this.left)) continue;
            DBDAttributeValue[] keys = diff.getKeys();
            int index = 0;
            while (index < attributes.length) {
                ((List)values.get(index)).add(keys[index].getValue());
                ++index;
            }
            --rowCount;
        }
        ArrayList<DBDAttributeConstraint> constraints = new ArrayList<DBDAttributeConstraint>();
        int index = 0;
        while (index < attributes.length) {
            int position = constraints.size() + 1;
            DBDAttributeConstraint constraint = new DBDAttributeConstraint(attributes[index], position);
            constraint.setOrderPosition(position);
            constraint.setOperator(DBCLogicalOperator.IN);
            constraint.setValue((Object)((List)values.get(index)).toArray());
            constraints.add(constraint);
            ++index;
        }
        return new DBDDataFilter(constraints);
    }

    private class FilteredDataContainer
    implements DBSDataContainer {
        private final DBSDataContainer delegate;

        public FilteredDataContainer(DBSDataContainer delegate) {
            this.delegate = delegate;
        }

        @NotNull
        public DBCStatistics readData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, @NotNull DBDDataReceiver dataReceiver, @Nullable DBDDataFilter dataFilter, long firstRow, long maxRows, long flags, int fetchSize) throws DBCException {
            DBDDataFilter filter = DCCompareViewerPane.this.createFilter(firstRow, maxRows);
            return this.delegate.readData(source, session, dataReceiver, filter, firstRow, maxRows, flags, fetchSize);
        }

        public long countData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, @Nullable DBDDataFilter dataFilter, long flags) {
            return -1L;
        }

        @NotNull
        public String getName() {
            return this.delegate.getName();
        }

        @Nullable
        public String getDescription() {
            return this.delegate.getDescription();
        }

        public boolean isPersisted() {
            return this.delegate.isPersisted();
        }

        @Nullable
        public DBSObject getParentObject() {
            return this.delegate;
        }

        @Nullable
        public DBPDataSource getDataSource() {
            return this.delegate.getDataSource();
        }

        public String[] getSupportedFeatures() {
            return new String[]{"data.select"};
        }
    }

    private class ResultSetDecorator
    extends QueryResultsDecorator
    implements DBDAttributeDecorator {
        private ResultSetDecorator() {
        }

        public long getDecoratorFeatures() {
            return 2L;
        }

        public String getPreferredPresentation() {
            return "spreadsheet";
        }

        @Nullable
        public DBDAttributeDecorator getDataLabelProvider() {
            return this;
        }

        @Nullable
        public String getCellForeground(@NotNull DBDAttributeBinding attribute, int row) {
            return null;
        }

        @Nullable
        public String getCellBackground(@NotNull DBDAttributeBinding attribute, int row) {
            if (DCCompareViewerPane.this.diffs.size() <= row) {
                return null;
            }
            DCRowDiff diff = DCCompareViewerPane.this.diffs.get(row);
            SpreadsheetPresentation presentation = DCCompareViewerPane.this.getPresentation();
            if (presentation == null) {
                return null;
            }
            switch (diff.getState()) {
                case INSERTED: {
                    if (DCCompareViewerPane.this.left) break;
                    return StringConverter.asString((RGB)presentation.getBackgroundDeleted().getRGB());
                }
                case DELETED: {
                    if (!DCCompareViewerPane.this.left) break;
                    return StringConverter.asString((RGB)presentation.getBackgroundAdded().getRGB());
                }
                case MODIFIED: {
                    DBDAttributeValue[] dBDAttributeValueArray = diff.getSourceValues();
                    int n = dBDAttributeValueArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DBDAttributeValue value = dBDAttributeValueArray[n2];
                        DBSAttributeBase source = DCCompareViewerPane.this.left ? value.getAttribute() : (DBSAttributeBase)DCCompareViewerPane.this.settings.getMappings().get(value.getAttribute());
                        if (source.getName().equals(attribute.getName())) {
                            return StringConverter.asString((RGB)presentation.getBackgroundModified().getRGB());
                        }
                        ++n2;
                    }
                    break;
                }
            }
            return null;
        }
    }
}

