/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.lm.app;

import com.dbeaver.lm.app.DBPApplicationLicensed;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.impl.app.ApplicationDescriptor;
import org.jkiss.dbeaver.model.impl.app.ApplicationRegistry;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.lm.LMException;
import org.jkiss.lm.LMProduct;
import org.jkiss.lm.LMProductType;
import org.jkiss.lm.LMService;
import org.osgi.framework.Version;

public class LMAppUtils {
    private static final Log log = Log.getLog(LMAppUtils.class);
    private static final LMProduct activeProduct;

    static {
        ApplicationDescriptor application = ApplicationRegistry.getInstance().getApplication();
        Version bundleVersion = application.getContributorBundle().getVersion();
        String version = String.valueOf(bundleVersion.getMajor()) + "." + bundleVersion.getMinor();
        activeProduct = new LMProduct(application.getLicenseProductId(), application.getProductFamily(), application.getName(), application.getDescription(), version, application.isServerApplication() ? LMProductType.SERVER : LMProductType.DESKTOP, GeneralUtils.getProductReleaseDate(), application.getUmbrellaProductIds());
    }

    @NotNull
    public static LMProduct getActiveProduct() {
        return activeProduct;
    }

    public static boolean hasLicense() {
        try {
            return LMAppUtils.getLicenseService().getActiveProductLicense(false) != null;
        }
        catch (LMException e) {
            log.debug((Object)("Error validating license: " + e.getMessage()));
            return false;
        }
    }

    @NotNull
    public static LMService getLicenseService() {
        return DBPApplicationLicensed.getLicensedApplication().getLicenseService();
    }
}

