/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.model.DescribeEndpointAccessRequest;
import software.amazon.awssdk.services.redshift.model.DescribeEndpointAccessResponse;
import software.amazon.awssdk.services.redshift.model.EndpointAccess;

public class DescribeEndpointAccessIterable
implements SdkIterable<DescribeEndpointAccessResponse> {
    private final RedshiftClient client;
    private final DescribeEndpointAccessRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeEndpointAccessIterable(RedshiftClient client, DescribeEndpointAccessRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeEndpointAccessResponseFetcher();
    }

    public Iterator<DescribeEndpointAccessResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EndpointAccess> endpointAccessList() {
        Function<DescribeEndpointAccessResponse, Iterator> getIterator = response -> {
            if (response != null && response.endpointAccessList() != null) {
                return response.endpointAccessList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeEndpointAccessResponseFetcher
    implements SyncPageFetcher<DescribeEndpointAccessResponse> {
        private DescribeEndpointAccessResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEndpointAccessResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeEndpointAccessResponse nextPage(DescribeEndpointAccessResponse previousPage) {
            if (previousPage == null) {
                return DescribeEndpointAccessIterable.this.client.describeEndpointAccess(DescribeEndpointAccessIterable.this.firstRequest);
            }
            return DescribeEndpointAccessIterable.this.client.describeEndpointAccess((DescribeEndpointAccessRequest)((Object)DescribeEndpointAccessIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

