/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.model.DescribeClusterTracksRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterTracksResponse;
import software.amazon.awssdk.services.redshift.model.MaintenanceTrack;

public class DescribeClusterTracksIterable
implements SdkIterable<DescribeClusterTracksResponse> {
    private final RedshiftClient client;
    private final DescribeClusterTracksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeClusterTracksIterable(RedshiftClient client, DescribeClusterTracksRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeClusterTracksResponseFetcher();
    }

    public Iterator<DescribeClusterTracksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MaintenanceTrack> maintenanceTracks() {
        Function<DescribeClusterTracksResponse, Iterator> getIterator = response -> {
            if (response != null && response.maintenanceTracks() != null) {
                return response.maintenanceTracks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeClusterTracksResponseFetcher
    implements SyncPageFetcher<DescribeClusterTracksResponse> {
        private DescribeClusterTracksResponseFetcher() {
        }

        public boolean hasNextPage(DescribeClusterTracksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeClusterTracksResponse nextPage(DescribeClusterTracksResponse previousPage) {
            if (previousPage == null) {
                return DescribeClusterTracksIterable.this.client.describeClusterTracks(DescribeClusterTracksIterable.this.firstRequest);
            }
            return DescribeClusterTracksIterable.this.client.describeClusterTracks((DescribeClusterTracksRequest)((Object)DescribeClusterTracksIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

