/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.ClusterSecurityGroup;
import software.amazon.awssdk.services.redshift.model.ClusterSecurityGroupsCopier;
import software.amazon.awssdk.services.redshift.model.RedshiftResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeClusterSecurityGroupsResponse
extends RedshiftResponse
implements ToCopyableBuilder<Builder, DescribeClusterSecurityGroupsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeClusterSecurityGroupsResponse.getter(DescribeClusterSecurityGroupsResponse::marker)).setter(DescribeClusterSecurityGroupsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<ClusterSecurityGroup>> CLUSTER_SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ClusterSecurityGroups").getter(DescribeClusterSecurityGroupsResponse.getter(DescribeClusterSecurityGroupsResponse::clusterSecurityGroups)).setter(DescribeClusterSecurityGroupsResponse.setter(Builder::clusterSecurityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSecurityGroups").build(), ListTrait.builder().memberLocationName("ClusterSecurityGroup").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClusterSecurityGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSecurityGroup").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, CLUSTER_SECURITY_GROUPS_FIELD));
    private final String marker;
    private final List<ClusterSecurityGroup> clusterSecurityGroups;

    private DescribeClusterSecurityGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.clusterSecurityGroups = builder.clusterSecurityGroups;
    }

    public final String marker() {
        return this.marker;
    }

    public final boolean hasClusterSecurityGroups() {
        return this.clusterSecurityGroups != null && !(this.clusterSecurityGroups instanceof SdkAutoConstructList);
    }

    public final List<ClusterSecurityGroup> clusterSecurityGroups() {
        return this.clusterSecurityGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClusterSecurityGroups() ? this.clusterSecurityGroups() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClusterSecurityGroupsResponse)) {
            return false;
        }
        DescribeClusterSecurityGroupsResponse other = (DescribeClusterSecurityGroupsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && this.hasClusterSecurityGroups() == other.hasClusterSecurityGroups() && Objects.equals(this.clusterSecurityGroups(), other.clusterSecurityGroups());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeClusterSecurityGroupsResponse").add("Marker", (Object)this.marker()).add("ClusterSecurityGroups", this.hasClusterSecurityGroups() ? this.clusterSecurityGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "ClusterSecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.clusterSecurityGroups()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeClusterSecurityGroupsResponse, T> g) {
        return obj -> g.apply((DescribeClusterSecurityGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<ClusterSecurityGroup> clusterSecurityGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClusterSecurityGroupsResponse model) {
            super(model);
            this.marker(model.marker);
            this.clusterSecurityGroups(model.clusterSecurityGroups);
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        @Transient
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<ClusterSecurityGroup.Builder> getClusterSecurityGroups() {
            List<ClusterSecurityGroup.Builder> result = ClusterSecurityGroupsCopier.copyToBuilder(this.clusterSecurityGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClusterSecurityGroups(Collection<ClusterSecurityGroup.BuilderImpl> clusterSecurityGroups) {
            this.clusterSecurityGroups = ClusterSecurityGroupsCopier.copyFromBuilder(clusterSecurityGroups);
        }

        @Override
        @Transient
        public final Builder clusterSecurityGroups(Collection<ClusterSecurityGroup> clusterSecurityGroups) {
            this.clusterSecurityGroups = ClusterSecurityGroupsCopier.copy(clusterSecurityGroups);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder clusterSecurityGroups(ClusterSecurityGroup ... clusterSecurityGroups) {
            this.clusterSecurityGroups(Arrays.asList(clusterSecurityGroups));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder clusterSecurityGroups(Consumer<ClusterSecurityGroup.Builder> ... clusterSecurityGroups) {
            this.clusterSecurityGroups(Stream.of(clusterSecurityGroups).map(c -> (ClusterSecurityGroup)((ClusterSecurityGroup.Builder)ClusterSecurityGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeClusterSecurityGroupsResponse build() {
            return new DescribeClusterSecurityGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RedshiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeClusterSecurityGroupsResponse> {
        public Builder marker(String var1);

        public Builder clusterSecurityGroups(Collection<ClusterSecurityGroup> var1);

        public Builder clusterSecurityGroups(ClusterSecurityGroup ... var1);

        public Builder clusterSecurityGroups(Consumer<ClusterSecurityGroup.Builder> ... var1);
    }
}

