/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateDataShareConsumerRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, AssociateDataShareConsumerRequest> {
    private static final SdkField<String> DATA_SHARE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataShareArn").getter(AssociateDataShareConsumerRequest.getter(AssociateDataShareConsumerRequest::dataShareArn)).setter(AssociateDataShareConsumerRequest.setter(Builder::dataShareArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataShareArn").build()}).build();
    private static final SdkField<Boolean> ASSOCIATE_ENTIRE_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AssociateEntireAccount").getter(AssociateDataShareConsumerRequest.getter(AssociateDataShareConsumerRequest::associateEntireAccount)).setter(AssociateDataShareConsumerRequest.setter(Builder::associateEntireAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociateEntireAccount").build()}).build();
    private static final SdkField<String> CONSUMER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConsumerArn").getter(AssociateDataShareConsumerRequest.getter(AssociateDataShareConsumerRequest::consumerArn)).setter(AssociateDataShareConsumerRequest.setter(Builder::consumerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumerArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SHARE_ARN_FIELD, ASSOCIATE_ENTIRE_ACCOUNT_FIELD, CONSUMER_ARN_FIELD));
    private final String dataShareArn;
    private final Boolean associateEntireAccount;
    private final String consumerArn;

    private AssociateDataShareConsumerRequest(BuilderImpl builder) {
        super(builder);
        this.dataShareArn = builder.dataShareArn;
        this.associateEntireAccount = builder.associateEntireAccount;
        this.consumerArn = builder.consumerArn;
    }

    public final String dataShareArn() {
        return this.dataShareArn;
    }

    public final Boolean associateEntireAccount() {
        return this.associateEntireAccount;
    }

    public final String consumerArn() {
        return this.consumerArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dataShareArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.associateEntireAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.consumerArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateDataShareConsumerRequest)) {
            return false;
        }
        AssociateDataShareConsumerRequest other = (AssociateDataShareConsumerRequest)((Object)obj);
        return Objects.equals(this.dataShareArn(), other.dataShareArn()) && Objects.equals(this.associateEntireAccount(), other.associateEntireAccount()) && Objects.equals(this.consumerArn(), other.consumerArn());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateDataShareConsumerRequest").add("DataShareArn", (Object)this.dataShareArn()).add("AssociateEntireAccount", (Object)this.associateEntireAccount()).add("ConsumerArn", (Object)this.consumerArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataShareArn": {
                return Optional.ofNullable(clazz.cast(this.dataShareArn()));
            }
            case "AssociateEntireAccount": {
                return Optional.ofNullable(clazz.cast(this.associateEntireAccount()));
            }
            case "ConsumerArn": {
                return Optional.ofNullable(clazz.cast(this.consumerArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateDataShareConsumerRequest, T> g) {
        return obj -> g.apply((AssociateDataShareConsumerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private String dataShareArn;
        private Boolean associateEntireAccount;
        private String consumerArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateDataShareConsumerRequest model) {
            super(model);
            this.dataShareArn(model.dataShareArn);
            this.associateEntireAccount(model.associateEntireAccount);
            this.consumerArn(model.consumerArn);
        }

        public final String getDataShareArn() {
            return this.dataShareArn;
        }

        public final void setDataShareArn(String dataShareArn) {
            this.dataShareArn = dataShareArn;
        }

        @Override
        @Transient
        public final Builder dataShareArn(String dataShareArn) {
            this.dataShareArn = dataShareArn;
            return this;
        }

        public final Boolean getAssociateEntireAccount() {
            return this.associateEntireAccount;
        }

        public final void setAssociateEntireAccount(Boolean associateEntireAccount) {
            this.associateEntireAccount = associateEntireAccount;
        }

        @Override
        @Transient
        public final Builder associateEntireAccount(Boolean associateEntireAccount) {
            this.associateEntireAccount = associateEntireAccount;
            return this;
        }

        public final String getConsumerArn() {
            return this.consumerArn;
        }

        public final void setConsumerArn(String consumerArn) {
            this.consumerArn = consumerArn;
        }

        @Override
        @Transient
        public final Builder consumerArn(String consumerArn) {
            this.consumerArn = consumerArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateDataShareConsumerRequest build() {
            return new AssociateDataShareConsumerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RedshiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateDataShareConsumerRequest> {
        public Builder dataShareArn(String var1);

        public Builder associateEntireAccount(Boolean var1);

        public Builder consumerArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

