/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.tds;

import com.sybase.jdbc4.IConstants;
import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.jdbc.Param;
import com.sybase.jdbc4.jdbc.ParamManager;
import com.sybase.jdbc4.jdbc.Protocol;
import com.sybase.jdbc4.tds.DataFormat;
import com.sybase.jdbc4.tds.RowFormatToken;
import com.sybase.jdbc4.tds.TdsInputStream;
import com.sybase.jdbc4.tds.TdsOutputStream;
import com.sybase.jdbc4.tds.TdsParam;
import java.io.IOException;
import java.sql.SQLException;

public class ParamFormatToken
extends RowFormatToken {
    public static final int MAX_PARAMFMT_LENGTH = 65535;
    protected DataFormat[] _param;
    protected ParamManager _paramMgr;
    protected int _numParams;
    private int _length = -1;

    public ParamFormatToken() {
    }

    public ParamFormatToken(ParamManager paramManager, boolean bl) throws IOException, SQLException {
        this._numParams = paramManager.makeFormats(bl);
        this._paramMgr = paramManager;
    }

    public ParamFormatToken(TdsInputStream tdsInputStream) throws IOException {
        this.readLength(tdsInputStream);
        this._numColumns = tdsInputStream.readShort();
        this.addDataFormats(tdsInputStream, this._numColumns);
    }

    public ParamFormatToken(ParamManager paramManager, Param[] paramArray, Protocol protocol, IConstants.STATEMENT_EXECUTION_MODE sTATEMENT_EXECUTION_MODE, boolean bl) throws IOException, SQLException {
        this._paramMgr = paramManager;
        TdsParam tdsParam = null;
        this._length = 0;
        int n = paramArray.length;
        for (int i = 0; i < n; ++i) {
            tdsParam = (TdsParam)paramArray[i];
            if (!tdsParam.makeFormat(protocol, sTATEMENT_EXECUTION_MODE)) continue;
            this._length += tdsParam._inDataFmt.length();
            ++this._numParams;
            if (!bl && (!protocol.isSuppressParamFormatSupportedAndSet() || sTATEMENT_EXECUTION_MODE != IConstants.STATEMENT_EXECUTION_MODE.DYNAMIC)) continue;
            tdsParam._inDataFmt._precision = this._paramMgr.getParamMD((int)i)._precision;
        }
    }

    protected long getLength() {
        int n = 2;
        n = this._length < 0 ? (n += this._paramMgr.getLength()) : (n += this._length);
        return n;
    }

    public int getFormatCount() {
        return this._numParams;
    }

    @Override
    public void send(TdsOutputStream tdsOutputStream) throws IOException {
        if (this.getLength() > 65535L) {
            ErrorMessage.raiseIOException("JZ0PC");
        } else {
            tdsOutputStream.writeByte(236);
            tdsOutputStream.writeShort((int)this.getLength());
            tdsOutputStream.writeShort(this.getFormatCount());
            this.sendFormat(tdsOutputStream);
        }
    }

    protected void sendFormat(TdsOutputStream tdsOutputStream) throws IOException {
        this._paramMgr.sendFormats(tdsOutputStream);
    }

    public void sendAddBatch(Param[] paramArray, TdsOutputStream tdsOutputStream) throws IOException {
        long l = this.getLength();
        if (l > 65535L) {
            ErrorMessage.raiseIOException("JZ0PC");
        } else {
            tdsOutputStream.writeByte(236);
            tdsOutputStream.writeShort((int)l);
            tdsOutputStream.writeShort(this.getFormatCount());
            TdsParam tdsParam = null;
            for (int i = 0; i < paramArray.length; ++i) {
                tdsParam = (TdsParam)paramArray[i];
                tdsParam.sendFormat(tdsOutputStream);
            }
        }
    }
}

