/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public class SybUTF8CharsetEncoder
extends CharsetEncoder {
    private boolean isSet = false;
    private char storedChar = '\u0000';

    public SybUTF8CharsetEncoder(Charset charset, float f, float f2) {
        super(charset, f, f2);
    }

    public SybUTF8CharsetEncoder(Charset charset, float f, float f2, byte[] byArray) {
        super(charset, f, f2, byArray);
    }

    @Override
    protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        if (this.isSet && charBuffer.position() > 0 && this.storedChar != charBuffer.get(charBuffer.position() - 1)) {
            return CoderResult.malformedForLength(charBuffer.position());
        }
        while (charBuffer.hasRemaining()) {
            if (!byteBuffer.hasRemaining()) {
                return CoderResult.OVERFLOW;
            }
            if (!this.isSet) {
                this.storedChar = charBuffer.get();
                this.isSet = true;
            }
            if (this.storedChar <= '\u007f') {
                byteBuffer.put((byte)this.storedChar);
                this.isSet = false;
                continue;
            }
            if (this.storedChar <= '\u07ff') {
                if (byteBuffer.remaining() < 2) {
                    return CoderResult.OVERFLOW;
                }
                byteBuffer.put((byte)(0xC0 | this.storedChar >> 6));
                byteBuffer.put((byte)(0x80 | this.storedChar & 0x3F));
                this.isSet = false;
                continue;
            }
            if (byteBuffer.remaining() < 3) {
                return CoderResult.OVERFLOW;
            }
            byteBuffer.put((byte)(0xE0 | this.storedChar >> 12));
            byteBuffer.put((byte)(0x80 | this.storedChar >> 6 & 0x3F));
            byteBuffer.put((byte)(0x80 | this.storedChar & 0x3F));
            this.isSet = false;
        }
        return CoderResult.UNDERFLOW;
    }
}

