/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.util.reflection;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class GenericTypeExtractor {
    public static Class<?> genericTypeOf(Class<?> rootClass, Class<?> targetBaseClass, Class<?> targetBaseInterface) {
        for (Class<?> match = rootClass; match != Object.class; match = match.getSuperclass()) {
            if (match.getSuperclass() == targetBaseClass) {
                return GenericTypeExtractor.extractGeneric(match.getGenericSuperclass());
            }
            Type genericInterface = GenericTypeExtractor.findGenericInteface(match, targetBaseInterface);
            if (genericInterface == null) continue;
            return GenericTypeExtractor.extractGeneric(genericInterface);
        }
        return Object.class;
    }

    private static Type findGenericInteface(Class<?> sourceClass, Class<?> targetBaseInterface) {
        for (int i = 0; i < sourceClass.getInterfaces().length; ++i) {
            Class<?> inter = sourceClass.getInterfaces()[i];
            if (inter == targetBaseInterface) {
                return sourceClass.getGenericInterfaces()[0];
            }
            Type deeper = GenericTypeExtractor.findGenericInteface(inter, targetBaseInterface);
            if (deeper == null) continue;
            return deeper;
        }
        return null;
    }

    private static Class<?> extractGeneric(Type type) {
        Type[] genericTypes;
        if (type instanceof ParameterizedType && (genericTypes = ((ParameterizedType)type).getActualTypeArguments()).length > 0 && genericTypes[0] instanceof Class) {
            return (Class)genericTypes[0];
        }
        return Object.class;
    }
}

