/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.vertica.diff.output.changelog;

import java.util.Date;
import liquibase.change.Change;
import liquibase.change.ConstraintsConfig;
import liquibase.database.Database;
import liquibase.datatype.DataTypeFactory;
import liquibase.diff.compare.CompareControl;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.AbstractChangeGenerator;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.diff.output.changelog.MissingObjectChangeGenerator;
import liquibase.ext.vertica.change.ColumnConfigVertica;
import liquibase.ext.vertica.change.CreateProjectionChange;
import liquibase.ext.vertica.database.VerticaDatabase;
import liquibase.ext.vertica.structure.ColumnVertica;
import liquibase.ext.vertica.structure.Projection;
import liquibase.statement.DatabaseFunction;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.Table;

public class MissingProjectionChangeGenerator
extends AbstractChangeGenerator
implements MissingObjectChangeGenerator {
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (database instanceof VerticaDatabase && Projection.class.isAssignableFrom(objectType)) {
            return 5;
        }
        return -1;
    }

    public Class<? extends DatabaseObject>[] runAfterTypes() {
        return new Class[]{Table.class};
    }

    public Class<? extends DatabaseObject>[] runBeforeTypes() {
        return new Class[]{Column.class};
    }

    public Change[] fixMissing(DatabaseObject missingObject, DiffOutputControl control, Database referenceDatabase, Database comparisonDatabase, ChangeGeneratorChain chain) {
        Projection missingProjection = (Projection)missingObject;
        CreateProjectionChange change = new CreateProjectionChange();
        change.setProjectionName(missingProjection.getName());
        change.setSchemaName(missingProjection.getSchema().getName());
        change.setSubquery(missingProjection.getSubquery());
        if (missingProjection.getOrderBy() != null) {
            change.setOrderby(missingProjection.getOrderBy());
        }
        if (missingProjection.getKSafe() != null) {
            change.setKsafe(missingProjection.getKSafe());
        }
        if (missingProjection.getIsSegmented()) {
            change.setSegmentedby(missingProjection.getSegmentedBy());
        }
        change.setNodes(missingProjection.getNodes());
        if (missingProjection.getRemarks() != null) {
            change.setRemarks(missingProjection.getRemarks());
        }
        for (Column column : missingProjection.getColumns()) {
            Object defaultValue;
            ColumnConfigVertica columnConfig = new ColumnConfigVertica();
            columnConfig.setName(column.getName());
            columnConfig.setType(DataTypeFactory.getInstance().from(column.getType(), comparisonDatabase).toDatabaseDataType(referenceDatabase).toString());
            if (column.isAutoIncrement()) {
                columnConfig.setAutoIncrement(true);
            }
            columnConfig.setEncoding(((ColumnVertica)column).getEncoding());
            ConstraintsConfig constraintsConfig = null;
            if (constraintsConfig != null) {
                columnConfig.setConstraints(constraintsConfig);
            }
            if ((defaultValue = column.getDefaultValue()) != null && !column.isAutoIncrement()) {
                if (defaultValue instanceof Date) {
                    columnConfig.setDefaultValueDate((Date)defaultValue);
                } else if (defaultValue instanceof Boolean) {
                    columnConfig.setDefaultValueBoolean((Boolean)defaultValue);
                } else if (defaultValue instanceof Number) {
                    columnConfig.setDefaultValueNumeric((Number)defaultValue);
                } else if (defaultValue instanceof DatabaseFunction) {
                    columnConfig.setDefaultValueComputed((DatabaseFunction)defaultValue);
                } else {
                    columnConfig.setDefaultValue(defaultValue.toString());
                }
            }
            if (column.getRemarks() != null) {
                columnConfig.setRemarks(column.getRemarks());
            }
            change.addColumn(columnConfig);
            control.setAlreadyHandledMissing((DatabaseObject)column);
        }
        return new Change[]{change};
    }

    public Change[] fixSchema(Change[] changes, CompareControl.SchemaComparison[] schemaComparisons) {
        return new Change[0];
    }

    public Change[] fixOutputAsSchema(Change[] changes, CompareControl.SchemaComparison[] schemaComparisons) {
        return new Change[0];
    }
}

