/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.vertica.database;

import java.math.BigInteger;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import liquibase.CatalogAndSchema;
import liquibase.Scope;
import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.executor.ExecutorService;
import liquibase.ext.vertica.statement.GetProjectionDefinitionStatement;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Table;
import liquibase.util.StringUtil;

public class VerticaDatabase
extends AbstractJdbcDatabase {
    public static final String PRODUCT_NAME = "Vertica Database";
    private Set<String> systemTablesAndViews = new HashSet<String>();
    private static Pattern INITIAL_COMMENT_PATTERN = Pattern.compile("^/\\*.*?\\*/");
    private static Pattern CREATE_PROJECTION_AS_PATTERN = Pattern.compile("(?im)^\\s*(CREATE|ALTER)\\s+?PROJECTION\\s+?((\\S+?)|(\\[.*\\])|(\\\".*\\\"))\\s+?AS\\s*?", 34);
    private static Pattern CREATE_VIEW_AS_PATTERN = Pattern.compile("^CREATE\\s+.*?VIEW\\s+.*?AS\\s+", 34);
    private Set<String> reservedWords = new HashSet<String>();

    public VerticaDatabase() {
        super.setCurrentDateTimeFunction("NOW()");
        this.sequenceNextValueFunction = "nextval('%s')";
        this.sequenceCurrentValueFunction = "currval('%s')";
        this.unmodifiableDataTypes.addAll(Arrays.asList("integer", "bool", "boolean", "int4", "int8", "float4", "float8", "numeric", "bigserial", "serial", "bytea", "timestamptz"));
        this.unquotedObjectsAreUppercased = false;
    }

    public String getShortName() {
        return "vertica";
    }

    protected String getDefaultDatabaseProductName() {
        return PRODUCT_NAME;
    }

    public Integer getDefaultPort() {
        return 5433;
    }

    public Set<String> getSystemViews() {
        return this.systemTablesAndViews;
    }

    public int getPriority() {
        return 5;
    }

    public boolean supportsInitiallyDeferrableColumns() {
        return false;
    }

    public boolean supportsDropTableCascadeConstraints() {
        return true;
    }

    public boolean isCorrectDatabaseImplementation(DatabaseConnection conn) throws DatabaseException {
        return PRODUCT_NAME.equalsIgnoreCase(conn.getDatabaseProductName());
    }

    public String getDefaultDriver(String url) {
        if (url.startsWith("jdbc:vertica:")) {
            return "com.vertica.jdbc.Driver";
        }
        return null;
    }

    public boolean supportsCatalogs() {
        return false;
    }

    public boolean supportsCatalogInObjectName(Class<? extends DatabaseObject> type) {
        return false;
    }

    public boolean supportsSequences() {
        return true;
    }

    public String getDatabaseChangeLogTableName() {
        return super.getDatabaseChangeLogTableName().toUpperCase();
    }

    public String getDatabaseChangeLogLockTableName() {
        return super.getDatabaseChangeLogLockTableName().toUpperCase();
    }

    public boolean isSystemObject(DatabaseObject example) {
        if (example instanceof Table && example.getSchema() != null && ("V_MONITOR".equals(example.getSchema().getName()) || "V_CATALOG".equals(example.getSchema().getName()))) {
            return true;
        }
        return super.isSystemObject(example);
    }

    public boolean supportsTablespaces() {
        return false;
    }

    public String getAutoIncrementClause(BigInteger startWith, BigInteger incrementBy, String generationType, Boolean defaultOnNull) {
        if (startWith != null && incrementBy != null) {
            return " IDENTITY(" + startWith + "," + incrementBy + ") ";
        }
        return " AUTO_INCREMENT ";
    }

    public boolean supportsAutoIncrement() {
        return true;
    }

    public String getAutoIncrementClause() {
        return "";
    }

    public boolean generateAutoIncrementStartWith(BigInteger startWith) {
        return true;
    }

    public boolean generateAutoIncrementBy(BigInteger incrementBy) {
        return true;
    }

    public String escapeObjectName(String objectName, Class<? extends DatabaseObject> objectType) {
        if (this.hasMixedCase(objectName)) {
            return "\"" + objectName + "\"";
        }
        return super.escapeObjectName(objectName, objectType);
    }

    public String escapeObjectName(String catalogName, String schemaName, String objectName, Class<? extends DatabaseObject> objectType) {
        if (this.hasMixedCase(objectName)) {
            return "\"" + objectName + "\"";
        }
        return super.escapeObjectName(catalogName, schemaName, objectName, objectType);
    }

    public String correctObjectName(String objectName, Class<? extends DatabaseObject> objectType) {
        if (objectName == null || this.quotingStrategy != ObjectQuotingStrategy.LEGACY) {
            return super.correctObjectName(objectName, objectType);
        }
        if (objectName.contains("-") || this.hasMixedCase(objectName) || this.startsWithNumeric(objectName) || this.isReservedWord(objectName)) {
            return objectName;
        }
        return objectName.toLowerCase();
    }

    public CatalogAndSchema correctSchema(CatalogAndSchema schema) {
        if (schema == null) {
            return new CatalogAndSchema(null, this.getDefaultSchemaName());
        }
        String schemaName = StringUtil.trimToNull((String)schema.getSchemaName());
        if (schemaName == null) {
            schemaName = this.getDefaultSchemaName();
        }
        return new CatalogAndSchema(null, schemaName);
    }

    protected boolean hasMixedCase(String tableName) {
        if (tableName == null) {
            return false;
        }
        return StringUtil.hasUpperCase((String)tableName) && StringUtil.hasLowerCase((String)tableName);
    }

    public boolean supportsRestrictForeignKeys() {
        return false;
    }

    public boolean isReservedWord(String tableName) {
        return this.reservedWords.contains(tableName.toUpperCase());
    }

    private List<String> getSearchPaths() {
        ArrayList<String> searchPaths = null;
        try {
            String searchPathResult;
            DatabaseConnection con = this.getConnection();
            if (con != null && (searchPathResult = (String)((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", (Database)this).queryForObject((SqlStatement)new RawSqlStatement("SHOW search_path"), String.class)) != null) {
                String[] dirtySearchPaths = searchPathResult.split("\\,");
                searchPaths = new ArrayList<String>();
                for (String searchPath : dirtySearchPaths) {
                    if ((searchPath = searchPath.trim()).equals("\"$user\"")) {
                        searchPath = "$user";
                    }
                    searchPaths.add(searchPath);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).severe("Failed to get default catalog name from vertica", (Throwable)e);
        }
        return searchPaths;
    }

    protected String getConnectionSchemaName() {
        DatabaseConnection connection = this.getConnection();
        if (connection == null) {
            return null;
        }
        try {
            ResultSet resultSet = ((JdbcConnection)connection).createStatement().executeQuery("SELECT CURRENT_SCHEMA");
            resultSet.next();
            String schema = resultSet.getString(1);
            return schema;
        }
        catch (Exception e) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Error getting default schema", (Throwable)e);
            return null;
        }
    }

    public String executeSQL(String query) {
        DatabaseConnection connection = this.getConnection();
        if (connection == null) {
            return null;
        }
        StringBuilder res = null;
        try {
            ResultSet resultSet = ((JdbcConnection)connection).createStatement().executeQuery(query);
            while (resultSet.next()) {
                if (res == null) {
                    res = new StringBuilder();
                }
                res.append(resultSet.getString(1));
            }
            if (res != null) {
                return res.toString();
            }
        }
        catch (Exception e) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Error got exception when running: " + query, (Throwable)e);
        }
        return null;
    }

    private boolean catalogExists(String catalogName) throws DatabaseException {
        return catalogName != null && this.runExistsQuery("select count(*) from information_schema.schemata where catalog_name='" + catalogName + "'");
    }

    private boolean schemaExists(String schemaName) throws DatabaseException {
        return schemaName != null && this.runExistsQuery("select count(*) from information_schema.schemata where schema_name='" + schemaName + "'");
    }

    private boolean runExistsQuery(String query) throws DatabaseException {
        Long count = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", (Database)this).queryForLong((SqlStatement)new RawSqlStatement(query));
        return count != null && count > 0L;
    }

    public String getProjectionDefinition(CatalogAndSchema schema, String projectionName) throws DatabaseException {
        schema = this.correctSchema(schema);
        List defLines = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", (Database)this).queryForList((SqlStatement)new GetProjectionDefinitionStatement(schema.getCatalogName(), schema.getSchemaName(), projectionName), String.class);
        StringBuilder sb = new StringBuilder();
        for (String defLine : defLines) {
            sb.append(defLine);
        }
        String definition = sb.toString();
        String finalDef = definition.replaceAll("\r\n", "\n");
        finalDef = INITIAL_COMMENT_PATTERN.matcher(finalDef).replaceFirst("").trim();
        finalDef = CREATE_PROJECTION_AS_PATTERN.matcher(finalDef).replaceFirst("").trim();
        if ((finalDef = finalDef.replaceAll("--.*", "").trim()).startsWith("(") && (finalDef.endsWith(")") || finalDef.endsWith(");"))) {
            finalDef = finalDef.replaceFirst("^\\(", "");
            finalDef = finalDef.replaceFirst("\\);?$", "");
        }
        return finalDef;
    }

    public String getViewDefinition(CatalogAndSchema schema, String viewName) throws DatabaseException {
        schema = schema.customize((Database)this);
        String definition = (String)((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", (Database)this).queryForObject((SqlStatement)new RawSqlStatement("select view_definition from views  where table_name='" + viewName + "' and table_schema='" + schema.getSchemaName() + "'"), String.class);
        if (definition == null) {
            return null;
        }
        return definition;
    }

    public boolean supportsSchemas() {
        return true;
    }
}

