/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.vertica.change;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import liquibase.change.AddColumnConfig;
import liquibase.change.ColumnConfig;
import liquibase.change.ConstraintsConfig;
import liquibase.change.DatabaseChange;
import liquibase.change.core.AddColumnChange;
import liquibase.database.Database;
import liquibase.ext.vertica.change.ColumnConfigVertica;
import liquibase.ext.vertica.statement.AddVerticaColumnStatement;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.statement.AutoIncrementConstraint;
import liquibase.statement.ColumnConstraint;
import liquibase.statement.ForeignKeyConstraint;
import liquibase.statement.NotNullConstraint;
import liquibase.statement.PrimaryKeyConstraint;
import liquibase.statement.SqlStatement;
import liquibase.statement.UniqueConstraint;
import liquibase.statement.core.SetColumnRemarksStatement;
import liquibase.statement.core.UpdateStatement;
import liquibase.util.StringUtil;

@DatabaseChange(name="addVerticaColumn", description="add a column to an existing table", priority=5)
public class AddVerticaColumnChange
extends AddColumnChange {
    public ColumnConfigVertica createColumnv() {
        ColumnConfigVertica col = new ColumnConfigVertica();
        this.addColumn(col);
        return col;
    }

    public SqlStatement[] generateStatements(Database database) {
        ArrayList<AddVerticaColumnStatement> sql = new ArrayList<AddVerticaColumnStatement>();
        if (this.getColumns().size() == 0) {
            return new SqlStatement[]{new AddVerticaColumnStatement("", this.getSchemaName(), this.getTableName(), null, null, null, null, null, new ColumnConstraint[0])};
        }
        Iterator iterator = this.getColumns().iterator();
        while (iterator.hasNext()) {
            AddColumnConfig colum;
            AddColumnConfig column = colum = (AddColumnConfig)iterator.next();
            HashSet<Object> constraints = new HashSet<Object>();
            ConstraintsConfig constraintsConfig = column.getConstraints();
            if (constraintsConfig != null) {
                if (constraintsConfig.isNullable() != null && !constraintsConfig.isNullable().booleanValue()) {
                    constraints.add(new NotNullConstraint());
                }
                if (constraintsConfig.isUnique() != null && constraintsConfig.isUnique().booleanValue()) {
                    constraints.add(new UniqueConstraint());
                }
                if (constraintsConfig.isPrimaryKey() != null && constraintsConfig.isPrimaryKey().booleanValue()) {
                    constraints.add(new PrimaryKeyConstraint(constraintsConfig.getPrimaryKeyName()));
                }
                if (constraintsConfig.getReferences() != null || constraintsConfig.getReferencedColumnNames() != null && constraintsConfig.getReferencedTableName() != null) {
                    constraints.add(new ForeignKeyConstraint(constraintsConfig.getForeignKeyName(), constraintsConfig.getReferences(), constraintsConfig.getReferencedTableName(), constraintsConfig.getReferencedColumnNames()));
                }
            }
            if (column.isAutoIncrement() != null && column.isAutoIncrement().booleanValue()) {
                constraints.add(new AutoIncrementConstraint(column.getName(), column.getStartWith(), column.getIncrementBy()));
            }
            AddVerticaColumnStatement addColumnStatement = new AddVerticaColumnStatement(this.getCatalogName(), this.getSchemaName(), this.getTableName(), column.getName(), column.getType(), column.getDefaultValueObject(), column.getEncoding(), null, constraints.toArray(new ColumnConstraint[constraints.size()]));
            sql.add(addColumnStatement);
            if (column.getValueObject() == null) continue;
            UpdateStatement updateStatement = new UpdateStatement(this.getCatalogName(), this.getSchemaName(), this.getTableName());
            updateStatement.addNewColumnValue(column.getName(), column.getValueObject());
            sql.add((AddVerticaColumnStatement)updateStatement);
        }
        for (ColumnConfig column : this.getColumns()) {
            String columnRemarks = StringUtil.trimToNull((String)column.getRemarks());
            if (columnRemarks == null) continue;
            SetColumnRemarksStatement remarksStatement = new SetColumnRemarksStatement("", this.getSchemaName(), this.getTableName(), column.getName(), columnRemarks);
            if (!SqlGeneratorFactory.getInstance().supports((SqlStatement)remarksStatement, database)) continue;
            sql.add((AddVerticaColumnStatement)remarksStatement);
        }
        return sql.toArray(new SqlStatement[sql.size()]);
    }
}

