/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.teradata.model;

import com.dbeaver.db.teradata.model.TeradataDatasource;
import com.dbeaver.db.teradata.model.TeradataMacro;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPImageProvider;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectLookupCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class TeradataDatabase
extends GenericSchema
implements DBPImageProvider {
    private boolean isUser;
    private final List<TeradataDatabase> childDatabases;
    private final MacroCache macroCache = new MacroCache();

    TeradataDatabase(@NotNull GenericDataSource dataSource, @NotNull String catalogName, boolean isUser) {
        super(dataSource, null, catalogName);
        this.isUser = isUser;
        this.childDatabases = new ArrayList<TeradataDatabase>();
    }

    public MacroCache getMacroCache() {
        return this.macroCache;
    }

    @Association
    public Collection<TeradataMacro> getMacros(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.macroCache.getAllObjects(monitor, (DBSObject)this);
    }

    @Association
    public TeradataMacro getMacro(@NotNull DBRProgressMonitor monitor, @NotNull String macroName) throws DBException {
        return (TeradataMacro)this.macroCache.getObject(monitor, (DBSObject)this, macroName);
    }

    void addChildDatabase(@NotNull TeradataDatabase database) {
        this.childDatabases.add(database);
    }

    @Association
    public List<TeradataDatabase> getCatalogList() {
        if ("DBC".equals(this.getName())) {
            return null;
        }
        GenericDataSource dataSource = this.getDataSource();
        if (dataSource instanceof TeradataDatasource && !((TeradataDatasource)dataSource).showDatabasesHierarchically()) {
            return null;
        }
        return this.childDatabases;
    }

    @Nullable
    public DBPImage getObjectImage() {
        if (this.isUser) {
            return DBIcon.TREE_USER;
        }
        return DBIcon.TREE_DATABASE;
    }

    public synchronized DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.childDatabases.clear();
        this.macroCache.clearCache();
        return super.refreshObject(monitor);
    }

    public class MacroCache
    extends JDBCObjectLookupCache<TeradataDatabase, TeradataMacro> {
        @NotNull
        public JDBCStatement prepareLookupStatement(@NotNull JDBCSession session, @NotNull TeradataDatabase teradataDatabase, @Nullable TeradataMacro object, @Nullable String objectName) throws SQLException {
            String sql = "SELECT * FROM dbc.tablesV WHERE tablekind = 'M'\nAND DataBaseName = ?" + (object != null || objectName != null ? " AND TableName = ?" : "");
            JDBCPreparedStatement statement = session.prepareStatement(sql);
            statement.setString(1, teradataDatabase.getName());
            if (object != null || objectName != null) {
                statement.setString(2, object != null ? object.getName() : objectName);
            }
            return statement;
        }

        @Nullable
        protected TeradataMacro fetchObject(@NotNull JDBCSession session, @NotNull TeradataDatabase teradataDatabase, @NotNull JDBCResultSet resultSet) {
            String macroName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"TableName");
            if (CommonUtils.isNotEmpty((String)macroName)) {
                return new TeradataMacro(teradataDatabase, macroName, resultSet);
            }
            return null;
        }
    }
}

