/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.firebird.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.firebird.model.FireBirdFieldType;
import org.jkiss.dbeaver.ext.firebird.model.FireBirdProcedureParameter;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericFunctionResultType;
import org.jkiss.dbeaver.ext.generic.model.GenericPackage;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedure;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectWithScript;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureParameterKind;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;

public class FireBirdProcedure
extends GenericProcedure
implements DBSObjectWithScript {
    public GenericCatalog getCatalog() {
        return super.getCatalog();
    }

    public GenericSchema getSchema() {
        return super.getSchema();
    }

    public GenericPackage getPackage() {
        return super.getPackage();
    }

    public FireBirdProcedure(GenericStructContainer container, String procedureName, String specificName, String description, DBSProcedureType procedureType, GenericFunctionResultType functionResultType) {
        super(container, procedureName, specificName, description, procedureType, functionResultType);
    }

    @Property(hidden=true, editable=true, updatable=true)
    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        return super.getObjectDefinitionText(monitor, options);
    }

    public void loadProcedureColumns(DBRProgressMonitor monitor) throws DBException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load procedure columns");){
                boolean isProcedure = this.getProcedureType() == DBSProcedureType.PROCEDURE;
                String sql = !isProcedure && ((GenericDataSource)this.getDataSource()).isServerVersionAtLeast(3, 0) ? "SELECT\nCOALESCE(FUNA.RDB$ARGUMENT_NAME, 'PARAM_' || FUNA.RDB$ARGUMENT_POSITION) AS COLUMN_NAME,\nCOALESCE(FUNA.RDB$FIELD_TYPE, F.RDB$FIELD_TYPE) AS DATA_TYPE,\nCOALESCE(FUNA.RDB$FIELD_SUB_TYPE, F.RDB$FIELD_SUB_TYPE) AS FIELD_SUB_TYPE,\nCOALESCE(FUNA.RDB$FIELD_PRECISION, F.RDB$FIELD_PRECISION) AS \"PRECISION\",\nCOALESCE(FUNA.RDB$FIELD_SCALE, F.RDB$FIELD_SCALE) AS \"SCALE\",\nCOALESCE(FUNA.RDB$FIELD_LENGTH, F.RDB$FIELD_LENGTH) AS \"LENGTH\",\nCOALESCE(FUNA.RDB$CHARACTER_LENGTH, F.RDB$CHARACTER_LENGTH) AS CHAR_LEN,\nCOALESCE(FUNA.RDB$DEFAULT_SOURCE, F.RDB$DEFAULT_SOURCE) AS DEFAULT_VALUE,\nCOALESCE(FUNA.RDB$CHARACTER_SET_ID, F.RDB$CHARACTER_SET_ID) AS CHARACTER_SET_ID,\nCASE\n   WHEN FUN.RDB$RETURN_ARGUMENT = FUNA.RDB$ARGUMENT_POSITION THEN 0\n   ELSE FUNA.RDB$ARGUMENT_POSITION\nEND AS ORDINAL_POSITION,\nCASE\n   WHEN COALESCE(FUNA.RDB$NULL_FLAG, F.RDB$NULL_FLAG) = 1 THEN TRUE\n   WHEN FUNA.RDB$MECHANISM = 0 THEN TRUE\n   WHEN FUNA.RDB$MECHANISM = 1 THEN TRUE\n   ELSE FALSE\nEND AS NOT_NULL\nFROM\n   RDB$FUNCTIONS FUN\nINNER JOIN RDB$FUNCTION_ARGUMENTS FUNA ON\n   FUNA.RDB$FUNCTION_NAME = FUN.RDB$FUNCTION_NAME\n   AND FUNA.RDB$PACKAGE_NAME IS NOT DISTINCT\nFROM\n   FUN.RDB$PACKAGE_NAME\nLEFT JOIN RDB$FIELDS F ON\n   F.RDB$FIELD_NAME = FUNA.RDB$FIELD_SOURCE\nWHERE\n   FUN.RDB$FUNCTION_NAME=?" : "SELECT\nCAST(PP.RDB$PARAMETER_NAME AS varchar(63)) AS COLUMN_NAME,\nPP.RDB$PARAMETER_TYPE AS COLUMN_TYPE,\nF.RDB$FIELD_TYPE AS DATA_TYPE,\nF.RDB$FIELD_SUB_TYPE AS FIELD_SUB_TYPE,\nF.RDB$FIELD_PRECISION AS \"PRECISION\",\nF.RDB$FIELD_SCALE AS \"SCALE\",\nF.RDB$FIELD_LENGTH AS \"LENGTH\",\nPP.RDB$NULL_FLAG AS NOT_NULL,\nPP.RDB$DESCRIPTION AS REMARKS,\nF.RDB$CHARACTER_LENGTH AS CHAR_LEN,\nPP.RDB$PARAMETER_NUMBER + 1 AS ORDINAL_POSITION,\nF.RDB$CHARACTER_SET_ID,\nF.RDB$DEFAULT_SOURCE AS DEFAULT_VALUE\nFROM\n   RDB$PROCEDURE_PARAMETERS PP,\n   RDB$FIELDS F\nWHERE\n   PP.RDB$FIELD_SOURCE = F.RDB$FIELD_NAME\n   AND PP.RDB$PROCEDURE_NAME=?\nORDER BY\n   PP.RDB$PARAMETER_NUMBER";
                Throwable throwable2 = null;
                Object var8_12 = null;
                try (JDBCPreparedStatement dbStat = session.prepareStatement(sql);){
                    dbStat.setString(1, this.getName());
                    Throwable throwable3 = null;
                    Object var11_17 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        while (dbResult.next()) {
                            DBSProcedureParameterKind parameterType;
                            String parameterName = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"COLUMN_NAME");
                            int dataType = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"DATA_TYPE");
                            int subType = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"FIELD_SUB_TYPE");
                            FireBirdFieldType fieldDT = FireBirdFieldType.getById(dataType, subType);
                            String typeName = "";
                            if (fieldDT != null) {
                                typeName = fieldDT.getName();
                            }
                            int columnSize = (fieldDT == FireBirdFieldType.CHAR || fieldDT == FireBirdFieldType.VARCHAR) && isProcedure ? JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"CHAR_LEN") : JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"LENGTH");
                            boolean notNull = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"NOT_NULL");
                            int scale = Math.abs(JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"SCALE"));
                            int precision = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"PRECISION");
                            String remarks = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"REMARKS");
                            int position = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"ORDINAL_POSITION");
                            String defaultValue = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"DEFAULT_VALUE");
                            if (isProcedure) {
                                int paramTypeNum = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"COLUMN_TYPE");
                                switch (paramTypeNum) {
                                    case 0: {
                                        parameterType = DBSProcedureParameterKind.IN;
                                        break;
                                    }
                                    case 1: {
                                        parameterType = DBSProcedureParameterKind.OUT;
                                        break;
                                    }
                                    default: {
                                        parameterType = DBSProcedureParameterKind.UNKNOWN;
                                        break;
                                    }
                                }
                            } else {
                                parameterType = position == 0 ? DBSProcedureParameterKind.RETURN : DBSProcedureParameterKind.IN;
                            }
                            FireBirdProcedureParameter parameter = new FireBirdProcedureParameter(this, parameterName, typeName, dataType, position, columnSize, scale, precision, notNull, remarks, parameterType, defaultValue);
                            this.addColumn(parameter);
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException((Throwable)e, this.getDataSource());
        }
    }

    public void setObjectDefinitionText(String source) {
        this.setSource(source);
    }
}

