/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.io.StringReader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.relique.jdbc.csv.CsvResources;
import org.relique.jdbc.csv.Expression;
import org.relique.jdbc.csv.ExpressionParser;
import org.relique.jdbc.csv.LogicalExpression;
import org.relique.jdbc.csv.OrderByEntry;
import org.relique.jdbc.csv.ParseException;
import org.relique.jdbc.csv.ParsedExpression;
import org.relique.jdbc.csv.ParsedStatement;
import org.relique.jdbc.csv.ParsedTable;
import org.relique.jdbc.csv.QueryEnvEntry;

public class SqlParser {
    private List<String> tableNames;
    private List<String> tableAliases;
    private ParsedExpression whereClause;
    private List<Object[]> environment;
    private List<Expression> groupByColumns;
    private ParsedExpression havingClause;
    private List<Object[]> orderByColumns;
    private int limit;
    private int offset;
    private boolean isDistinct;

    public void setPlaceholdersValues(Object[] values) {
        if (this.whereClause != null) {
            this.whereClause.setPlaceholdersValues(values);
        }
    }

    public int getPlaceholdersCount() {
        if (this.whereClause != null) {
            return this.whereClause.getPlaceholdersCount();
        }
        return 0;
    }

    public List<String> getTableNames() {
        return this.tableNames;
    }

    public List<String> getTableAliases() {
        return this.tableAliases;
    }

    public List<Object[]> getColumns() {
        return this.environment;
    }

    public void parse(String sql) throws SQLException, ParseException {
        this.tableNames = new ArrayList<String>();
        this.tableAliases = new ArrayList<String>();
        sql = sql + "\n";
        ExpressionParser cs2 = new ExpressionParser(new StringReader(sql));
        ParsedStatement parsedStatement = cs2.parseSingleStatement();
        this.setParsedStatement(parsedStatement);
    }

    public void setParsedStatement(ParsedStatement parsedStatement) throws SQLException {
        Expression cc;
        this.isDistinct = parsedStatement.isDistinct;
        if (!(parsedStatement.whereClause == null || parsedStatement.whereClause.content instanceof LogicalExpression && parsedStatement.whereClause.content.isValid())) {
            throw new SQLException(CsvResources.getString("whereNotLogical"));
        }
        this.whereClause = parsedStatement.whereClause;
        this.limit = parsedStatement.limit;
        this.offset = parsedStatement.offset;
        this.tableNames = new ArrayList<String>();
        this.tableAliases = new ArrayList<String>();
        for (ParsedTable parsedTable : parsedStatement.tableEntries) {
            if (parsedTable.isDerivedTable()) {
                throw new SQLException(CsvResources.getString("derivedTableNotSupported"));
            }
            this.tableNames.add(parsedTable.getTableName());
            this.tableAliases.add(parsedTable.getTableAlias());
        }
        this.environment = new ArrayList<Object[]>();
        for (ParsedExpression parsedExpression : parsedStatement.queryEntries) {
            if (parsedExpression == null) continue;
            cc = (QueryEnvEntry)parsedExpression.content;
            if (((QueryEnvEntry)cc).getExpression() instanceof LogicalExpression || !((QueryEnvEntry)cc).getExpression().isValid()) {
                throw new SQLException("invalidQueryExpression");
            }
            String key = ((QueryEnvEntry)cc).getKey();
            for (int i = 0; i < this.tableNames.size(); ++i) {
                if (this.tableAliases.get(i) != null && key.startsWith(this.tableAliases.get(i) + ".")) {
                    key = key.substring(this.tableAliases.get(i).length() + 1);
                    break;
                }
                if (this.tableNames.get(i) == null || !key.startsWith(this.tableNames.get(i).toUpperCase() + ".")) continue;
                key = key.substring(this.tableNames.get(i).length() + 1);
                break;
            }
            this.environment.add(new Object[]{key, ((QueryEnvEntry)cc).getExpression()});
        }
        if (this.environment.isEmpty()) {
            throw new SQLException(CsvResources.getString("noColumnsSelected"));
        }
        Iterator<ParsedExpression> it2 = parsedStatement.groupByEntries.iterator();
        if (it2.hasNext()) {
            this.groupByColumns = new ArrayList<Expression>();
        }
        while (it2.hasNext()) {
            cc = it2.next();
            this.groupByColumns.add(((ParsedExpression)cc).content);
        }
        if (parsedStatement.havingClause != null && !(parsedStatement.havingClause.content instanceof LogicalExpression) && parsedStatement.havingClause.content.isValid()) {
            throw new SQLException(CsvResources.getString("havingNotLogical"));
        }
        this.havingClause = parsedStatement.havingClause;
        Iterator<ParsedExpression> it3 = parsedStatement.orderByEntries.iterator();
        if (it3.hasNext()) {
            this.orderByColumns = new ArrayList<Object[]>();
        }
        while (it3.hasNext()) {
            ParsedExpression cc2 = it3.next();
            OrderByEntry entry = (OrderByEntry)cc2.content;
            int direction = entry.order.equalsIgnoreCase("ASC") ? 1 : -1;
            this.orderByColumns.add(new Object[]{direction, entry.expression});
        }
    }

    public String[] getColumnNames() {
        String[] result = new String[this.environment.size()];
        for (int i = 0; i < this.environment.size(); ++i) {
            Object[] entry = this.environment.get(i);
            result[i] = (String)entry[0];
        }
        return result;
    }

    public LogicalExpression getWhereClause() {
        return this.whereClause;
    }

    public List<Expression> getGroupByColumns() {
        return this.groupByColumns;
    }

    public LogicalExpression getHavingClause() {
        return this.havingClause;
    }

    public List<Object[]> getOrderByColumns() {
        return this.orderByColumns;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public String getAlias(int i) {
        Object[] o = this.environment.get(i);
        return (String)o[0];
    }

    public Expression getExpression(int i) {
        Object[] o = this.environment.get(i);
        return (Expression)o[1];
    }

    public boolean isDistinct() {
        return this.isDistinct;
    }
}

