/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.sql.SQLException;
import java.util.Map;
import org.relique.jdbc.csv.Expression;
import org.relique.jdbc.csv.SQLSumFunction;

class SQLAvgFunction
extends SQLSumFunction {
    public SQLAvgFunction(boolean isDistinct, Expression expression) {
        super(isDistinct, expression);
    }

    @Override
    public Object eval(Map<String, Object> env) throws SQLException {
        Object o = super.eval(env);
        if (o != null) {
            double average = ((Number)o).doubleValue() / (double)this.counter;
            o = new Double(average);
        }
        return o;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("AVG(");
        if (this.distinctValues != null) {
            sb.append("DISTINCT ");
        }
        sb.append(this.expression);
        sb.append(")");
        return sb.toString();
    }
}

