/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.io.IOException;
import java.io.LineNumberReader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Vector;
import org.relique.jdbc.csv.CsvDriver;
import org.relique.jdbc.csv.CsvResources;

public class CsvRawReader {
    private static final String EMPTY_STRING = "";
    private static final String ZERO_STRING = "0";
    private LineNumberReader input;
    private String tableName;
    private String tableAlias;
    private String[] columnNames;
    private String[] fieldValues;
    private String firstLineBuffer = null;
    private String separator = ",";
    private String headerLine = "";
    private boolean suppressHeaders = false;
    private boolean isHeaderFixedWidth = true;
    private Character quoteChar = Character.valueOf('\"');
    private boolean trimValues = true;
    private String comment = null;
    private boolean ignoreUnparseableLines;
    private String missingValue;
    private String quoteStyle;
    private ArrayList<int[]> fixedWidthColumns;
    private LinkedList<String> readAheadLines;
    private boolean readingAhead;
    private String[] previousFieldValues = null;

    public CsvRawReader(LineNumberReader in, String tableName, String tableAlias, String separator, boolean suppressHeaders, boolean isHeaderFixedWidth, Character quoteChar, String comment, String headerLine, boolean trimHeaders, boolean trimValues, int skipLeadingLines, boolean ignoreUnparseableLines, String missingValue, boolean defectiveHeaders, int skipLeadingDataLines, String quoteStyle, ArrayList<int[]> fixedWidthColumns) throws IOException, SQLException {
        int i;
        this.tableName = tableName;
        this.tableAlias = tableAlias;
        this.separator = separator;
        this.suppressHeaders = suppressHeaders;
        this.isHeaderFixedWidth = isHeaderFixedWidth;
        this.quoteChar = quoteChar;
        this.comment = comment;
        this.headerLine = headerLine;
        this.trimValues = trimValues;
        this.input = in;
        this.ignoreUnparseableLines = ignoreUnparseableLines;
        this.missingValue = missingValue;
        this.quoteStyle = quoteStyle;
        this.fixedWidthColumns = fixedWidthColumns;
        this.readAheadLines = new LinkedList();
        this.readingAhead = false;
        for (i = 0; i < skipLeadingLines; ++i) {
            in.readLine();
        }
        if (this.suppressHeaders) {
            if (this.headerLine != null) {
                this.columnNames = this.parseHeaderLine(this.headerLine, trimHeaders);
            } else {
                this.firstLineBuffer = this.getNextDataLine();
                String[] data = this.parseHeaderLine(this.firstLineBuffer, trimValues);
                this.columnNames = new String[data.length];
                for (int i2 = 0; i2 < data.length; ++i2) {
                    this.columnNames[i2] = "COLUMN" + String.valueOf(i2 + 1);
                }
                data = null;
            }
        } else {
            String tmpHeaderLine = this.getNextDataLine();
            this.columnNames = this.parseHeaderLine(tmpHeaderLine, trimHeaders);
            if (defectiveHeaders) {
                this.fixDefectiveHeaders();
            }
            HashSet<String> uniqueNames = new HashSet<String>();
            for (int i3 = 0; i3 < this.columnNames.length; ++i3) {
                uniqueNames.add(this.columnNames[i3]);
            }
            if (uniqueNames.size() != this.columnNames.length) {
                throw new SQLException(CsvResources.getString("duplicateColumns"));
            }
        }
        for (i = 0; i < skipLeadingDataLines; ++i) {
            in.readLine();
        }
    }

    private void fixDefectiveHeaders() {
        for (int i = 0; i < this.columnNames.length; ++i) {
            if (this.columnNames[i].length() != 0) continue;
            this.columnNames[i] = "COLUMN" + String.valueOf(i + 1);
        }
    }

    public boolean next() throws SQLException {
        this.previousFieldValues = this.fieldValues;
        this.fieldValues = new String[this.columnNames.length];
        String dataLine = null;
        try {
            if (this.suppressHeaders && this.firstLineBuffer != null) {
                dataLine = this.firstLineBuffer;
                this.firstLineBuffer = null;
            } else {
                dataLine = this.getNextDataLine();
            }
            if (dataLine == null) {
                this.input.close();
                return false;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new SQLException(e.toString());
        }
        String[] parsedFieldValues = this.parseLine(dataLine, this.trimValues);
        if (parsedFieldValues.length < this.fieldValues.length && this.missingValue != null) {
            System.arraycopy(parsedFieldValues, 0, this.fieldValues, 0, parsedFieldValues.length);
            for (int i = parsedFieldValues.length; i < this.fieldValues.length; ++i) {
                this.fieldValues[i] = this.missingValue;
            }
        } else {
            this.fieldValues = parsedFieldValues;
        }
        return true;
    }

    public void close() {
        try {
            this.readAheadLines.clear();
            this.input.close();
            this.firstLineBuffer = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected String getNextDataLine() throws IOException {
        String tmp = !this.readAheadLines.isEmpty() ? this.readAheadLines.removeFirst() : this.input.readLine();
        if (this.comment != null && tmp != null) {
            while (tmp != null && (tmp.length() == 0 || tmp.startsWith(this.comment))) {
                if (!this.readAheadLines.isEmpty()) {
                    tmp = this.readAheadLines.removeFirst();
                    continue;
                }
                tmp = this.input.readLine();
            }
            this.comment = null;
        }
        if (this.ignoreUnparseableLines && tmp != null && this.missingValue == null) {
            try {
                do {
                    this.readingAhead = true;
                    int fieldsCount = this.parseLine(tmp, true).length;
                    if (this.columnNames != null && this.columnNames.length == fieldsCount) {
                        break;
                    }
                    if (this.columnNames == null && fieldsCount != 1) {
                        break;
                    }
                    CsvDriver.writeLog("Ignoring row " + this.input.getLineNumber() + " Line=" + tmp);
                } while ((tmp = !this.readAheadLines.isEmpty() ? this.readAheadLines.removeFirst() : this.input.readLine()) != null);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            finally {
                this.readingAhead = false;
            }
        }
        return tmp;
    }

    public int getLineNumber() {
        return this.input.getLineNumber();
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public int[] getColumnSizes() {
        int[] retval;
        if (this.fixedWidthColumns != null) {
            retval = new int[this.fixedWidthColumns.size()];
            for (int i = 0; i < retval.length; ++i) {
                int[] columnIndexes = this.fixedWidthColumns.get(i);
                retval[i] = columnIndexes[1] - columnIndexes[0] + 1;
            }
        } else {
            retval = new int[this.columnNames.length];
            Arrays.fill(retval, 20);
        }
        return retval;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableAlias() {
        return this.tableAlias;
    }

    public String[] getFieldValues() {
        return this.fieldValues;
    }

    public String getField(int columnIndex) {
        if (columnIndex >= this.fieldValues.length) {
            return null;
        }
        String result = this.fieldValues[columnIndex];
        if (result != null) {
            result = result.trim();
        }
        return result;
    }

    protected String[] parseLine(String line, boolean trimValues) throws SQLException {
        String[] values = this.fixedWidthColumns != null ? this.parseFixedLine(line, trimValues) : this.parseCsvLine(line, trimValues);
        return values;
    }

    private String[] parseHeaderLine(String line, boolean trimValues) throws SQLException {
        String[] values = this.fixedWidthColumns != null && this.isHeaderFixedWidth ? this.parseFixedLine(line, trimValues) : this.parseCsvLine(line, trimValues);
        return values;
    }

    private String[] parseFixedLine(String line, boolean trimValues) throws SQLException {
        String[] values = new String[this.fixedWidthColumns.size()];
        if (line == null) {
            line = EMPTY_STRING;
        }
        for (int i = 0; i < values.length; ++i) {
            int[] columnIndexes = this.fixedWidthColumns.get(i);
            values[i] = columnIndexes[0] >= line.length() ? EMPTY_STRING : (columnIndexes[1] >= line.length() ? line.substring(columnIndexes[0], line.length()) : line.substring(columnIndexes[0], columnIndexes[1] + 1));
            values[i] = values[i].trim();
        }
        return values;
    }

    private String rtrim(String s) {
        int origLen;
        int len;
        for (len = origLen = s.length(); len > 0 && Character.isWhitespace(s.charAt(len - 1)); --len) {
        }
        if (len == origLen) {
            return s;
        }
        return s.substring(0, len);
    }

    private boolean isQuoteChar(char c) {
        return this.quoteChar != null && c == this.quoteChar.charValue();
    }

    private String createStringValue(StringBuilder columnValue, int columnIndex) {
        String s;
        int len = columnValue.length();
        if (len == 0) {
            s = EMPTY_STRING;
        } else if (len == 1 && columnValue.charAt(0) == '0') {
            s = ZERO_STRING;
        } else {
            s = columnValue.toString();
            if (this.previousFieldValues != null && this.previousFieldValues.length > columnIndex && this.previousFieldValues[columnIndex] != null && this.previousFieldValues[columnIndex].equals(s)) {
                s = this.previousFieldValues[columnIndex];
            }
        }
        return s;
    }

    private String[] parseCsvLine(String line, boolean trimValues) throws SQLException {
        Vector<String> values = new Vector<String>();
        boolean inQuotedString = false;
        int quotedLineNumber = 0;
        StringBuilder value = new StringBuilder(32);
        String orgLine = line;
        int currentPos = 0;
        boolean fullLine = false;
        while (!fullLine) {
            line = line + this.separator;
            for (currentPos = 0; currentPos < line.length(); ++currentPos) {
                char nextChar;
                char currentChar = line.charAt(currentPos);
                if (value.length() == 0 && this.isQuoteChar(currentChar) && !inQuotedString) {
                    inQuotedString = true;
                    quotedLineNumber = this.input.getLineNumber();
                    continue;
                }
                if (currentChar == '\\' && "C".equals(this.quoteStyle)) {
                    nextChar = line.charAt(currentPos + 1);
                    value.append(nextChar);
                    ++currentPos;
                    continue;
                }
                if (this.isQuoteChar(currentChar)) {
                    nextChar = line.charAt(currentPos + 1);
                    if (!inQuotedString) {
                        value.append(this.quoteChar.charValue());
                        continue;
                    }
                    if (this.isQuoteChar(nextChar)) {
                        value.append(this.quoteChar.charValue());
                        if (!"SQL".equals(this.quoteStyle)) continue;
                        ++currentPos;
                        continue;
                    }
                    while (trimValues && !this.atSeparator(line, currentPos + 1) && Character.isWhitespace(nextChar) && currentPos + 2 < line.length()) {
                        nextChar = line.charAt(currentPos + 2);
                        ++currentPos;
                    }
                    if (!this.atSeparator(line, currentPos + 1)) {
                        throw new SQLException(CsvResources.getString("expectedSeparator") + ": " + this.input.getLineNumber() + " " + (currentPos + 1) + ": " + orgLine);
                    }
                    values.add(this.createStringValue(value, values.size()));
                    value.setLength(0);
                    inQuotedString = false;
                    currentPos += this.separator.length();
                    continue;
                }
                if (this.atSeparator(line, currentPos)) {
                    if (inQuotedString) {
                        value.append(currentChar);
                        continue;
                    }
                    if (trimValues) {
                        values.add(this.rtrim(this.createStringValue(value, values.size())));
                    } else {
                        values.add(this.createStringValue(value, values.size()));
                    }
                    value.setLength(0);
                    if (this.separator.length() <= 1) continue;
                    currentPos += this.separator.length() - 1;
                    continue;
                }
                if (trimValues && Character.isWhitespace(currentChar) && value.length() == 0 && !inQuotedString) continue;
                value.append(currentChar);
            }
            if (inQuotedString) {
                value = new StringBuilder(value.substring(0, value.length() - 1));
                try {
                    String additionalLine;
                    if (this.readingAhead) {
                        additionalLine = this.input.readLine();
                        if (additionalLine != null) {
                            this.readAheadLines.addLast(additionalLine);
                        }
                    } else {
                        additionalLine = !this.readAheadLines.isEmpty() ? this.readAheadLines.removeFirst() : this.input.readLine();
                    }
                    if (additionalLine == null) {
                        throw new SQLException(CsvResources.getString("eofInQuotes") + ": " + quotedLineNumber);
                    }
                    line = "\n" + additionalLine;
                    if (orgLine != this.firstLineBuffer) continue;
                    this.firstLineBuffer = this.firstLineBuffer + "\n" + additionalLine;
                    continue;
                }
                catch (IOException e) {
                    throw new SQLException(e.toString());
                }
            }
            fullLine = true;
        }
        Object[] retVal = new String[values.size()];
        values.copyInto(retVal);
        return retVal;
    }

    private boolean atSeparator(String line, int currentPos) {
        boolean matchesSeparator = this.separator.length() == 1 ? line.charAt(currentPos) == this.separator.charAt(0) : line.regionMatches(currentPos, this.separator, 0, this.separator.length());
        return matchesSeparator;
    }
}

